/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.orc;

import java.io.File;
import java.util.concurrent.ExecutionException;
import org.apache.flink.orc.OrcFormatStatisticsReportTest;
import org.apache.flink.table.planner.plan.stats.FlinkStatistic;
import org.apache.flink.table.types.AbstractDataType;
import org.apache.flink.table.types.DataType;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class OrcFileSystemStatisticsReportTest
extends OrcFormatStatisticsReportTest {
    @Override
    @BeforeEach
    public void setup(@TempDir File file) throws Exception {
        super.setup(file);
    }

    @Test
    public void testOrcFileSystemStatisticsReportWithSingleFile() throws ExecutionException, InterruptedException {
        DataType dataType = this.tEnv.from("sourceTable").getResolvedSchema().toPhysicalRowDataType();
        this.tEnv.fromValues((AbstractDataType)dataType, (Iterable)this.getData()).executeInsert("sourceTable").await();
        FlinkStatistic statistic = this.getStatisticsFromOptimizedPlan("select * from sourceTable");
        OrcFileSystemStatisticsReportTest.assertOrcFormatTableStatsEquals(statistic.getTableStats(), 3, 1L);
    }
}

