/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.flink.kubernetes.shaded.com.fasterxml.jackson.core.JsonParser;
import org.apache.flink.kubernetes.shaded.com.fasterxml.jackson.databind.DeserializationContext;
import org.apache.flink.kubernetes.shaded.com.fasterxml.jackson.databind.JsonDeserializer;
import org.apache.flink.kubernetes.shaded.com.fasterxml.jackson.databind.JsonMappingException;
import org.apache.flink.kubernetes.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.GenericKubernetesResource;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.HasMetadata;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.KubernetesResource;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.runtime.RawExtension;

public class KubernetesDeserializer
extends JsonDeserializer<KubernetesResource> {
    private static final String KIND = "kind";
    private static final String API_VERSION = "apiVersion";
    private final Mapping mapping = new Mapping();
    private static Mapping DEFAULT_MAPPING;

    public KubernetesDeserializer() {
        this(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public KubernetesDeserializer(boolean scanClassloaders) {
        if (!scanClassloaders) return;
        Class<KubernetesDeserializer> clazz = KubernetesDeserializer.class;
        synchronized (KubernetesDeserializer.class) {
            if (DEFAULT_MAPPING == null) {
                DEFAULT_MAPPING = new Mapping();
                DEFAULT_MAPPING.registerClassesFromClassLoaders();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.mapping.mappings.putAll(KubernetesDeserializer.DEFAULT_MAPPING.mappings);
            return;
        }
    }

    @Override
    public KubernetesResource deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonNode node = (JsonNode)jp.readValueAsTree();
        return this.deserialize(jp, node);
    }

    final KubernetesResource deserialize(JsonParser jp, JsonNode node) throws IOException {
        if (node.isObject()) {
            return this.fromObjectNode(jp, node);
        }
        if (node.isArray()) {
            return this.fromArrayNode(jp, node);
        }
        Object object = node.traverse(jp.getCodec()).readValueAs(Object.class);
        if (object == null) {
            return null;
        }
        return new RawExtension(object);
    }

    private KubernetesResource fromArrayNode(JsonParser jp, JsonNode node) throws IOException {
        Iterator<JsonNode> iterator = node.elements();
        ArrayList<HasMetadata> list = new ArrayList<HasMetadata>();
        while (iterator.hasNext()) {
            JsonNode jsonNode = iterator.next();
            if (jsonNode.isObject()) {
                KubernetesResource resource = this.fromObjectNode(jp, jsonNode);
                if (!(resource instanceof HasMetadata)) {
                    throw new JsonMappingException(jp, "Cannot parse a nested array containing a non-HasMetadata resource");
                }
                list.add((HasMetadata)resource);
                continue;
            }
            throw new JsonMappingException(jp, "Cannot parse a nested array containing non-object resource");
        }
        return ((KubernetesListBuilder)new KubernetesListBuilder().withItems(list)).build();
    }

    private KubernetesResource fromObjectNode(JsonParser jp, JsonNode node) throws IOException {
        TypeKey key = this.createKey(node);
        Class<? extends KubernetesResource> resourceType = this.mapping.getForKey(key);
        if (resourceType == null) {
            if (key == null) {
                return jp.getCodec().treeToValue(node, RawExtension.class);
            }
            return jp.getCodec().treeToValue(node, GenericKubernetesResource.class);
        }
        if (KubernetesResource.class.isAssignableFrom(resourceType)) {
            return jp.getCodec().treeToValue(node, resourceType);
        }
        throw new JsonMappingException(jp, String.format("There's a class loading issue, %s is registered as a KubernetesResource, but is not an instance of KubernetesResource", resourceType.getName()));
    }

    private TypeKey createKey(JsonNode node) {
        JsonNode apiVersion = node.get(API_VERSION);
        JsonNode kind = node.get(KIND);
        return this.mapping.createKey(apiVersion != null ? apiVersion.textValue() : null, kind != null ? kind.textValue() : null);
    }

    public void registerCustomKind(String apiVersion, String kind, Class<? extends KubernetesResource> clazz) {
        this.mapping.registerKind(apiVersion, kind, clazz);
    }

    public void registerKubernetesResource(Class<? extends KubernetesResource> clazz) {
        this.mapping.addMapping(clazz);
    }

    public Class<? extends KubernetesResource> getRegisteredKind(String apiVersion, String kind) {
        return this.mapping.getForKey(this.mapping.createKey(apiVersion, kind));
    }

    static class Mapping {
        private final Map<TypeKey, Class<? extends KubernetesResource>> mappings = new ConcurrentHashMap<TypeKey, Class<? extends KubernetesResource>>();

        Mapping() {
        }

        public Class<? extends KubernetesResource> getForKey(TypeKey key) {
            if (key == null) {
                return null;
            }
            return this.mappings.get(key);
        }

        public void registerKind(String apiVersion, String kind, Class<? extends KubernetesResource> clazz) {
            Optional.ofNullable(this.createKey(apiVersion, kind)).ifPresent(k -> this.mappings.put((TypeKey)k, clazz));
        }

        TypeKey createKey(String apiVersion, String kind) {
            if (kind == null || apiVersion == null) {
                return null;
            }
            String[] versionParts = new String[]{null, apiVersion};
            if (apiVersion.contains("/")) {
                versionParts = apiVersion.split("/", 2);
            }
            return new TypeKey(kind, versionParts[0], versionParts[1]);
        }

        void registerClassesFromClassLoaders() {
            Stream.of(Thread.currentThread().getContextClassLoader(), KubernetesDeserializer.class.getClassLoader()).filter(Objects::nonNull).map(cl -> ServiceLoader.load(KubernetesResource.class, cl)).map(ServiceLoader::iterator).map(i -> () -> i).flatMap(i -> StreamSupport.stream(i.spliterator(), false)).map(Object::getClass).forEach(this::addMapping);
        }

        TypeKey getKeyFromClass(Class<? extends KubernetesResource> clazz) {
            String apiGroup = HasMetadata.getGroup(clazz);
            String apiVersion = HasMetadata.getVersion(clazz);
            String kind = HasMetadata.getKind(clazz);
            if (apiGroup != null && !apiGroup.isEmpty() && apiVersion != null && !apiVersion.isEmpty()) {
                return new TypeKey(kind, apiGroup, apiVersion);
            }
            if (apiVersion != null && !apiVersion.isEmpty()) {
                return this.createKey(apiVersion, kind);
            }
            return null;
        }

        private void addMapping(Class<? extends KubernetesResource> clazz) {
            TypeKey keyFromClass = this.getKeyFromClass(clazz);
            if (keyFromClass == null) {
                return;
            }
            this.mappings.put(keyFromClass, clazz);
            if (keyFromClass.apiGroup != null && keyFromClass.apiGroup.endsWith(".openshift.io")) {
                this.mappings.putIfAbsent(new TypeKey(keyFromClass.kind, null, keyFromClass.version), clazz);
            }
        }
    }

    static class TypeKey {
        final String kind;
        final String apiGroup;
        final String version;

        TypeKey(String kind, String apiGroup, String version) {
            this.kind = kind;
            this.apiGroup = apiGroup;
            this.version = version;
        }

        public int hashCode() {
            return Objects.hash(this.kind, this.apiGroup, this.version);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof TypeKey)) {
                return false;
            }
            TypeKey o = (TypeKey)obj;
            return Objects.equals(this.kind, o.kind) && Objects.equals(this.apiGroup, o.apiGroup) && Objects.equals(this.version, o.version);
        }
    }
}

