/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.resource.v1beta2;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.BaseFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.Nested;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.resource.v1beta2.DeviceClaimConfiguration;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.resource.v1beta2.OpaqueDeviceConfiguration;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.resource.v1beta2.OpaqueDeviceConfigurationBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.resource.v1beta2.OpaqueDeviceConfigurationFluent;

public class DeviceClaimConfigurationFluent<A extends DeviceClaimConfigurationFluent<A>>
extends BaseFluent<A> {
    private OpaqueDeviceConfigurationBuilder opaque;
    private List<String> requests = new ArrayList<String>();
    private Map<String, Object> additionalProperties;

    public DeviceClaimConfigurationFluent() {
    }

    public DeviceClaimConfigurationFluent(DeviceClaimConfiguration instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(DeviceClaimConfiguration instance) {
        DeviceClaimConfiguration deviceClaimConfiguration = instance = instance != null ? instance : new DeviceClaimConfiguration();
        if (instance != null) {
            this.withOpaque(instance.getOpaque());
            this.withRequests(instance.getRequests());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public OpaqueDeviceConfiguration buildOpaque() {
        return this.opaque != null ? this.opaque.build() : null;
    }

    public A withOpaque(OpaqueDeviceConfiguration opaque) {
        this._visitables.remove("opaque");
        if (opaque != null) {
            this.opaque = new OpaqueDeviceConfigurationBuilder(opaque);
            this._visitables.get("opaque").add(this.opaque);
        } else {
            this.opaque = null;
            this._visitables.get("opaque").remove(this.opaque);
        }
        return (A)this;
    }

    public boolean hasOpaque() {
        return this.opaque != null;
    }

    public A withNewOpaque(String driver, Object parameters) {
        return this.withOpaque(new OpaqueDeviceConfiguration(driver, parameters));
    }

    public OpaqueNested<A> withNewOpaque() {
        return new OpaqueNested(null);
    }

    public OpaqueNested<A> withNewOpaqueLike(OpaqueDeviceConfiguration item) {
        return new OpaqueNested(item);
    }

    public OpaqueNested<A> editOpaque() {
        return this.withNewOpaqueLike(Optional.ofNullable(this.buildOpaque()).orElse(null));
    }

    public OpaqueNested<A> editOrNewOpaque() {
        return this.withNewOpaqueLike(Optional.ofNullable(this.buildOpaque()).orElse(new OpaqueDeviceConfigurationBuilder().build()));
    }

    public OpaqueNested<A> editOrNewOpaqueLike(OpaqueDeviceConfiguration item) {
        return this.withNewOpaqueLike(Optional.ofNullable(this.buildOpaque()).orElse(item));
    }

    public A addToRequests(int index, String item) {
        if (this.requests == null) {
            this.requests = new ArrayList<String>();
        }
        this.requests.add(index, item);
        return (A)this;
    }

    public A setToRequests(int index, String item) {
        if (this.requests == null) {
            this.requests = new ArrayList<String>();
        }
        this.requests.set(index, item);
        return (A)this;
    }

    public A addToRequests(String ... items) {
        if (this.requests == null) {
            this.requests = new ArrayList<String>();
        }
        for (String item : items) {
            this.requests.add(item);
        }
        return (A)this;
    }

    public A addAllToRequests(Collection<String> items) {
        if (this.requests == null) {
            this.requests = new ArrayList<String>();
        }
        for (String item : items) {
            this.requests.add(item);
        }
        return (A)this;
    }

    public A removeFromRequests(String ... items) {
        if (this.requests == null) {
            return (A)this;
        }
        for (String item : items) {
            this.requests.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromRequests(Collection<String> items) {
        if (this.requests == null) {
            return (A)this;
        }
        for (String item : items) {
            this.requests.remove(item);
        }
        return (A)this;
    }

    public List<String> getRequests() {
        return this.requests;
    }

    public String getRequest(int index) {
        return this.requests.get(index);
    }

    public String getFirstRequest() {
        return this.requests.get(0);
    }

    public String getLastRequest() {
        return this.requests.get(this.requests.size() - 1);
    }

    public String getMatchingRequest(Predicate<String> predicate) {
        for (String item : this.requests) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingRequest(Predicate<String> predicate) {
        for (String item : this.requests) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withRequests(List<String> requests) {
        if (requests != null) {
            this.requests = new ArrayList<String>();
            for (String item : requests) {
                this.addToRequests(item);
            }
        } else {
            this.requests = null;
        }
        return (A)this;
    }

    public A withRequests(String ... requests) {
        if (this.requests != null) {
            this.requests.clear();
            this._visitables.remove("requests");
        }
        if (requests != null) {
            for (String item : requests) {
                this.addToRequests(item);
            }
        }
        return (A)this;
    }

    public boolean hasRequests() {
        return this.requests != null && !this.requests.isEmpty();
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DeviceClaimConfigurationFluent that = (DeviceClaimConfigurationFluent)o;
        if (!Objects.equals(this.opaque, that.opaque)) {
            return false;
        }
        if (!Objects.equals(this.requests, that.requests)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.opaque, this.requests, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.opaque != null) {
            sb.append("opaque:");
            sb.append(String.valueOf(this.opaque) + ",");
        }
        if (this.requests != null && !this.requests.isEmpty()) {
            sb.append("requests:");
            sb.append(String.valueOf(this.requests) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class OpaqueNested<N>
    extends OpaqueDeviceConfigurationFluent<OpaqueNested<N>>
    implements Nested<N> {
        OpaqueDeviceConfigurationBuilder builder;

        OpaqueNested(OpaqueDeviceConfiguration item) {
            this.builder = new OpaqueDeviceConfigurationBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)DeviceClaimConfigurationFluent.this.withOpaque(this.builder.build());
        }

        public N endOpaque() {
            return this.and();
        }
    }
}

