/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.apiextensions.v1;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.BaseFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.Nested;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.apiextensions.v1.WebhookClientConfig;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.apiextensions.v1.WebhookClientConfigBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.apiextensions.v1.WebhookClientConfigFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.apiextensions.v1.WebhookConversion;

public class WebhookConversionFluent<A extends WebhookConversionFluent<A>>
extends BaseFluent<A> {
    private WebhookClientConfigBuilder clientConfig;
    private List<String> conversionReviewVersions = new ArrayList<String>();
    private Map<String, Object> additionalProperties;

    public WebhookConversionFluent() {
    }

    public WebhookConversionFluent(WebhookConversion instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(WebhookConversion instance) {
        WebhookConversion webhookConversion = instance = instance != null ? instance : new WebhookConversion();
        if (instance != null) {
            this.withClientConfig(instance.getClientConfig());
            this.withConversionReviewVersions(instance.getConversionReviewVersions());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public WebhookClientConfig buildClientConfig() {
        return this.clientConfig != null ? this.clientConfig.build() : null;
    }

    public A withClientConfig(WebhookClientConfig clientConfig) {
        this._visitables.remove("clientConfig");
        if (clientConfig != null) {
            this.clientConfig = new WebhookClientConfigBuilder(clientConfig);
            this._visitables.get("clientConfig").add(this.clientConfig);
        } else {
            this.clientConfig = null;
            this._visitables.get("clientConfig").remove(this.clientConfig);
        }
        return (A)this;
    }

    public boolean hasClientConfig() {
        return this.clientConfig != null;
    }

    public ClientConfigNested<A> withNewClientConfig() {
        return new ClientConfigNested(null);
    }

    public ClientConfigNested<A> withNewClientConfigLike(WebhookClientConfig item) {
        return new ClientConfigNested(item);
    }

    public ClientConfigNested<A> editClientConfig() {
        return this.withNewClientConfigLike(Optional.ofNullable(this.buildClientConfig()).orElse(null));
    }

    public ClientConfigNested<A> editOrNewClientConfig() {
        return this.withNewClientConfigLike(Optional.ofNullable(this.buildClientConfig()).orElse(new WebhookClientConfigBuilder().build()));
    }

    public ClientConfigNested<A> editOrNewClientConfigLike(WebhookClientConfig item) {
        return this.withNewClientConfigLike(Optional.ofNullable(this.buildClientConfig()).orElse(item));
    }

    public A addToConversionReviewVersions(int index, String item) {
        if (this.conversionReviewVersions == null) {
            this.conversionReviewVersions = new ArrayList<String>();
        }
        this.conversionReviewVersions.add(index, item);
        return (A)this;
    }

    public A setToConversionReviewVersions(int index, String item) {
        if (this.conversionReviewVersions == null) {
            this.conversionReviewVersions = new ArrayList<String>();
        }
        this.conversionReviewVersions.set(index, item);
        return (A)this;
    }

    public A addToConversionReviewVersions(String ... items) {
        if (this.conversionReviewVersions == null) {
            this.conversionReviewVersions = new ArrayList<String>();
        }
        for (String item : items) {
            this.conversionReviewVersions.add(item);
        }
        return (A)this;
    }

    public A addAllToConversionReviewVersions(Collection<String> items) {
        if (this.conversionReviewVersions == null) {
            this.conversionReviewVersions = new ArrayList<String>();
        }
        for (String item : items) {
            this.conversionReviewVersions.add(item);
        }
        return (A)this;
    }

    public A removeFromConversionReviewVersions(String ... items) {
        if (this.conversionReviewVersions == null) {
            return (A)this;
        }
        for (String item : items) {
            this.conversionReviewVersions.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromConversionReviewVersions(Collection<String> items) {
        if (this.conversionReviewVersions == null) {
            return (A)this;
        }
        for (String item : items) {
            this.conversionReviewVersions.remove(item);
        }
        return (A)this;
    }

    public List<String> getConversionReviewVersions() {
        return this.conversionReviewVersions;
    }

    public String getConversionReviewVersion(int index) {
        return this.conversionReviewVersions.get(index);
    }

    public String getFirstConversionReviewVersion() {
        return this.conversionReviewVersions.get(0);
    }

    public String getLastConversionReviewVersion() {
        return this.conversionReviewVersions.get(this.conversionReviewVersions.size() - 1);
    }

    public String getMatchingConversionReviewVersion(Predicate<String> predicate) {
        for (String item : this.conversionReviewVersions) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingConversionReviewVersion(Predicate<String> predicate) {
        for (String item : this.conversionReviewVersions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withConversionReviewVersions(List<String> conversionReviewVersions) {
        if (conversionReviewVersions != null) {
            this.conversionReviewVersions = new ArrayList<String>();
            for (String item : conversionReviewVersions) {
                this.addToConversionReviewVersions(item);
            }
        } else {
            this.conversionReviewVersions = null;
        }
        return (A)this;
    }

    public A withConversionReviewVersions(String ... conversionReviewVersions) {
        if (this.conversionReviewVersions != null) {
            this.conversionReviewVersions.clear();
            this._visitables.remove("conversionReviewVersions");
        }
        if (conversionReviewVersions != null) {
            for (String item : conversionReviewVersions) {
                this.addToConversionReviewVersions(item);
            }
        }
        return (A)this;
    }

    public boolean hasConversionReviewVersions() {
        return this.conversionReviewVersions != null && !this.conversionReviewVersions.isEmpty();
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        WebhookConversionFluent that = (WebhookConversionFluent)o;
        if (!Objects.equals(this.clientConfig, that.clientConfig)) {
            return false;
        }
        if (!Objects.equals(this.conversionReviewVersions, that.conversionReviewVersions)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.clientConfig, this.conversionReviewVersions, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.clientConfig != null) {
            sb.append("clientConfig:");
            sb.append(String.valueOf(this.clientConfig) + ",");
        }
        if (this.conversionReviewVersions != null && !this.conversionReviewVersions.isEmpty()) {
            sb.append("conversionReviewVersions:");
            sb.append(String.valueOf(this.conversionReviewVersions) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ClientConfigNested<N>
    extends WebhookClientConfigFluent<ClientConfigNested<N>>
    implements Nested<N> {
        WebhookClientConfigBuilder builder;

        ClientConfigNested(WebhookClientConfig item) {
            this.builder = new WebhookClientConfigBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)WebhookConversionFluent.this.withClientConfig(this.builder.build());
        }

        public N endClientConfig() {
            return this.and();
        }
    }
}

