/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.BaseFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.Nested;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.Cluster;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.NamedExtension;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.NamedExtensionBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.NamedExtensionFluent;

public class ClusterFluent<A extends ClusterFluent<A>>
extends BaseFluent<A> {
    private String certificateAuthority;
    private String certificateAuthorityData;
    private Boolean disableCompression;
    private ArrayList<NamedExtensionBuilder> extensions = new ArrayList();
    private Boolean insecureSkipTlsVerify;
    private String proxyUrl;
    private String server;
    private String tlsServerName;
    private Map<String, Object> additionalProperties;

    public ClusterFluent() {
    }

    public ClusterFluent(Cluster instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Cluster instance) {
        Cluster cluster = instance = instance != null ? instance : new Cluster();
        if (instance != null) {
            this.withCertificateAuthority(instance.getCertificateAuthority());
            this.withCertificateAuthorityData(instance.getCertificateAuthorityData());
            this.withDisableCompression(instance.getDisableCompression());
            this.withExtensions(instance.getExtensions());
            this.withInsecureSkipTlsVerify(instance.getInsecureSkipTlsVerify());
            this.withProxyUrl(instance.getProxyUrl());
            this.withServer(instance.getServer());
            this.withTlsServerName(instance.getTlsServerName());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getCertificateAuthority() {
        return this.certificateAuthority;
    }

    public A withCertificateAuthority(String certificateAuthority) {
        this.certificateAuthority = certificateAuthority;
        return (A)this;
    }

    public boolean hasCertificateAuthority() {
        return this.certificateAuthority != null;
    }

    public String getCertificateAuthorityData() {
        return this.certificateAuthorityData;
    }

    public A withCertificateAuthorityData(String certificateAuthorityData) {
        this.certificateAuthorityData = certificateAuthorityData;
        return (A)this;
    }

    public boolean hasCertificateAuthorityData() {
        return this.certificateAuthorityData != null;
    }

    public Boolean getDisableCompression() {
        return this.disableCompression;
    }

    public A withDisableCompression(Boolean disableCompression) {
        this.disableCompression = disableCompression;
        return (A)this;
    }

    public boolean hasDisableCompression() {
        return this.disableCompression != null;
    }

    public A addToExtensions(int index, NamedExtension item) {
        if (this.extensions == null) {
            this.extensions = new ArrayList();
        }
        NamedExtensionBuilder builder = new NamedExtensionBuilder(item);
        if (index < 0 || index >= this.extensions.size()) {
            this._visitables.get("extensions").add(builder);
            this.extensions.add(builder);
        } else {
            this._visitables.get("extensions").add(builder);
            this.extensions.add(index, builder);
        }
        return (A)this;
    }

    public A setToExtensions(int index, NamedExtension item) {
        if (this.extensions == null) {
            this.extensions = new ArrayList();
        }
        NamedExtensionBuilder builder = new NamedExtensionBuilder(item);
        if (index < 0 || index >= this.extensions.size()) {
            this._visitables.get("extensions").add(builder);
            this.extensions.add(builder);
        } else {
            this._visitables.get("extensions").add(builder);
            this.extensions.set(index, builder);
        }
        return (A)this;
    }

    public A addToExtensions(NamedExtension ... items) {
        if (this.extensions == null) {
            this.extensions = new ArrayList();
        }
        for (NamedExtension item : items) {
            NamedExtensionBuilder builder = new NamedExtensionBuilder(item);
            this._visitables.get("extensions").add(builder);
            this.extensions.add(builder);
        }
        return (A)this;
    }

    public A addAllToExtensions(Collection<NamedExtension> items) {
        if (this.extensions == null) {
            this.extensions = new ArrayList();
        }
        for (NamedExtension item : items) {
            NamedExtensionBuilder builder = new NamedExtensionBuilder(item);
            this._visitables.get("extensions").add(builder);
            this.extensions.add(builder);
        }
        return (A)this;
    }

    public A removeFromExtensions(NamedExtension ... items) {
        if (this.extensions == null) {
            return (A)this;
        }
        for (NamedExtension item : items) {
            NamedExtensionBuilder builder = new NamedExtensionBuilder(item);
            this._visitables.get("extensions").remove(builder);
            this.extensions.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromExtensions(Collection<NamedExtension> items) {
        if (this.extensions == null) {
            return (A)this;
        }
        for (NamedExtension item : items) {
            NamedExtensionBuilder builder = new NamedExtensionBuilder(item);
            this._visitables.get("extensions").remove(builder);
            this.extensions.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromExtensions(Predicate<NamedExtensionBuilder> predicate) {
        if (this.extensions == null) {
            return (A)this;
        }
        Iterator<NamedExtensionBuilder> each = this.extensions.iterator();
        Object visitables = this._visitables.get("extensions");
        while (each.hasNext()) {
            NamedExtensionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<NamedExtension> buildExtensions() {
        return this.extensions != null ? ClusterFluent.build(this.extensions) : null;
    }

    public NamedExtension buildExtension(int index) {
        return this.extensions.get(index).build();
    }

    public NamedExtension buildFirstExtension() {
        return this.extensions.get(0).build();
    }

    public NamedExtension buildLastExtension() {
        return this.extensions.get(this.extensions.size() - 1).build();
    }

    public NamedExtension buildMatchingExtension(Predicate<NamedExtensionBuilder> predicate) {
        for (NamedExtensionBuilder item : this.extensions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingExtension(Predicate<NamedExtensionBuilder> predicate) {
        for (NamedExtensionBuilder item : this.extensions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withExtensions(List<NamedExtension> extensions) {
        if (this.extensions != null) {
            this._visitables.get("extensions").clear();
        }
        if (extensions != null) {
            this.extensions = new ArrayList();
            for (NamedExtension item : extensions) {
                this.addToExtensions(item);
            }
        } else {
            this.extensions = null;
        }
        return (A)this;
    }

    public A withExtensions(NamedExtension ... extensions) {
        if (this.extensions != null) {
            this.extensions.clear();
            this._visitables.remove("extensions");
        }
        if (extensions != null) {
            for (NamedExtension item : extensions) {
                this.addToExtensions(item);
            }
        }
        return (A)this;
    }

    public boolean hasExtensions() {
        return this.extensions != null && !this.extensions.isEmpty();
    }

    public A addNewExtension(Object extension, String name) {
        return this.addToExtensions(new NamedExtension(extension, name));
    }

    public ExtensionsNested<A> addNewExtension() {
        return new ExtensionsNested(-1, null);
    }

    public ExtensionsNested<A> addNewExtensionLike(NamedExtension item) {
        return new ExtensionsNested(-1, item);
    }

    public ExtensionsNested<A> setNewExtensionLike(int index, NamedExtension item) {
        return new ExtensionsNested(index, item);
    }

    public ExtensionsNested<A> editExtension(int index) {
        if (this.extensions.size() <= index) {
            throw new RuntimeException("Can't edit extensions. Index exceeds size.");
        }
        return this.setNewExtensionLike(index, this.buildExtension(index));
    }

    public ExtensionsNested<A> editFirstExtension() {
        if (this.extensions.size() == 0) {
            throw new RuntimeException("Can't edit first extensions. The list is empty.");
        }
        return this.setNewExtensionLike(0, this.buildExtension(0));
    }

    public ExtensionsNested<A> editLastExtension() {
        int index = this.extensions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last extensions. The list is empty.");
        }
        return this.setNewExtensionLike(index, this.buildExtension(index));
    }

    public ExtensionsNested<A> editMatchingExtension(Predicate<NamedExtensionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.extensions.size(); ++i) {
            if (!predicate.test(this.extensions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching extensions. No match found.");
        }
        return this.setNewExtensionLike(index, this.buildExtension(index));
    }

    public Boolean getInsecureSkipTlsVerify() {
        return this.insecureSkipTlsVerify;
    }

    public A withInsecureSkipTlsVerify(Boolean insecureSkipTlsVerify) {
        this.insecureSkipTlsVerify = insecureSkipTlsVerify;
        return (A)this;
    }

    public boolean hasInsecureSkipTlsVerify() {
        return this.insecureSkipTlsVerify != null;
    }

    public String getProxyUrl() {
        return this.proxyUrl;
    }

    public A withProxyUrl(String proxyUrl) {
        this.proxyUrl = proxyUrl;
        return (A)this;
    }

    public boolean hasProxyUrl() {
        return this.proxyUrl != null;
    }

    public String getServer() {
        return this.server;
    }

    public A withServer(String server) {
        this.server = server;
        return (A)this;
    }

    public boolean hasServer() {
        return this.server != null;
    }

    public String getTlsServerName() {
        return this.tlsServerName;
    }

    public A withTlsServerName(String tlsServerName) {
        this.tlsServerName = tlsServerName;
        return (A)this;
    }

    public boolean hasTlsServerName() {
        return this.tlsServerName != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ClusterFluent that = (ClusterFluent)o;
        if (!Objects.equals(this.certificateAuthority, that.certificateAuthority)) {
            return false;
        }
        if (!Objects.equals(this.certificateAuthorityData, that.certificateAuthorityData)) {
            return false;
        }
        if (!Objects.equals(this.disableCompression, that.disableCompression)) {
            return false;
        }
        if (!Objects.equals(this.extensions, that.extensions)) {
            return false;
        }
        if (!Objects.equals(this.insecureSkipTlsVerify, that.insecureSkipTlsVerify)) {
            return false;
        }
        if (!Objects.equals(this.proxyUrl, that.proxyUrl)) {
            return false;
        }
        if (!Objects.equals(this.server, that.server)) {
            return false;
        }
        if (!Objects.equals(this.tlsServerName, that.tlsServerName)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.certificateAuthority, this.certificateAuthorityData, this.disableCompression, this.extensions, this.insecureSkipTlsVerify, this.proxyUrl, this.server, this.tlsServerName, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.certificateAuthority != null) {
            sb.append("certificateAuthority:");
            sb.append(this.certificateAuthority + ",");
        }
        if (this.certificateAuthorityData != null) {
            sb.append("certificateAuthorityData:");
            sb.append(this.certificateAuthorityData + ",");
        }
        if (this.disableCompression != null) {
            sb.append("disableCompression:");
            sb.append(this.disableCompression + ",");
        }
        if (this.extensions != null && !this.extensions.isEmpty()) {
            sb.append("extensions:");
            sb.append(String.valueOf(this.extensions) + ",");
        }
        if (this.insecureSkipTlsVerify != null) {
            sb.append("insecureSkipTlsVerify:");
            sb.append(this.insecureSkipTlsVerify + ",");
        }
        if (this.proxyUrl != null) {
            sb.append("proxyUrl:");
            sb.append(this.proxyUrl + ",");
        }
        if (this.server != null) {
            sb.append("server:");
            sb.append(this.server + ",");
        }
        if (this.tlsServerName != null) {
            sb.append("tlsServerName:");
            sb.append(this.tlsServerName + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withDisableCompression() {
        return this.withDisableCompression(true);
    }

    public A withInsecureSkipTlsVerify() {
        return this.withInsecureSkipTlsVerify(true);
    }

    public class ExtensionsNested<N>
    extends NamedExtensionFluent<ExtensionsNested<N>>
    implements Nested<N> {
        NamedExtensionBuilder builder;
        int index;

        ExtensionsNested(int index, NamedExtension item) {
            this.index = index;
            this.builder = new NamedExtensionBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ClusterFluent.this.setToExtensions(this.index, this.builder.build());
        }

        public N endExtension() {
            return this.and();
        }
    }
}

