/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.BaseFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.Nested;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.APIGroup;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.APIGroupBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.APIGroupFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.APIGroupList;

public class APIGroupListFluent<A extends APIGroupListFluent<A>>
extends BaseFluent<A> {
    private String apiVersion;
    private ArrayList<APIGroupBuilder> groups = new ArrayList();
    private String kind;
    private Map<String, Object> additionalProperties;

    public APIGroupListFluent() {
    }

    public APIGroupListFluent(APIGroupList instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(APIGroupList instance) {
        APIGroupList aPIGroupList = instance = instance != null ? instance : new APIGroupList();
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withGroups(instance.getGroups());
            this.withKind(instance.getKind());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    public boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public A addToGroups(int index, APIGroup item) {
        if (this.groups == null) {
            this.groups = new ArrayList();
        }
        APIGroupBuilder builder = new APIGroupBuilder(item);
        if (index < 0 || index >= this.groups.size()) {
            this._visitables.get("groups").add(builder);
            this.groups.add(builder);
        } else {
            this._visitables.get("groups").add(builder);
            this.groups.add(index, builder);
        }
        return (A)this;
    }

    public A setToGroups(int index, APIGroup item) {
        if (this.groups == null) {
            this.groups = new ArrayList();
        }
        APIGroupBuilder builder = new APIGroupBuilder(item);
        if (index < 0 || index >= this.groups.size()) {
            this._visitables.get("groups").add(builder);
            this.groups.add(builder);
        } else {
            this._visitables.get("groups").add(builder);
            this.groups.set(index, builder);
        }
        return (A)this;
    }

    public A addToGroups(APIGroup ... items) {
        if (this.groups == null) {
            this.groups = new ArrayList();
        }
        for (APIGroup item : items) {
            APIGroupBuilder builder = new APIGroupBuilder(item);
            this._visitables.get("groups").add(builder);
            this.groups.add(builder);
        }
        return (A)this;
    }

    public A addAllToGroups(Collection<APIGroup> items) {
        if (this.groups == null) {
            this.groups = new ArrayList();
        }
        for (APIGroup item : items) {
            APIGroupBuilder builder = new APIGroupBuilder(item);
            this._visitables.get("groups").add(builder);
            this.groups.add(builder);
        }
        return (A)this;
    }

    public A removeFromGroups(APIGroup ... items) {
        if (this.groups == null) {
            return (A)this;
        }
        for (APIGroup item : items) {
            APIGroupBuilder builder = new APIGroupBuilder(item);
            this._visitables.get("groups").remove(builder);
            this.groups.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromGroups(Collection<APIGroup> items) {
        if (this.groups == null) {
            return (A)this;
        }
        for (APIGroup item : items) {
            APIGroupBuilder builder = new APIGroupBuilder(item);
            this._visitables.get("groups").remove(builder);
            this.groups.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromGroups(Predicate<APIGroupBuilder> predicate) {
        if (this.groups == null) {
            return (A)this;
        }
        Iterator<APIGroupBuilder> each = this.groups.iterator();
        Object visitables = this._visitables.get("groups");
        while (each.hasNext()) {
            APIGroupBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<APIGroup> buildGroups() {
        return this.groups != null ? APIGroupListFluent.build(this.groups) : null;
    }

    public APIGroup buildGroup(int index) {
        return this.groups.get(index).build();
    }

    public APIGroup buildFirstGroup() {
        return this.groups.get(0).build();
    }

    public APIGroup buildLastGroup() {
        return this.groups.get(this.groups.size() - 1).build();
    }

    public APIGroup buildMatchingGroup(Predicate<APIGroupBuilder> predicate) {
        for (APIGroupBuilder item : this.groups) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingGroup(Predicate<APIGroupBuilder> predicate) {
        for (APIGroupBuilder item : this.groups) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withGroups(List<APIGroup> groups) {
        if (this.groups != null) {
            this._visitables.get("groups").clear();
        }
        if (groups != null) {
            this.groups = new ArrayList();
            for (APIGroup item : groups) {
                this.addToGroups(item);
            }
        } else {
            this.groups = null;
        }
        return (A)this;
    }

    public A withGroups(APIGroup ... groups) {
        if (this.groups != null) {
            this.groups.clear();
            this._visitables.remove("groups");
        }
        if (groups != null) {
            for (APIGroup item : groups) {
                this.addToGroups(item);
            }
        }
        return (A)this;
    }

    public boolean hasGroups() {
        return this.groups != null && !this.groups.isEmpty();
    }

    public GroupsNested<A> addNewGroup() {
        return new GroupsNested(-1, null);
    }

    public GroupsNested<A> addNewGroupLike(APIGroup item) {
        return new GroupsNested(-1, item);
    }

    public GroupsNested<A> setNewGroupLike(int index, APIGroup item) {
        return new GroupsNested(index, item);
    }

    public GroupsNested<A> editGroup(int index) {
        if (this.groups.size() <= index) {
            throw new RuntimeException("Can't edit groups. Index exceeds size.");
        }
        return this.setNewGroupLike(index, this.buildGroup(index));
    }

    public GroupsNested<A> editFirstGroup() {
        if (this.groups.size() == 0) {
            throw new RuntimeException("Can't edit first groups. The list is empty.");
        }
        return this.setNewGroupLike(0, this.buildGroup(0));
    }

    public GroupsNested<A> editLastGroup() {
        int index = this.groups.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last groups. The list is empty.");
        }
        return this.setNewGroupLike(index, this.buildGroup(index));
    }

    public GroupsNested<A> editMatchingGroup(Predicate<APIGroupBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.groups.size(); ++i) {
            if (!predicate.test(this.groups.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching groups. No match found.");
        }
        return this.setNewGroupLike(index, this.buildGroup(index));
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    public boolean hasKind() {
        return this.kind != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        APIGroupListFluent that = (APIGroupListFluent)o;
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.groups, that.groups)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.apiVersion, this.groups, this.kind, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.groups != null && !this.groups.isEmpty()) {
            sb.append("groups:");
            sb.append(String.valueOf(this.groups) + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class GroupsNested<N>
    extends APIGroupFluent<GroupsNested<N>>
    implements Nested<N> {
        APIGroupBuilder builder;
        int index;

        GroupsNested(int index, APIGroup item) {
            this.index = index;
            this.builder = new APIGroupBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)APIGroupListFluent.this.setToGroups(this.index, this.builder.build());
        }

        public N endGroup() {
            return this.and();
        }
    }
}

