/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.highavailability;

import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.Function;
import org.apache.flink.kubernetes.kubeclient.FlinkKubeClient;
import org.apache.flink.kubernetes.kubeclient.KubernetesConfigMapSharedWatcher;
import org.apache.flink.kubernetes.kubeclient.KubernetesSharedWatcher;
import org.apache.flink.kubernetes.kubeclient.resources.KubernetesConfigMap;
import org.apache.flink.kubernetes.utils.KubernetesUtils;
import org.apache.flink.runtime.leaderelection.LeaderInformation;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalDriver;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalEventHandler;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalException;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesLeaderRetrievalDriver
implements LeaderRetrievalDriver {
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesLeaderRetrievalDriver.class);
    private final String configMapName;
    private final LeaderRetrievalEventHandler leaderRetrievalEventHandler;
    private final FatalErrorHandler fatalErrorHandler;
    private volatile boolean running;
    private final KubernetesSharedWatcher.Watch kubernetesWatch;
    private final Function<KubernetesConfigMap, LeaderInformation> leaderInformationExtractor;

    public KubernetesLeaderRetrievalDriver(KubernetesConfigMapSharedWatcher configMapSharedWatcher, Executor watchExecutor, String configMapName, LeaderRetrievalEventHandler leaderRetrievalEventHandler, Function<KubernetesConfigMap, LeaderInformation> leaderInformationExtractor, FatalErrorHandler fatalErrorHandler) {
        this.configMapName = (String)Preconditions.checkNotNull((Object)configMapName, (String)"ConfigMap name");
        this.leaderRetrievalEventHandler = (LeaderRetrievalEventHandler)Preconditions.checkNotNull((Object)leaderRetrievalEventHandler, (String)"LeaderRetrievalEventHandler");
        this.fatalErrorHandler = (FatalErrorHandler)Preconditions.checkNotNull((Object)fatalErrorHandler);
        this.leaderInformationExtractor = leaderInformationExtractor;
        this.kubernetesWatch = ((KubernetesConfigMapSharedWatcher)Preconditions.checkNotNull((Object)configMapSharedWatcher, (String)"ConfigMap Shared Informer")).watch(configMapName, new ConfigMapCallbackHandlerImpl(), watchExecutor);
        this.running = true;
    }

    public void close() {
        if (!this.running) {
            return;
        }
        this.running = false;
        LOG.info("Stopping {}.", (Object)this);
        this.kubernetesWatch.close();
    }

    public String toString() {
        return "KubernetesLeaderRetrievalDriver{configMapName='" + this.configMapName + "'}";
    }

    private class ConfigMapCallbackHandlerImpl
    implements FlinkKubeClient.WatchCallbackHandler<KubernetesConfigMap> {
        private ConfigMapCallbackHandlerImpl() {
        }

        @Override
        public void onAdded(List<KubernetesConfigMap> configMaps) {
            KubernetesConfigMap configMap = KubernetesUtils.getOnlyConfigMap(configMaps, KubernetesLeaderRetrievalDriver.this.configMapName);
            LeaderInformation leaderInformation = KubernetesLeaderRetrievalDriver.this.leaderInformationExtractor.apply(configMap);
            if (!leaderInformation.isEmpty()) {
                KubernetesLeaderRetrievalDriver.this.leaderRetrievalEventHandler.notifyLeaderAddress(leaderInformation);
            }
        }

        @Override
        public void onModified(List<KubernetesConfigMap> configMaps) {
            KubernetesConfigMap configMap = KubernetesUtils.getOnlyConfigMap(configMaps, KubernetesLeaderRetrievalDriver.this.configMapName);
            KubernetesLeaderRetrievalDriver.this.leaderRetrievalEventHandler.notifyLeaderAddress(KubernetesLeaderRetrievalDriver.this.leaderInformationExtractor.apply(configMap));
        }

        @Override
        public void onDeleted(List<KubernetesConfigMap> configMaps) {
        }

        @Override
        public void onError(List<KubernetesConfigMap> configMaps) {
            KubernetesLeaderRetrievalDriver.this.fatalErrorHandler.onFatalError((Throwable)new LeaderRetrievalException("Error while watching the ConfigMap " + KubernetesLeaderRetrievalDriver.this.configMapName));
        }

        @Override
        public void handleError(Throwable throwable) {
            KubernetesLeaderRetrievalDriver.this.fatalErrorHandler.onFatalError((Throwable)new LeaderRetrievalException("Error while watching the ConfigMap " + KubernetesLeaderRetrievalDriver.this.configMapName, throwable));
        }
    }
}

