/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.apiextensions.v1;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.BaseFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.Nested;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceConversion;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.apiextensions.v1.WebhookConversion;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.apiextensions.v1.WebhookConversionBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.apiextensions.v1.WebhookConversionFluent;

public class CustomResourceConversionFluent<A extends CustomResourceConversionFluent<A>>
extends BaseFluent<A> {
    private String strategy;
    private WebhookConversionBuilder webhook;
    private Map<String, Object> additionalProperties;

    public CustomResourceConversionFluent() {
    }

    public CustomResourceConversionFluent(CustomResourceConversion instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(CustomResourceConversion instance) {
        CustomResourceConversion customResourceConversion = instance = instance != null ? instance : new CustomResourceConversion();
        if (instance != null) {
            this.withStrategy(instance.getStrategy());
            this.withWebhook(instance.getWebhook());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getStrategy() {
        return this.strategy;
    }

    public A withStrategy(String strategy) {
        this.strategy = strategy;
        return (A)this;
    }

    public boolean hasStrategy() {
        return this.strategy != null;
    }

    public WebhookConversion buildWebhook() {
        return this.webhook != null ? this.webhook.build() : null;
    }

    public A withWebhook(WebhookConversion webhook) {
        this._visitables.remove("webhook");
        if (webhook != null) {
            this.webhook = new WebhookConversionBuilder(webhook);
            this._visitables.get("webhook").add(this.webhook);
        } else {
            this.webhook = null;
            this._visitables.get("webhook").remove(this.webhook);
        }
        return (A)this;
    }

    public boolean hasWebhook() {
        return this.webhook != null;
    }

    public WebhookNested<A> withNewWebhook() {
        return new WebhookNested(null);
    }

    public WebhookNested<A> withNewWebhookLike(WebhookConversion item) {
        return new WebhookNested(item);
    }

    public WebhookNested<A> editWebhook() {
        return this.withNewWebhookLike(Optional.ofNullable(this.buildWebhook()).orElse(null));
    }

    public WebhookNested<A> editOrNewWebhook() {
        return this.withNewWebhookLike(Optional.ofNullable(this.buildWebhook()).orElse(new WebhookConversionBuilder().build()));
    }

    public WebhookNested<A> editOrNewWebhookLike(WebhookConversion item) {
        return this.withNewWebhookLike(Optional.ofNullable(this.buildWebhook()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CustomResourceConversionFluent that = (CustomResourceConversionFluent)o;
        if (!Objects.equals(this.strategy, that.strategy)) {
            return false;
        }
        if (!Objects.equals(this.webhook, that.webhook)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.strategy, this.webhook, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.strategy != null) {
            sb.append("strategy:");
            sb.append(this.strategy + ",");
        }
        if (this.webhook != null) {
            sb.append("webhook:");
            sb.append(String.valueOf(this.webhook) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class WebhookNested<N>
    extends WebhookConversionFluent<WebhookNested<N>>
    implements Nested<N> {
        WebhookConversionBuilder builder;

        WebhookNested(WebhookConversion item) {
            this.builder = new WebhookConversionBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)CustomResourceConversionFluent.this.withWebhook(this.builder.build());
        }

        public N endWebhook() {
            return this.and();
        }
    }
}

