/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.fs.hdfs;

import java.io.IOException;
import java.net.URI;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.runtime.fs.hdfs.HadoopFsFactory;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class HadoopFsFactoryTest {
    HadoopFsFactoryTest() {
    }

    @Test
    void testCreateHadoopFsWithoutConfig() throws Exception {
        URI uri = URI.create("hdfs://localhost:12345/");
        HadoopFsFactory factory = new HadoopFsFactory();
        FileSystem fs = factory.create(uri);
        Assertions.assertThat((String)fs.getUri().getScheme()).isEqualTo(uri.getScheme());
        Assertions.assertThat((String)fs.getUri().getAuthority()).isEqualTo(uri.getAuthority());
        Assertions.assertThat((int)fs.getUri().getPort()).isEqualTo(uri.getPort());
    }

    @Test
    void testCreateHadoopFsWithMissingAuthority() {
        URI uri = URI.create("hdfs:///my/path");
        HadoopFsFactory factory = new HadoopFsFactory();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> factory.create(uri)).isInstanceOf(IOException.class)).hasMessageContaining("authority");
    }
}

