/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.fs.hdfs;

import java.net.URI;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.UnsupportedFileSystemSchemeException;
import org.apache.flink.runtime.fs.hdfs.HadoopFsFactory;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;

public class HadoopFreeTests {
    public static void test() throws Exception {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Class.forName("org.apache.hadoop.fs.FileSystem")).describedAs("Cannot run test when Hadoop classes are in the classpath", new Object[0])).isInstanceOf(ClassNotFoundException.class);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Class.forName("org.apache.hadoop.conf.Configuration")).describedAs("Cannot run test when Hadoop classes are in the classpath", new Object[0])).isInstanceOf(ClassNotFoundException.class);
        HadoopFsFactory factory = new HadoopFsFactory();
        factory.configure(new Configuration());
        Assertions.assertThatThrownBy(() -> factory.create(new URI("hdfs://somehost:9000/root/dir"))).isInstanceOf(UnsupportedFileSystemSchemeException.class);
    }
}

