/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.hadoop.mapreduce;

import java.io.IOException;
import org.apache.flink.api.common.io.FinalizeOnMaster;
import org.apache.flink.api.common.io.FirstAttemptInitializationContext;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.java.hadoop.mapreduce.HadoopOutputFormat;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.Configuration;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class HadoopOutputFormatTest {
    private static final String MAPRED_OUTPUT_PATH = "an/ignored/file/";
    private static final String MAPRED_OUTPUT_DIR_KEY = "mapred.output.dir";

    HadoopOutputFormatTest() {
    }

    @Test
    void testWriteRecord() throws Exception {
        RecordWriter recordWriter = (RecordWriter)Mockito.mock(DummyRecordWriter.class);
        HadoopOutputFormat<String, Long> hadoopOutputFormat = this.setupHadoopOutputFormat(new DummyOutputFormat(), Job.getInstance(), (RecordWriter<String, Long>)recordWriter, null, new org.apache.hadoop.conf.Configuration());
        hadoopOutputFormat.writeRecord(new Tuple2());
        ((RecordWriter)Mockito.verify((Object)recordWriter, (VerificationMode)Mockito.times((int)1))).write((Object)((String)ArgumentMatchers.nullable(String.class)), (Object)((Long)ArgumentMatchers.nullable(Long.class)));
    }

    @Test
    void testOpen() throws Exception {
        OutputFormat dummyOutputFormat = (OutputFormat)Mockito.mock(DummyOutputFormat.class);
        OutputCommitter outputCommitter = this.setupOutputCommitter(true);
        Mockito.when((Object)dummyOutputFormat.getOutputCommitter((TaskAttemptContext)ArgumentMatchers.any(TaskAttemptContext.class))).thenReturn((Object)outputCommitter);
        HadoopOutputFormat<String, Long> hadoopOutputFormat = this.setupHadoopOutputFormat((OutputFormat<String, Long>)dummyOutputFormat, Job.getInstance(), new DummyRecordWriter(), this.setupOutputCommitter(true), new org.apache.hadoop.conf.Configuration());
        hadoopOutputFormat.open((OutputFormat.InitializationContext)FirstAttemptInitializationContext.of((int)1, (int)4));
        ((OutputCommitter)Mockito.verify((Object)hadoopOutputFormat.outputCommitter, (VerificationMode)Mockito.times((int)1))).setupJob((JobContext)ArgumentMatchers.any(JobContext.class));
        ((OutputFormat)Mockito.verify((Object)hadoopOutputFormat.mapreduceOutputFormat, (VerificationMode)Mockito.times((int)1))).getRecordWriter((TaskAttemptContext)ArgumentMatchers.any(TaskAttemptContext.class));
    }

    @Test
    void testCloseWithNeedsTaskCommitTrue() throws Exception {
        RecordWriter recordWriter = (RecordWriter)Mockito.mock(DummyRecordWriter.class);
        OutputCommitter outputCommitter = this.setupOutputCommitter(true);
        HadoopOutputFormat<String, Long> hadoopOutputFormat = this.setupHadoopOutputFormat(new DummyOutputFormat(), Job.getInstance(), (RecordWriter<String, Long>)recordWriter, outputCommitter, new org.apache.hadoop.conf.Configuration());
        hadoopOutputFormat.close();
        ((OutputCommitter)Mockito.verify((Object)outputCommitter, (VerificationMode)Mockito.times((int)1))).commitTask((TaskAttemptContext)ArgumentMatchers.nullable(TaskAttemptContext.class));
        ((RecordWriter)Mockito.verify((Object)recordWriter, (VerificationMode)Mockito.times((int)1))).close((TaskAttemptContext)ArgumentMatchers.nullable(TaskAttemptContext.class));
    }

    @Test
    void testCloseWithNeedsTaskCommitFalse() throws Exception {
        RecordWriter recordWriter = (RecordWriter)Mockito.mock(DummyRecordWriter.class);
        OutputCommitter outputCommitter = this.setupOutputCommitter(false);
        HadoopOutputFormat<String, Long> hadoopOutputFormat = this.setupHadoopOutputFormat(new DummyOutputFormat(), Job.getInstance(), (RecordWriter<String, Long>)recordWriter, outputCommitter, new org.apache.hadoop.conf.Configuration());
        hadoopOutputFormat.close();
        ((OutputCommitter)Mockito.verify((Object)outputCommitter, (VerificationMode)Mockito.times((int)0))).commitTask((TaskAttemptContext)ArgumentMatchers.nullable(TaskAttemptContext.class));
        ((RecordWriter)Mockito.verify((Object)recordWriter, (VerificationMode)Mockito.times((int)1))).close((TaskAttemptContext)ArgumentMatchers.nullable(TaskAttemptContext.class));
    }

    @Test
    void testConfigure() throws Exception {
        ConfigurableDummyOutputFormat outputFormat = (ConfigurableDummyOutputFormat)((Object)Mockito.mock(ConfigurableDummyOutputFormat.class));
        HadoopOutputFormat<String, Long> hadoopOutputFormat = this.setupHadoopOutputFormat(outputFormat, Job.getInstance(), null, null, new org.apache.hadoop.conf.Configuration());
        hadoopOutputFormat.configure(new Configuration());
        ((ConfigurableDummyOutputFormat)((Object)Mockito.verify((Object)((Object)outputFormat), (VerificationMode)Mockito.times((int)1)))).setConf((org.apache.hadoop.conf.Configuration)ArgumentMatchers.any(org.apache.hadoop.conf.Configuration.class));
    }

    @Test
    void testFinalizedGlobal() throws Exception {
        HadoopOutputFormat<String, Long> hadoopOutputFormat = this.setupHadoopOutputFormat(new DummyOutputFormat(), Job.getInstance(), null, null, new org.apache.hadoop.conf.Configuration());
        hadoopOutputFormat.finalizeGlobal(new FinalizeOnMaster.FinalizationContext(){

            public int getParallelism() {
                return 1;
            }

            public int getFinishedAttempt(int subtaskIndex) {
                return 0;
            }
        });
        ((OutputCommitter)Mockito.verify((Object)hadoopOutputFormat.outputCommitter, (VerificationMode)Mockito.times((int)1))).commitJob((JobContext)ArgumentMatchers.any(JobContext.class));
    }

    private OutputCommitter setupOutputCommitter(boolean needsTaskCommit) throws IOException {
        OutputCommitter outputCommitter = (OutputCommitter)Mockito.mock(OutputCommitter.class);
        Mockito.when((Object)outputCommitter.needsTaskCommit((TaskAttemptContext)ArgumentMatchers.nullable(TaskAttemptContext.class))).thenReturn((Object)needsTaskCommit);
        ((OutputCommitter)Mockito.doNothing().when((Object)outputCommitter)).commitTask((TaskAttemptContext)ArgumentMatchers.any(TaskAttemptContext.class));
        return outputCommitter;
    }

    private HadoopOutputFormat<String, Long> setupHadoopOutputFormat(OutputFormat<String, Long> outputFormat, Job job, RecordWriter<String, Long> recordWriter, OutputCommitter outputCommitter, org.apache.hadoop.conf.Configuration configuration) {
        HadoopOutputFormat hadoopOutputFormat = new HadoopOutputFormat(outputFormat, job);
        hadoopOutputFormat.recordWriter = recordWriter;
        hadoopOutputFormat.outputCommitter = outputCommitter;
        hadoopOutputFormat.configuration = configuration;
        hadoopOutputFormat.configuration.set(MAPRED_OUTPUT_DIR_KEY, MAPRED_OUTPUT_PATH);
        return hadoopOutputFormat;
    }

    class ConfigurableDummyOutputFormat
    extends DummyOutputFormat
    implements Configurable {
        ConfigurableDummyOutputFormat() {
        }

        public void setConf(org.apache.hadoop.conf.Configuration configuration) {
        }

        public org.apache.hadoop.conf.Configuration getConf() {
            return null;
        }
    }

    class DummyOutputFormat
    extends OutputFormat<String, Long> {
        DummyOutputFormat() {
        }

        public RecordWriter<String, Long> getRecordWriter(TaskAttemptContext context) throws IOException, InterruptedException {
            return null;
        }

        public void checkOutputSpecs(JobContext context) throws IOException, InterruptedException {
        }

        public OutputCommitter getOutputCommitter(TaskAttemptContext context) throws IOException, InterruptedException {
            OutputCommitter outputCommitter = (OutputCommitter)Mockito.mock(OutputCommitter.class);
            ((OutputCommitter)Mockito.doNothing().when((Object)outputCommitter)).setupJob((JobContext)ArgumentMatchers.any(JobContext.class));
            return outputCommitter;
        }
    }

    class DummyRecordWriter
    extends RecordWriter<String, Long> {
        DummyRecordWriter() {
        }

        public void write(String key, Long value) throws IOException, InterruptedException {
        }

        public void close(TaskAttemptContext context) throws IOException, InterruptedException {
        }
    }
}

