/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.hadoopcompatibility.mapreduce;

import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.test.hadoopcompatibility.mapreduce.example.WordCount;
import org.apache.flink.test.util.JavaProgramTestBase;
import org.apache.flink.test.util.TestBaseUtils;
import org.apache.flink.util.OperatingSystem;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;

@Tag(value="org.apache.flink.testutils.junit.FailsWithAdaptiveScheduler")
class HadoopInputOutputITCase
extends JavaProgramTestBase {
    private String textPath;
    private String resultPath;

    HadoopInputOutputITCase() {
    }

    @BeforeEach
    void checkOperatingSystem() {
        ((AbstractBooleanAssert)Assumptions.assumeThat((boolean)OperatingSystem.isWindows()).as("This test can't run successfully on Windows.", new Object[0])).isFalse();
    }

    protected void preSubmit() throws Exception {
        this.textPath = this.createTempFile("text.txt", "Goethe - Faust: Der Tragoedie erster Teil\nProlog im Himmel.\nDer Herr. Die himmlischen Heerscharen. Nachher Mephistopheles. Die drei\nErzengel treten vor.\nRAPHAEL: Die Sonne toent, nach alter Weise, In Brudersphaeren Wettgesang,\nUnd ihre vorgeschriebne Reise Vollendet sie mit Donnergang. Ihr Anblick\ngibt den Engeln Staerke, Wenn keiner Sie ergruenden mag; die unbegreiflich\nhohen Werke Sind herrlich wie am ersten Tag.\nGABRIEL: Und schnell und unbegreiflich schnelle Dreht sich umher der Erde\nPracht; Es wechselt Paradieseshelle Mit tiefer, schauervoller Nacht. Es\nschaeumt das Meer in breiten Fluessen Am tiefen Grund der Felsen auf, Und\nFels und Meer wird fortgerissen Im ewig schnellem Sphaerenlauf.\nMICHAEL: Und Stuerme brausen um die Wette Vom Meer aufs Land, vom Land\naufs Meer, und bilden wuetend eine Kette Der tiefsten Wirkung rings umher.\nDa flammt ein blitzendes Verheeren Dem Pfade vor des Donnerschlags. Doch\ndeine Boten, Herr, verehren Das sanfte Wandeln deines Tags.\nZU DREI: Der Anblick gibt den Engeln Staerke, Da keiner dich ergruenden\nmag, Und alle deine hohen Werke Sind herrlich wie am ersten Tag.\nMEPHISTOPHELES: Da du, o Herr, dich einmal wieder nahst Und fragst, wie\nalles sich bei uns befinde, Und du mich sonst gewoehnlich gerne sahst, So\nsiehst du mich auch unter dem Gesinde. Verzeih, ich kann nicht hohe Worte\nmachen, Und wenn mich auch der ganze Kreis verhoehnt; Mein Pathos braechte\ndich gewiss zum Lachen, Haettst du dir nicht das Lachen abgewoehnt. Von\nSonn' und Welten weiss ich nichts zu sagen, Ich sehe nur, wie sich die\nMenschen plagen. Der kleine Gott der Welt bleibt stets von gleichem\nSchlag, Und ist so wunderlich als wie am ersten Tag. Ein wenig besser\nwuerd er leben, Haettst du ihm nicht den Schein des Himmelslichts gegeben;\nEr nennt's Vernunft und braucht's allein, Nur tierischer als jedes Tier\nzu sein. Er scheint mir, mit Verlaub von euer Gnaden, Wie eine der\nlangbeinigen Zikaden, Die immer fliegt und fliegend springt Und gleich im\nGras ihr altes Liedchen singt; Und laeg er nur noch immer in dem Grase! In\njeden Quark begraebt er seine Nase.\nDER HERR: Hast du mir weiter nichts zu sagen? Kommst du nur immer\nanzuklagen? Ist auf der Erde ewig dir nichts recht?\nMEPHISTOPHELES: Nein Herr! ich find es dort, wie immer, herzlich\nschlecht. Die Menschen dauern mich in ihren Jammertagen, Ich mag sogar\ndie armen selbst nicht plagen.\nDER HERR: Kennst du den Faust?\nMEPHISTOPHELES: Den Doktor?\nDER HERR: Meinen Knecht!\nMEPHISTOPHELES: Fuerwahr! er dient Euch auf besondre Weise. Nicht irdisch\nist des Toren Trank noch Speise. Ihn treibt die Gaerung in die Ferne, Er\nist sich seiner Tollheit halb bewusst; Vom Himmel fordert er die schoensten\nSterne Und von der Erde jede hoechste Lust, Und alle Naeh und alle Ferne\nBefriedigt nicht die tiefbewegte Brust.\nDER HERR: Wenn er mir auch nur verworren dient, So werd ich ihn bald in\ndie Klarheit fuehren. Weiss doch der Gaertner, wenn das Baeumchen gruent, Das\nBluet und Frucht die kuenft'gen Jahre zieren.\nMEPHISTOPHELES: Was wettet Ihr? den sollt Ihr noch verlieren! Wenn Ihr\nmir die Erlaubnis gebt, Ihn meine Strasse sacht zu fuehren.\nDER HERR: Solang er auf der Erde lebt, So lange sei dir's nicht verboten,\nEs irrt der Mensch so lang er strebt.\nMEPHISTOPHELES: Da dank ich Euch; denn mit den Toten Hab ich mich niemals\ngern befangen. Am meisten lieb ich mir die vollen, frischen Wangen. Fuer\neinem Leichnam bin ich nicht zu Haus; Mir geht es wie der Katze mit der Maus.\nDER HERR: Nun gut, es sei dir ueberlassen! Zieh diesen Geist von seinem\nUrquell ab, Und fuehr ihn, kannst du ihn erfassen, Auf deinem Wege mit\nherab, Und steh beschaemt, wenn du bekennen musst: Ein guter Mensch, in\nseinem dunklen Drange, Ist sich des rechten Weges wohl bewusst.\nMEPHISTOPHELES: Schon gut! nur dauert es nicht lange. Mir ist fuer meine\nWette gar nicht bange. Wenn ich zu meinem Zweck gelange, Erlaubt Ihr mir\nTriumph aus voller Brust. Staub soll er fressen, und mit Lust, Wie meine\nMuhme, die beruehmte Schlange.\nDER HERR: Du darfst auch da nur frei erscheinen; Ich habe deinesgleichen\nnie gehasst. Von allen Geistern, die verneinen, ist mir der Schalk am\nwenigsten zur Last. Des Menschen Taetigkeit kann allzu leicht erschlaffen,\ner liebt sich bald die unbedingte Ruh; Drum geb ich gern ihm den Gesellen\nzu, Der reizt und wirkt und muss als Teufel schaffen. Doch ihr, die echten\nGoettersoehne, Erfreut euch der lebendig reichen Schoene! Das Werdende, das\newig wirkt und lebt, Umfass euch mit der Liebe holden Schranken, Und was\nin schwankender Erscheinung schwebt, Befestigt mit dauernden Gedanken!\n(Der Himmel schliesst, die Erzengel verteilen sich.)\nMEPHISTOPHELES (allein): Von Zeit zu Zeit seh ich den Alten gern, Und\nhuete mich, mit ihm zu brechen. Es ist gar huebsch von einem grossen Herrn,\nSo menschlich mit dem Teufel selbst zu sprechen.");
        this.resultPath = this.getTempDirPath("result");
    }

    protected void postSubmit() throws Exception {
        TestBaseUtils.compareResultsByLinesInMemory((String)"machen 1\nzeit 2\nheerscharen 1\nkeiner 2\nmeine 3\nfuehr 1\ntriumph 1\nkommst 1\nfrei 1\nschaffen 1\ngesinde 1\nlangbeinigen 1\nschalk 1\nbesser 1\nsolang 1\nmeer 4\nfragst 1\ngabriel 1\nselbst 2\nbin 1\nsich 7\ndu 11\nsogar 1\ngeht 1\nimmer 4\nmensch 2\nbefestigt 1\nlebt 2\nmag 3\nengeln 2\nbreiten 1\nblitzendes 1\ntags 1\nsie 2\nplagen 2\nallzu 1\nmeisten 1\no 1\npfade 1\nkennst 1\nnichts 3\ngedanken 1\nbefriedigt 1\nmich 6\ns 3\nes 8\nverneinen 1\ner 13\ngleich 1\nbaeumchen 1\ndonnergang 1\nwunderlich 1\nreise 1\nurquell 1\ndoch 3\naufs 2\ntoten 1\nniemals 1\neine 2\nhab 1\ndarfst 1\nda 5\ngen 1\neinem 2\nteil 1\ndas 7\nspeise 1\nwenig 1\nsterne 1\ngeb 1\nwelten 1\nalle 3\ntoent 1\ngras 1\nfelsen 1\nkette 1\nich 14\nfuer 2\nals 3\nmein 1\nschoene 1\nverzeih 1\nschwankender 1\nwie 9\nmenschlich 1\ngaertner 1\ntaetigkeit 1\nbange 1\nliebe 1\nsei 2\nseh 1\ntollheit 1\nam 6\nmichael 1\ngeist 1\nab 1\nnahst 1\nvollendet 1\nliebt 1\nbrausen 1\nnase 1\nerlaubt 1\nweiss 2\nschnellem 1\ndeinem 1\ngleichem 1\ngaerung 1\ndauernden 1\ndeines 1\nvorgeschriebne 1\nirdisch 1\nworte 1\nverehren 1\nhohen 2\nweise 2\nkuenft 1\nwerdende 1\nwette 2\nwuetend 1\nerscheinung 1\ngar 2\nverlieren 1\nbraucht 1\nweiter 1\ntrank 1\ntierischer 1\nwohl 1\nverteilen 1\nverhoehnt 1\nschaeumt 1\nhimmelslichts 1\nunbedingte 1\nherzlich 1\nanblick 2\nnennt 1\ngruent 1\nbluet 1\nleichnam 1\nerschlaffen 1\njammertagen 1\nzieh 1\nihm 3\nbesondre 1\nihn 5\ngrossen 1\nvollen 1\nihr 7\nboten 1\nvoller 1\nsingt 1\nmuhme 1\nschon 1\nlast 1\nkleine 1\nparadieseshelle 1\nnein 1\nechten 1\nunter 1\nbei 1\nherr 11\ngern 3\nsphaerenlauf 1\nstets 1\nganze 1\nbraechte 1\nfordert 1\nschoensten 1\nherrlich 2\ngegeben 1\nallein 2\nreichen 1\nschauervoller 1\nmusst 1\nrecht 1\nbleibt 1\npracht 1\ntreibt 1\nbefangen 1\nwas 2\nmenschen 3\njede 1\nhohe 1\ntiefsten 1\nbilden 1\ndrum 1\ngibt 2\nguter 1\nfuerwahr 1\nim 3\ngrund 1\nin 9\nhoechste 1\nschliesst 1\nfels 1\nsteh 1\neuer 1\nerster 1\nersten 3\ngoettersoehne 1\nbrechen 1\ntiefen 1\nfrucht 1\nkreis 1\nsiehst 1\nwege 1\nist 8\nzikaden 1\nfrischen 1\nruh 1\ndeine 2\nmaus 1\nbrudersphaeren 1\nnachher 1\neuch 4\ngnaden 1\nanzuklagen 1\nschlange 1\nstaerke 2\nerde 4\nverlaub 1\nsanfte 1\nholden 1\nsonst 1\ntreten 1\nsahst 1\nalten 1\num 1\nwieder 1\nalter 1\naltes 1\nnun 1\nlieb 1\ngesellen 1\nerscheinen 1\nwirkt 2\nhaettst 2\nnur 7\ntiefbewegte 1\nlachen 2\ndrange 1\nschlag 1\nschein 1\nmuss 1\nverworren 1\nweges 1\nallen 1\ngewoehnlich 1\nalles 1\nhalb 1\nstuerme 1\nspringt 1\nsollt 1\nklarheit 1\nso 6\nerfassen 1\nliedchen 1\nprolog 1\nzur 1\nfressen 1\nzum 1\nfaust 2\nerzengel 2\njahre 1\nsonn 1\nraphael 1\nland 2\nlang 1\ngelange 1\nlust 2\nwelt 1\nsehe 1\nihre 1\njedes 1\nerfreut 1\nseiner 1\ndenn 1\nwandeln 1\nwechselt 1\njeden 1\ndort 1\nschlecht 1\nwenigsten 1\nwuerd 1\nschranken 1\nbewusst 2\nseinem 2\ngehasst 1\nsein 1\nmeinem 1\nmeinen 1\npathos 1\nherrn 1\nlange 2\nherab 1\ndiesen 1\nihren 1\nberuehmte 1\ngoethe 1\ntag 3\ntier 1\nquark 1\ndank 1\nseine 1\nteufel 2\nzweck 1\nwenn 7\nsoll 1\nwirkung 1\nerlaubnis 1\nlebendig 1\nuns 1\nleicht 1\ngewiss 1\nschnell 1\nund 29\ngerne 1\nrechten 1\numher 2\nvernunft 1\ngrase 1\nnach 1\nleben 1\ngott 1\nder 29\ndes 5\ndoktor 1\nbeschaemt 1\ndreht 1\nhabe 1\nsagen 2\nbekennen 1\ndunklen 1\nwettet 1\nden 9\nmephistopheles 9\ndem 4\nauch 4\nkann 2\narmen 1\nmir 9\nstrebt 1\ngut 2\nmit 11\nbald 2\nhimmlischen 1\nhimmel 3\nnoch 3\nkannst 1\ndeinesgleichen 1\nflammt 1\nergruenden 2\nnacht 1\nscheint 1\nferne 2\ntragoedie 1\nabgewoehnt 1\nreizt 1\ngeistern 1\nnicht 10\nsacht 1\nunbegreiflich 2\nschnelle 1\neinmal 1\nwerd 1\nwerke 2\nbegraebt 1\nknecht 1\nrings 1\nwird 1\nkatze 1\nhuete 1\nfortgerissen 1\ngebt 1\nhuebsch 1\nhast 1\nirrt 1\nbefinde 1\nsind 2\nfuehren 2\nfliegt 1\newig 3\nbrust 2\nsonne 1\nsprechen 1\nein 3\nstrasse 1\nvon 8\nueberlassen 1\ndir 4\nvom 3\nzu 11\nschwebt 1\ndie 22\nvor 2\nwangen 1\nwettgesang 1\ndonnerschlags 1\nfind 1\ndich 3\numfass 1\nverboten 1\nlaeg 1\nnie 1\ndrei 2\ndauern 1\ntoren 1\ndauert 1\nverheeren 1\nfliegend 1\naus 1\nstaub 1\nfluessen 1\nhaus 1\nauf 5\ndient 2\ntiefer 1\nnaeh 1\nzieren 1\n", (String)this.resultPath, (String[])new String[]{".", "_"});
    }

    protected JobExecutionResult testProgram() throws Exception {
        return WordCount.run(new String[]{this.textPath, this.resultPath});
    }
}

