/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.UUID;
import org.apache.hadoop.io.WritableComparable;

public class WritableID
implements WritableComparable<WritableID> {
    private UUID uuid;

    public WritableID() {
        this.uuid = UUID.randomUUID();
    }

    public WritableID(UUID uuid) {
        this.uuid = uuid;
    }

    public int compareTo(WritableID o) {
        return this.uuid.compareTo(o.uuid);
    }

    public void write(DataOutput dataOutput) throws IOException {
        dataOutput.writeLong(this.uuid.getMostSignificantBits());
        dataOutput.writeLong(this.uuid.getLeastSignificantBits());
    }

    public void readFields(DataInput dataInput) throws IOException {
        this.uuid = new UUID(dataInput.readLong(), dataInput.readLong());
    }

    public String toString() {
        return this.uuid.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WritableID id = (WritableID)o;
        return !(this.uuid == null ? id.uuid != null : !this.uuid.equals(id.uuid));
    }

    public int hashCode() {
        return this.uuid != null ? this.uuid.hashCode() : 0;
    }
}

