/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import org.apache.flink.api.common.functions.InvalidTypesException;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.functions.RichMapFunction;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.PojoField;
import org.apache.flink.api.java.typeutils.PojoTypeInfo;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.api.java.typeutils.WritableTypeInfo;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparator;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Fail;
import org.junit.jupiter.api.Test;

class WritableExtractionTest {
    WritableExtractionTest() {
    }

    @Test
    void testDetectWritable() {
        Assertions.assertThat((boolean)TypeExtractor.isHadoopWritable(Writable.class)).isFalse();
        Assertions.assertThat((boolean)TypeExtractor.isHadoopWritable(DirectWritable.class)).isTrue();
        Assertions.assertThat((boolean)TypeExtractor.isHadoopWritable(ViaInterfaceExtension.class)).isTrue();
        Assertions.assertThat((boolean)TypeExtractor.isHadoopWritable(ViaAbstractClassExtension.class)).isTrue();
        Assertions.assertThat((boolean)TypeExtractor.isHadoopWritable(String.class)).isFalse();
        Assertions.assertThat((boolean)TypeExtractor.isHadoopWritable(List.class)).isFalse();
        Assertions.assertThat((boolean)TypeExtractor.isHadoopWritable(WritableComparator.class)).isFalse();
    }

    @Test
    void testCreateWritableInfo() {
        TypeInformation info1 = TypeExtractor.createHadoopWritableTypeInfo(DirectWritable.class);
        Assertions.assertThat((Class)info1.getTypeClass()).isEqualTo(DirectWritable.class);
        TypeInformation info2 = TypeExtractor.createHadoopWritableTypeInfo(ViaInterfaceExtension.class);
        Assertions.assertThat((Class)info2.getTypeClass()).isEqualTo(ViaInterfaceExtension.class);
        TypeInformation info3 = TypeExtractor.createHadoopWritableTypeInfo(ViaAbstractClassExtension.class);
        Assertions.assertThat((Class)info3.getTypeClass()).isEqualTo(ViaAbstractClassExtension.class);
    }

    @Test
    void testValidateTypeInfo() {
        TypeExtractor.validateIfWritable((TypeInformation)BasicTypeInfo.STRING_TYPE_INFO, String.class);
        TypeExtractor.validateIfWritable((TypeInformation)new WritableTypeInfo(DirectWritable.class), DirectWritable.class);
        TypeExtractor.validateIfWritable((TypeInformation)new WritableTypeInfo(ViaInterfaceExtension.class), ViaInterfaceExtension.class);
        TypeExtractor.validateIfWritable((TypeInformation)new WritableTypeInfo(ViaAbstractClassExtension.class), ViaAbstractClassExtension.class);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TypeExtractor.validateIfWritable((TypeInformation)new WritableTypeInfo(DirectWritable.class), String.class)).as("should have failed with an exception", new Object[0])).isInstanceOf(InvalidTypesException.class);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TypeExtractor.validateIfWritable((TypeInformation)new WritableTypeInfo(ViaInterfaceExtension.class), DirectWritable.class)).as("should have failed with an exception", new Object[0])).isInstanceOf(InvalidTypesException.class);
    }

    @Test
    void testExtractFromFunction() {
        RichMapFunction<DirectWritable, DirectWritable> function = new RichMapFunction<DirectWritable, DirectWritable>(){

            public DirectWritable map(DirectWritable value) throws Exception {
                return null;
            }
        };
        TypeInformation outType = TypeExtractor.getMapReturnTypes((MapFunction)function, (TypeInformation)new WritableTypeInfo(DirectWritable.class));
        Assertions.assertThat((Object)outType).isInstanceOf(WritableTypeInfo.class);
        Assertions.assertThat((Class)outType.getTypeClass()).isEqualTo(DirectWritable.class);
    }

    @Test
    void testExtractAsPartOfPojo() {
        PojoTypeInfo pojoInfo = (PojoTypeInfo)TypeExtractor.getForClass(PojoWithWritable.class);
        boolean foundWritable = false;
        for (int i = 0; i < pojoInfo.getArity(); ++i) {
            PojoField field = pojoInfo.getPojoFieldAt(i);
            String name = field.getField().getName();
            if (!name.equals("hadoopCitizen")) continue;
            if (foundWritable) {
                Fail.fail((String)"already seen");
            }
            foundWritable = true;
            Assertions.assertThat((Object)field.getTypeInformation()).isEqualTo((Object)new WritableTypeInfo(DirectWritable.class));
            Assertions.assertThat((Class)field.getTypeInformation().getTypeClass()).isEqualTo(DirectWritable.class);
        }
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)foundWritable).as("missed the writable type", new Object[0])).isTrue();
    }

    @Test
    void testInputValidationError() {
        RichMapFunction<Writable, String> function = new RichMapFunction<Writable, String>(){

            public String map(Writable value) throws Exception {
                return null;
            }
        };
        WritableTypeInfo inType = new WritableTypeInfo(DirectWritable.class);
        try {
            TypeExtractor.getMapReturnTypes((MapFunction)function, (TypeInformation)inType);
            Fail.fail((String)"exception expected");
        }
        catch (InvalidTypesException invalidTypesException) {
            // empty catch block
        }
    }

    public static class PojoWithWritable {
        public String str;
        public DirectWritable hadoopCitizen;
    }

    private static class ViaAbstractClassExtension
    extends AbstractWritable {
        private ViaAbstractClassExtension() {
        }

        public void write(DataOutput dataOutput) throws IOException {
        }

        public void readFields(DataInput dataInput) throws IOException {
        }
    }

    private static class ViaInterfaceExtension
    implements ExtendedWritable {
        private ViaInterfaceExtension() {
        }

        public void write(DataOutput dataOutput) throws IOException {
        }

        public void readFields(DataInput dataInput) throws IOException {
        }
    }

    private static class DirectWritable
    implements Writable {
        private DirectWritable() {
        }

        public void write(DataOutput dataOutput) throws IOException {
        }

        public void readFields(DataInput dataInput) throws IOException {
        }
    }

    private static abstract class AbstractWritable
    implements Writable {
        private AbstractWritable() {
        }
    }

    private static interface ExtendedWritable
    extends Writable {
    }
}

