/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.datastream.impl.context;

import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.apache.flink.api.common.state.AggregatingStateDeclaration;
import org.apache.flink.api.common.state.BroadcastState;
import org.apache.flink.api.common.state.BroadcastStateDeclaration;
import org.apache.flink.api.common.state.ListStateDeclaration;
import org.apache.flink.api.common.state.MapStateDeclaration;
import org.apache.flink.api.common.state.OperatorStateStore;
import org.apache.flink.api.common.state.ReducingStateDeclaration;
import org.apache.flink.api.common.state.StateDeclaration;
import org.apache.flink.api.common.state.ValueStateDeclaration;
import org.apache.flink.api.common.state.v2.AggregatingState;
import org.apache.flink.api.common.state.v2.AggregatingStateDescriptor;
import org.apache.flink.api.common.state.v2.ListState;
import org.apache.flink.api.common.state.v2.ListStateDescriptor;
import org.apache.flink.api.common.state.v2.MapState;
import org.apache.flink.api.common.state.v2.MapStateDescriptor;
import org.apache.flink.api.common.state.v2.ReducingState;
import org.apache.flink.api.common.state.v2.ReducingStateDescriptor;
import org.apache.flink.api.common.state.v2.ValueState;
import org.apache.flink.api.common.state.v2.ValueStateDescriptor;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.datastream.api.context.StateManager;
import org.apache.flink.streaming.api.operators.StreamingRuntimeContext;
import org.apache.flink.util.Preconditions;

public class DefaultStateManager
implements StateManager {
    private final Supplier<Object> currentKeySupplier;
    private final BiConsumer<Runnable, Object> processorWithKey;
    protected final StreamingRuntimeContext operatorContext;
    protected final OperatorStateStore operatorStateStore;

    public DefaultStateManager(Supplier<Object> currentKeySupplier, BiConsumer<Runnable, Object> processorWithKey, StreamingRuntimeContext operatorContext, OperatorStateStore operatorStateStore) {
        this.currentKeySupplier = currentKeySupplier;
        this.processorWithKey = processorWithKey;
        this.operatorContext = (StreamingRuntimeContext)Preconditions.checkNotNull((Object)operatorContext);
        this.operatorStateStore = (OperatorStateStore)Preconditions.checkNotNull((Object)operatorStateStore);
    }

    public <K> K getCurrentKey() {
        return (K)this.currentKeySupplier.get();
    }

    public <T> Optional<ValueState<T>> getStateOptional(ValueStateDeclaration<T> stateDeclaration) throws Exception {
        ValueStateDescriptor valueStateDescriptor = new ValueStateDescriptor(stateDeclaration.getName(), TypeExtractor.createTypeInfo((Class)stateDeclaration.getTypeDescriptor().getTypeClass()));
        return Optional.ofNullable(this.operatorContext.getValueState(valueStateDescriptor));
    }

    public <T> ValueState<T> getState(ValueStateDeclaration<T> stateDeclaration) throws Exception {
        Optional<ValueState<T>> stateOptional = this.getStateOptional(stateDeclaration);
        this.checkStateIsAvailable(stateOptional);
        return stateOptional.get();
    }

    public <T> Optional<ListState<T>> getStateOptional(ListStateDeclaration<T> stateDeclaration) throws Exception {
        ListStateDescriptor listStateDescriptor = new ListStateDescriptor(stateDeclaration.getName(), TypeExtractor.createTypeInfo((Class)stateDeclaration.getTypeDescriptor().getTypeClass()));
        if (stateDeclaration.getRedistributionMode() == StateDeclaration.RedistributionMode.REDISTRIBUTABLE) {
            if (stateDeclaration.getRedistributionStrategy() == ListStateDeclaration.RedistributionStrategy.UNION) {
                return Optional.ofNullable(this.operatorStateStore.getUnionListState(listStateDescriptor));
            }
            return Optional.ofNullable(this.operatorStateStore.getListState(listStateDescriptor));
        }
        return Optional.ofNullable(this.operatorContext.getListState(listStateDescriptor));
    }

    public <T> ListState<T> getState(ListStateDeclaration<T> stateDeclaration) throws Exception {
        Optional<ListState<T>> stateOptional = this.getStateOptional(stateDeclaration);
        this.checkStateIsAvailable(stateOptional);
        return stateOptional.get();
    }

    public <K, V> Optional<MapState<K, V>> getStateOptional(MapStateDeclaration<K, V> stateDeclaration) throws Exception {
        MapStateDescriptor mapStateDescriptor = new MapStateDescriptor(stateDeclaration.getName(), TypeExtractor.createTypeInfo((Class)stateDeclaration.getKeyTypeDescriptor().getTypeClass()), TypeExtractor.createTypeInfo((Class)stateDeclaration.getValueTypeDescriptor().getTypeClass()));
        return Optional.ofNullable(this.operatorContext.getMapState(mapStateDescriptor));
    }

    public <K, V> MapState<K, V> getState(MapStateDeclaration<K, V> stateDeclaration) throws Exception {
        Optional<MapState<K, V>> stateOptional = this.getStateOptional(stateDeclaration);
        this.checkStateIsAvailable(stateOptional);
        return stateOptional.get();
    }

    public <T> Optional<ReducingState<T>> getStateOptional(ReducingStateDeclaration<T> stateDeclaration) throws Exception {
        ReducingStateDescriptor reducingStateDescriptor = new ReducingStateDescriptor(stateDeclaration.getName(), stateDeclaration.getReduceFunction(), TypeExtractor.createTypeInfo((Class)stateDeclaration.getTypeDescriptor().getTypeClass()));
        return Optional.ofNullable(this.operatorContext.getReducingState(reducingStateDescriptor));
    }

    public <T> ReducingState<T> getState(ReducingStateDeclaration<T> stateDeclaration) throws Exception {
        Optional<ReducingState<T>> stateOptional = this.getStateOptional(stateDeclaration);
        this.checkStateIsAvailable(stateOptional);
        return stateOptional.get();
    }

    public <IN, ACC, OUT> Optional<AggregatingState<IN, OUT>> getStateOptional(AggregatingStateDeclaration<IN, ACC, OUT> stateDeclaration) throws Exception {
        AggregatingStateDescriptor aggregatingStateDescriptor = new AggregatingStateDescriptor(stateDeclaration.getName(), stateDeclaration.getAggregateFunction(), TypeExtractor.createTypeInfo((Class)stateDeclaration.getTypeDescriptor().getTypeClass()));
        return Optional.ofNullable(this.operatorContext.getAggregatingState(aggregatingStateDescriptor));
    }

    public <IN, ACC, OUT> AggregatingState<IN, OUT> getState(AggregatingStateDeclaration<IN, ACC, OUT> stateDeclaration) throws Exception {
        Optional<AggregatingState<IN, OUT>> stateOptional = this.getStateOptional(stateDeclaration);
        this.checkStateIsAvailable(stateOptional);
        return stateOptional.get();
    }

    public <K, V> Optional<BroadcastState<K, V>> getStateOptional(BroadcastStateDeclaration<K, V> stateDeclaration) throws Exception {
        MapStateDescriptor mapStateDescriptor = new MapStateDescriptor(stateDeclaration.getName(), TypeExtractor.createTypeInfo((Class)stateDeclaration.getKeyTypeDescriptor().getTypeClass()), TypeExtractor.createTypeInfo((Class)stateDeclaration.getValueTypeDescriptor().getTypeClass()));
        return Optional.ofNullable(this.operatorStateStore.getBroadcastState(mapStateDescriptor));
    }

    public <K, V> BroadcastState<K, V> getState(BroadcastStateDeclaration<K, V> stateDeclaration) throws Exception {
        Optional<BroadcastState<K, V>> stateOptional = this.getStateOptional(stateDeclaration);
        this.checkStateIsAvailable(stateOptional);
        return stateOptional.get();
    }

    private void checkStateIsAvailable(Optional<?> stateOptional) {
        if (stateOptional.isEmpty()) {
            throw new IllegalStateException("Failed to access the State. You may need to declare it first and ensure that the context can access the State. For more information, please refer to 'https://nightlies.apache.org/flink/flink-docs-master/docs/dev/datastream-v2/context_and_state_processing/#the-legitimacy-of-state-declaration-and-access'.");
        }
    }

    public void executeInKeyContext(Runnable runnable, Object key) {
        this.processorWithKey.accept(runnable, key);
    }
}

