/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.table;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.flink.connector.file.table.BinPacking;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.Test;

class BinPackingTest {
    BinPackingTest() {
    }

    @Test
    void testBinPacking() {
        ((ListAssert)Assertions.assertThat(Arrays.asList(Arrays.asList(1, 2), Collections.singletonList(3), Collections.singletonList(4), Collections.singletonList(5))).as("Should pack the first 2 values", new Object[0])).isEqualTo(this.pack(Arrays.asList(1, 2, 3, 4, 5), 3L));
        ((ListAssert)Assertions.assertThat(Arrays.asList(Arrays.asList(1, 2), Collections.singletonList(3), Collections.singletonList(4), Collections.singletonList(5))).as("Should pack the first 2 values", new Object[0])).isEqualTo(this.pack(Arrays.asList(1, 2, 3, 4, 5), 5L));
        ((ListAssert)Assertions.assertThat(Arrays.asList(Arrays.asList(1, 2, 3), Collections.singletonList(4), Collections.singletonList(5))).as("Should pack the first 3 values", new Object[0])).isEqualTo(this.pack(Arrays.asList(1, 2, 3, 4, 5), 6L));
        ((ListAssert)Assertions.assertThat(Arrays.asList(Arrays.asList(1, 2, 3), Collections.singletonList(4), Collections.singletonList(5))).as("Should pack the first 3 values", new Object[0])).isEqualTo(this.pack(Arrays.asList(1, 2, 3, 4, 5), 8L));
        ((ListAssert)Assertions.assertThat(Arrays.asList(Arrays.asList(1, 2, 3), Arrays.asList(4, 5))).as("Should pack the first 3 values, last 2 values", new Object[0])).isEqualTo(this.pack(Arrays.asList(1, 2, 3, 4, 5), 9L));
        ((ListAssert)Assertions.assertThat(Arrays.asList(Arrays.asList(1, 2, 3, 4), Collections.singletonList(5))).as("Should pack the first 4 values", new Object[0])).isEqualTo(this.pack(Arrays.asList(1, 2, 3, 4, 5), 10L));
        ((ListAssert)Assertions.assertThat(Arrays.asList(Arrays.asList(1, 2, 3, 4), Collections.singletonList(5))).as("Should pack the first 4 values", new Object[0])).isEqualTo(this.pack(Arrays.asList(1, 2, 3, 4, 5), 14L));
        ((ListAssert)Assertions.assertThat(Collections.singletonList(Arrays.asList(1, 2, 3, 4, 5))).as("Should pack the first 5 values", new Object[0])).isEqualTo(this.pack(Arrays.asList(1, 2, 3, 4, 5), 15L));
    }

    private List<List<Integer>> pack(List<Integer> items, long targetWeight) {
        return BinPacking.pack(items, Integer::longValue, (long)targetWeight);
    }
}

