/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.src.impl;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.connector.source.SplitEnumeratorContext;
import org.apache.flink.connector.file.src.FileSourceSplit;
import org.apache.flink.connector.file.src.PendingSplitsCheckpoint;
import org.apache.flink.connector.file.src.assigners.FileSplitAssigner;
import org.apache.flink.connector.file.src.assigners.SimpleSplitAssigner;
import org.apache.flink.connector.file.src.impl.StaticFileSplitEnumerator;
import org.apache.flink.connector.testutils.source.reader.TestingSplitEnumeratorContext;
import org.apache.flink.core.fs.Path;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class StaticFileSplitEnumeratorTest {
    private static final File TMP_DIR = new File(System.getProperty("java.io.tmpdir"));
    private static long splitId = 1L;

    StaticFileSplitEnumeratorTest() {
    }

    @Test
    void testCheckpointNoSplitRequested() throws Exception {
        TestingSplitEnumeratorContext context = new TestingSplitEnumeratorContext(4);
        FileSourceSplit split = StaticFileSplitEnumeratorTest.createRandomSplit();
        StaticFileSplitEnumerator enumerator = StaticFileSplitEnumeratorTest.createEnumerator((SplitEnumeratorContext<FileSourceSplit>)context, split);
        PendingSplitsCheckpoint checkpoint = enumerator.snapshotState(1L);
        Assertions.assertThat((Collection)checkpoint.getSplits()).contains((Object[])new FileSourceSplit[]{split});
    }

    @Test
    void testSplitRequestForRegisteredReader() throws Exception {
        TestingSplitEnumeratorContext context = new TestingSplitEnumeratorContext(4);
        FileSourceSplit split = StaticFileSplitEnumeratorTest.createRandomSplit();
        StaticFileSplitEnumerator enumerator = StaticFileSplitEnumeratorTest.createEnumerator((SplitEnumeratorContext<FileSourceSplit>)context, split);
        context.registerReader(3, "somehost");
        enumerator.addReader(3);
        enumerator.handleSplitRequest(3, "somehost");
        Assertions.assertThat((Collection)enumerator.snapshotState(1L).getSplits()).isEmpty();
        Assertions.assertThat((List)((TestingSplitEnumeratorContext.SplitAssignmentState)context.getSplitAssignments().get(3)).getAssignedSplits()).contains((Object[])new FileSourceSplit[]{split});
    }

    @Test
    void testSplitRequestForNonRegisteredReader() throws Exception {
        TestingSplitEnumeratorContext context = new TestingSplitEnumeratorContext(4);
        FileSourceSplit split = StaticFileSplitEnumeratorTest.createRandomSplit();
        StaticFileSplitEnumerator enumerator = StaticFileSplitEnumeratorTest.createEnumerator((SplitEnumeratorContext<FileSourceSplit>)context, split);
        enumerator.handleSplitRequest(3, "somehost");
        Assertions.assertThat((Map)context.getSplitAssignments()).doesNotContainKey((Object)3);
        Assertions.assertThat((Collection)enumerator.snapshotState(1L).getSplits()).contains((Object[])new FileSourceSplit[]{split});
    }

    @Test
    void testNoMoreSplits() throws Exception {
        TestingSplitEnumeratorContext context = new TestingSplitEnumeratorContext(4);
        FileSourceSplit split = StaticFileSplitEnumeratorTest.createRandomSplit();
        StaticFileSplitEnumerator enumerator = StaticFileSplitEnumeratorTest.createEnumerator((SplitEnumeratorContext<FileSourceSplit>)context, split);
        context.registerReader(1, "somehost");
        enumerator.addReader(1);
        enumerator.handleSplitRequest(1, "somehost");
        enumerator.handleSplitRequest(1, "somehost");
        Assertions.assertThat((List)((TestingSplitEnumeratorContext.SplitAssignmentState)context.getSplitAssignments().get(1)).getAssignedSplits()).contains((Object[])new FileSourceSplit[]{split});
        Assertions.assertThat((boolean)((TestingSplitEnumeratorContext.SplitAssignmentState)context.getSplitAssignments().get(1)).hasReceivedNoMoreSplitsSignal()).isTrue();
    }

    private static FileSourceSplit createRandomSplit() {
        return new FileSourceSplit(String.valueOf(splitId++), Path.fromLocalFile((File)new File(TMP_DIR, "foo")), 0L, 0L, 0L, 0L);
    }

    private static StaticFileSplitEnumerator createEnumerator(SplitEnumeratorContext<FileSourceSplit> context, FileSourceSplit ... splits) {
        return new StaticFileSplitEnumerator(context, (FileSplitAssigner)new SimpleSplitAssigner(Arrays.asList(splits)));
    }
}

