/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.sink;

import java.io.IOException;
import org.apache.flink.connector.file.sink.FileSinkCommittable;
import org.apache.flink.connector.file.sink.FileSinkCommittableSerializer;
import org.apache.flink.connector.file.sink.utils.FileSinkTestUtils;
import org.apache.flink.core.fs.Path;
import org.apache.flink.streaming.api.functions.sink.filesystem.InProgressFileWriter;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class FileCommittableSerializerTest {
    FileCommittableSerializerTest() {
    }

    @Test
    void testCommittableWithPendingFile() throws IOException {
        FileSinkCommittable committable = new FileSinkCommittable("0", (InProgressFileWriter.PendingFileRecoverable)new FileSinkTestUtils.TestPendingFileRecoverable());
        FileSinkCommittable deserialized = this.serializeAndDeserialize(committable);
        Assertions.assertThat((String)committable.getBucketId()).isEqualTo(deserialized.getBucketId());
        Assertions.assertThat((Object)committable.getPendingFile()).isEqualTo((Object)deserialized.getPendingFile());
        Assertions.assertThat((Object)committable.getInProgressFileToCleanup()).isEqualTo((Object)deserialized.getInProgressFileToCleanup());
        Assertions.assertThat((Object)committable.getCompactedFileToCleanup()).isEqualTo((Object)deserialized.getCompactedFileToCleanup());
    }

    @Test
    void testCommittableWithInProgressFileToCleanup() throws IOException {
        FileSinkCommittable committable = new FileSinkCommittable("0", (InProgressFileWriter.InProgressFileRecoverable)new FileSinkTestUtils.TestInProgressFileRecoverable());
        FileSinkCommittable deserialized = this.serializeAndDeserialize(committable);
        Assertions.assertThat((String)committable.getBucketId()).isEqualTo(deserialized.getBucketId());
        Assertions.assertThat((Object)committable.getPendingFile()).isEqualTo((Object)deserialized.getPendingFile());
        Assertions.assertThat((Object)committable.getInProgressFileToCleanup()).isEqualTo((Object)deserialized.getInProgressFileToCleanup());
        Assertions.assertThat((Object)committable.getCompactedFileToCleanup()).isEqualTo((Object)deserialized.getCompactedFileToCleanup());
    }

    @Test
    void testCommittableWithCompactedFileToCleanup() throws IOException {
        FileSinkCommittable committable = new FileSinkCommittable("0", new Path("/tmp/mock_path_to_cleanup"));
        FileSinkCommittable deserialized = this.serializeAndDeserialize(committable);
        Assertions.assertThat((String)committable.getBucketId()).isEqualTo(deserialized.getBucketId());
        Assertions.assertThat((Object)committable.getPendingFile()).isEqualTo((Object)deserialized.getPendingFile());
        Assertions.assertThat((Object)committable.getInProgressFileToCleanup()).isEqualTo((Object)deserialized.getInProgressFileToCleanup());
        Assertions.assertThat((Object)committable.getCompactedFileToCleanup()).isEqualTo((Object)deserialized.getCompactedFileToCleanup());
    }

    private FileSinkCommittable serializeAndDeserialize(FileSinkCommittable committable) throws IOException {
        FileSinkCommittableSerializer serializer = new FileSinkCommittableSerializer(new FileSinkTestUtils.SimpleVersionedWrapperSerializer<InProgressFileWriter.PendingFileRecoverable>(FileSinkTestUtils.TestPendingFileRecoverable::new), new FileSinkTestUtils.SimpleVersionedWrapperSerializer<InProgressFileWriter.InProgressFileRecoverable>(FileSinkTestUtils.TestInProgressFileRecoverable::new));
        byte[] data = serializer.serialize(committable);
        return serializer.deserialize(serializer.getVersion(), data);
    }
}

