/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.table;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import org.apache.flink.connector.file.table.FileSystemCommitter;
import org.apache.flink.connector.file.table.FileSystemFactory;
import org.apache.flink.connector.file.table.PartitionCommitPolicy;
import org.apache.flink.connector.file.table.PartitionCommitPolicyFactory;
import org.apache.flink.connector.file.table.TableMetaStoreFactory;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.fs.local.LocalFileSystem;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class FileSystemCommitterTest {
    private static final String SUCCESS_FILE_NAME = "_SUCCESS";
    private final FileSystemFactory fileSystemFactory = FileSystem::get;
    private TableMetaStoreFactory metaStoreFactory;
    private List<PartitionCommitPolicy> policies;
    private ObjectIdentifier identifier;
    @TempDir
    private java.nio.file.Path outputPath;
    @TempDir
    private java.nio.file.Path path;

    @BeforeEach
    public void before() throws IOException {
        this.metaStoreFactory = new TestMetaStoreFactory(new Path(this.outputPath.toString()));
        this.policies = new PartitionCommitPolicyFactory("metastore,success-file", null, SUCCESS_FILE_NAME, null).createPolicyChain(Thread.currentThread().getContextClassLoader(), LocalFileSystem::getSharedInstance);
        this.identifier = ObjectIdentifier.of((String)"hiveCatalog", (String)"default", (String)"test");
    }

    private void createFile(java.nio.file.Path parent, String path, String ... files) throws IOException {
        java.nio.file.Path dir = Files.createDirectories(Paths.get(parent.toString(), path), new FileAttribute[0]);
        for (String file : files) {
            Files.createFile(dir.resolve(file), new FileAttribute[0]);
        }
    }

    @Test
    void testPartition() throws Exception {
        FileSystemCommitter committer = new FileSystemCommitter(this.fileSystemFactory, this.metaStoreFactory, true, new Path(this.path.toString()), 2, false, this.identifier, new LinkedHashMap(), this.policies);
        this.createFile(this.path, "task-1-attempt-0/p1=0/p2=0/", "f1", "f2");
        this.createFile(this.path, "task-2-attempt-0/p1=0/p2=0/", "f3");
        this.createFile(this.path, "task-2-attempt-0/p1=0/p2=1/", "f4");
        committer.commitPartitions();
        Assertions.assertThat((File)new File(this.outputPath.toFile(), "p1=0/p2=0/f1")).exists();
        Assertions.assertThat((File)new File(this.outputPath.toFile(), "p1=0/p2=0/f2")).exists();
        Assertions.assertThat((File)new File(this.outputPath.toFile(), "p1=0/p2=0/f3")).exists();
        Assertions.assertThat((File)new File(this.outputPath.toFile(), "p1=0/p2=0/_SUCCESS")).exists();
        Assertions.assertThat((File)new File(this.outputPath.toFile(), "p1=0/p2=1/f4")).exists();
        Assertions.assertThat((File)new File(this.outputPath.toFile(), "p1=0/p2=1/_SUCCESS")).exists();
        this.createFile(this.path, "task-2-attempt-0/p1=0/p2=1/", "f5");
        committer.commitPartitions();
        Assertions.assertThat((File)new File(this.outputPath.toFile(), "p1=0/p2=0/f1")).exists();
        Assertions.assertThat((File)new File(this.outputPath.toFile(), "p1=0/p2=0/f2")).exists();
        Assertions.assertThat((File)new File(this.outputPath.toFile(), "p1=0/p2=0/f3")).exists();
        Assertions.assertThat((File)new File(this.outputPath.toFile(), "p1=0/p2=0/_SUCCESS")).exists();
        Assertions.assertThat((File)new File(this.outputPath.toFile(), "p1=0/p2=1/f5")).exists();
        Assertions.assertThat((File)new File(this.outputPath.toFile(), "p1=0/p2=1/_SUCCESS")).exists();
        committer = new FileSystemCommitter(this.fileSystemFactory, this.metaStoreFactory, false, new Path(this.path.toString()), 2, false, this.identifier, new LinkedHashMap(), this.policies);
        this.createFile(this.path, "task-2-attempt-0/p1=0/p2=1/", "f6");
        committer.commitPartitions();
        Assertions.assertThat((File)new File(this.outputPath.toFile(), "p1=0/p2=1/f5")).exists();
        Assertions.assertThat((File)new File(this.outputPath.toFile(), "p1=0/p2=1/f6")).exists();
        Assertions.assertThat((File)new File(this.outputPath.toFile(), "p1=0/p2=1/_SUCCESS")).exists();
    }

    @Test
    void testNotPartition() throws Exception {
        FileSystemCommitter committer = new FileSystemCommitter(this.fileSystemFactory, this.metaStoreFactory, true, new Path(this.path.toString()), 0, false, this.identifier, new LinkedHashMap(), this.policies);
        this.createFile(this.path, "task-1-attempt-0/", "f1", "f2");
        this.createFile(this.path, "task-2-attempt-0/", "f3");
        committer.commitPartitions();
        Assertions.assertThat((File)new File(this.outputPath.toFile(), "f1")).exists();
        Assertions.assertThat((File)new File(this.outputPath.toFile(), "f2")).exists();
        Assertions.assertThat((File)new File(this.outputPath.toFile(), "f3")).exists();
        Assertions.assertThat((File)new File(this.outputPath.toFile(), SUCCESS_FILE_NAME)).exists();
        this.createFile(this.path, "task-2-attempt-0/", "f4");
        committer.commitPartitions();
        Assertions.assertThat((File)new File(this.outputPath.toFile(), "f4")).exists();
        Assertions.assertThat((File)new File(this.outputPath.toFile(), SUCCESS_FILE_NAME)).exists();
        committer = new FileSystemCommitter(this.fileSystemFactory, this.metaStoreFactory, false, new Path(this.path.toString()), 0, false, this.identifier, new LinkedHashMap(), this.policies);
        this.createFile(this.path, "task-2-attempt-0/", "f5");
        committer.commitPartitions();
        Assertions.assertThat((File)new File(this.outputPath.toFile(), "f4")).exists();
        Assertions.assertThat((File)new File(this.outputPath.toFile(), "f5")).exists();
        Assertions.assertThat((File)new File(this.outputPath.toFile(), SUCCESS_FILE_NAME)).exists();
    }

    @Test
    void testEmptyPartition() throws Exception {
        LinkedHashMap<String, String> staticPartitions = new LinkedHashMap<String, String>();
        staticPartitions.put("dt", "2022-08-02");
        FileSystemCommitter committer = new FileSystemCommitter(this.fileSystemFactory, this.metaStoreFactory, true, new Path(this.path.toString()), 1, false, this.identifier, staticPartitions, this.policies);
        this.createFile(this.path, "task-1-attempt-0/dt=2022-08-02/", new String[0]);
        this.createFile(this.path, "task-2-attempt-0/dt=2022-08-02/", new String[0]);
        committer.commitPartitions();
        File emptyPartitionFile = new File(this.outputPath.toFile(), "dt=2022-08-02");
        Assertions.assertThat((File)emptyPartitionFile).exists();
        Assertions.assertThat((File)emptyPartitionFile).isDirectory();
        Assertions.assertThat((File)emptyPartitionFile).isNotEmptyDirectory();
        Assertions.assertThat((File)emptyPartitionFile).isDirectoryNotContaining(file -> !file.getName().equals(SUCCESS_FILE_NAME));
        this.createFile(this.outputPath, "dt=2022-08-02/f1", new String[0]);
        Assertions.assertThat((File)new File(emptyPartitionFile, "f1")).exists();
        this.createFile(this.path, "task-1-attempt-0/dt=2022-08-02/", new String[0]);
        this.createFile(this.path, "task-2-attempt-0/dt=2022-08-02/", new String[0]);
        committer.commitPartitions();
        Assertions.assertThat((File)emptyPartitionFile).exists();
        Assertions.assertThat((File)emptyPartitionFile).isDirectory();
        Assertions.assertThat((File)emptyPartitionFile).isNotEmptyDirectory();
        Assertions.assertThat((File)emptyPartitionFile).isDirectoryNotContaining(file -> !file.getName().equals(SUCCESS_FILE_NAME));
        this.createFile(this.outputPath, "dt=2022-08-02/f1", new String[0]);
        Assertions.assertThat((File)new File(emptyPartitionFile, "f1")).exists();
        this.createFile(this.path, "task-1-attempt-0/dt=2022-08-02/", new String[0]);
        this.createFile(this.path, "task-2-attempt-0/dt=2022-08-02/", new String[0]);
        committer = new FileSystemCommitter(this.fileSystemFactory, this.metaStoreFactory, false, new Path(this.path.toString()), 1, false, this.identifier, staticPartitions, this.policies);
        committer.commitPartitions();
        Assertions.assertThat((File)emptyPartitionFile).exists();
        Assertions.assertThat((File)emptyPartitionFile).isDirectory();
        Assertions.assertThat((File)emptyPartitionFile).isNotEmptyDirectory();
        Assertions.assertThat((File)new File(emptyPartitionFile, "f1")).exists();
        Assertions.assertThat((File)new File(emptyPartitionFile, SUCCESS_FILE_NAME)).exists();
    }

    @Test
    void testPartitionPathNotExist() throws Exception {
        Files.delete(this.path);
        LinkedHashMap staticPartitions = new LinkedHashMap();
        FileSystemCommitter committer = new FileSystemCommitter(this.fileSystemFactory, this.metaStoreFactory, true, new Path(this.path.toString()), 1, false, this.identifier, staticPartitions, this.policies);
        committer.commitPartitions();
        Assertions.assertThat((Object[])this.outputPath.toFile().list()).isEqualTo((Object)new String[0]);
    }

    public static class TestMetaStoreFactory
    implements TableMetaStoreFactory {
        private static final long serialVersionUID = 1L;
        private final Path outputPath;

        public TestMetaStoreFactory(Path outputPath) {
            this.outputPath = outputPath;
        }

        public TableMetaStoreFactory.TableMetaStore createTableMetaStore() {
            return new TableMetaStoreFactory.TableMetaStore(){

                public Path getLocationPath() {
                    return outputPath;
                }

                public Optional<Path> getPartition(LinkedHashMap<String, String> partSpec) {
                    return Optional.empty();
                }

                public void createOrAlterPartition(LinkedHashMap<String, String> partitionSpec, Path partitionPath) throws Exception {
                }

                public void close() {
                }
            };
        }
    }
}

