/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.sink;

import java.util.stream.Stream;
import org.apache.flink.api.common.serialization.Encoder;
import org.apache.flink.connector.file.sink.FileSink;
import org.apache.flink.connector.file.sink.utils.IntegerFileSinkTestDataUtils;
import org.apache.flink.connector.file.sink.utils.PartSizeAndCheckpointRollingPolicy;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.minicluster.MiniCluster;
import org.apache.flink.runtime.minicluster.MiniClusterConfiguration;
import org.apache.flink.streaming.api.functions.sink.filesystem.BucketAssigner;
import org.junit.jupiter.api.io.TempDir;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

abstract class FileSinkITBase {
    protected static final int NUM_SOURCES = 4;
    protected static final int NUM_SINKS = 3;
    protected static final int NUM_RECORDS = 10000;
    protected static final int NUM_BUCKETS = 4;
    protected static final double FAILOVER_RATIO = 0.4;

    FileSinkITBase() {
    }

    private static Stream<Boolean> params() {
        return Stream.of(false, true);
    }

    @ParameterizedTest(name="triggerFailover = {0}")
    @MethodSource(value={"params"})
    void testFileSink(boolean triggerFailover, @TempDir java.nio.file.Path tmpDir) throws Exception {
        String path = tmpDir.toString();
        JobGraph jobGraph = this.createJobGraph(triggerFailover, path);
        MiniClusterConfiguration cfg = new MiniClusterConfiguration.Builder().withRandomPorts().setNumTaskManagers(1).setNumSlotsPerTaskManager(4).build();
        try (MiniCluster miniCluster = new MiniCluster(cfg);){
            miniCluster.start();
            miniCluster.executeJobBlocking(jobGraph);
        }
        IntegerFileSinkTestDataUtils.checkIntegerSequenceSinkOutput(path, 10000, 4, 4);
    }

    protected abstract JobGraph createJobGraph(boolean var1, String var2);

    protected FileSink<Integer> createFileSink(String path) {
        return ((FileSink.DefaultRowFormatBuilder)((FileSink.DefaultRowFormatBuilder)FileSink.forRowFormat((Path)new Path(path), (Encoder)new IntegerFileSinkTestDataUtils.IntEncoder()).withBucketAssigner((BucketAssigner)new IntegerFileSinkTestDataUtils.ModuloBucketAssigner(4))).withRollingPolicy(new PartSizeAndCheckpointRollingPolicy(1024L, true))).build();
    }
}

