/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.undertow.handlers;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.PathTemplateHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.camel.component.undertow.handlers.CamelMethodHandler;

public class CamelPathTemplateHandler
implements HttpHandler {
    private final Lock lock = new ReentrantLock();
    private final Map<String, CamelMethodHandler> handlers = new HashMap<String, CamelMethodHandler>();
    private final Wrapper defaultHandlerWrapper = new Wrapper();
    private final PathTemplateHandler delegate;
    private String handlerString;

    public CamelPathTemplateHandler(CamelMethodHandler defaultHandler) {
        this.defaultHandlerWrapper.set(defaultHandler);
        this.delegate = new PathTemplateHandler((HttpHandler)this.defaultHandlerWrapper);
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        this.delegate.handleRequest(exchange);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CamelPathTemplateHandler add(String uriTemplate, CamelMethodHandler handler) {
        this.lock.lock();
        try {
            this.delegate.add(uriTemplate, (HttpHandler)handler);
            this.handlers.put(uriTemplate, handler);
            this.handlerString = null;
            CamelPathTemplateHandler camelPathTemplateHandler = this;
            return camelPathTemplateHandler;
        }
        finally {
            this.lock.unlock();
        }
    }

    public CamelPathTemplateHandler remove(String uriTemplate) {
        this.lock.lock();
        try {
            this.delegate.remove(uriTemplate);
            this.handlers.remove(uriTemplate);
            this.handlerString = null;
            CamelPathTemplateHandler camelPathTemplateHandler = this;
            return camelPathTemplateHandler;
        }
        finally {
            this.lock.unlock();
        }
    }

    public CamelMethodHandler get(String uriTemplate) {
        return this.handlers.get(uriTemplate);
    }

    public boolean isEmpty() {
        return this.handlers.isEmpty();
    }

    public CamelMethodHandler getDefault() {
        this.lock.lock();
        try {
            CamelMethodHandler camelMethodHandler = this.defaultHandlerWrapper.get();
            return camelMethodHandler;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setDefault(CamelMethodHandler defaultHandler) {
        this.lock.lock();
        try {
            this.defaultHandlerWrapper.set(defaultHandler);
            this.handlerString = null;
        }
        finally {
            this.lock.unlock();
        }
    }

    public String toString() {
        if (this.handlerString == null) {
            this.handlerString = "CamelPathTemplateHandler[default=" + this.defaultHandlerWrapper.get() + ", " + this.handlers + "]";
        }
        return this.handlerString;
    }

    static class Wrapper
    implements HttpHandler {
        private CamelMethodHandler handler;

        Wrapper() {
        }

        public void set(CamelMethodHandler handler) {
            this.handler = handler;
        }

        public CamelMethodHandler get() {
            return this.handler;
        }

        public void handleRequest(HttpServerExchange exchange) throws Exception {
            this.handler.handleRequest(exchange);
        }
    }
}

