/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.mongodb.services;

import org.apache.camel.spi.annotations.InfraService;
import org.apache.camel.test.infra.common.LocalPropertyResolver;
import org.apache.camel.test.infra.common.services.ContainerEnvironmentUtil;
import org.apache.camel.test.infra.common.services.ContainerService;
import org.apache.camel.test.infra.mongodb.services.MongoDBInfraService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.MongoDBContainer;
import org.testcontainers.utility.DockerImageName;

@InfraService(service=MongoDBInfraService.class, description="MongoDB NoSql Database", serviceAlias={"mongodb"})
public class MongoDBLocalContainerInfraService
implements MongoDBInfraService,
ContainerService<MongoDBContainer> {
    private static final Logger LOG = LoggerFactory.getLogger(MongoDBLocalContainerInfraService.class);
    private static final int DEFAULT_MONGODB_PORT = 27017;
    private final MongoDBContainer container;

    public MongoDBLocalContainerInfraService() {
        this(LocalPropertyResolver.getProperty(MongoDBLocalContainerInfraService.class, (String)"mongodb.container"));
    }

    public MongoDBLocalContainerInfraService(String imageName) {
        this.container = this.initContainer(imageName);
        String name = ContainerEnvironmentUtil.containerName(this.getClass());
        if (name != null) {
            this.container.withCreateContainerCmdModifier(cmd -> cmd.withName(name));
        }
    }

    public MongoDBLocalContainerInfraService(MongoDBContainer container) {
        this.container = container;
    }

    protected MongoDBContainer initContainer(String imageName) {
        class TestInfraMongoDBContainer
        extends MongoDBContainer {
            public TestInfraMongoDBContainer(boolean fixedPort, String imageName) {
                super(DockerImageName.parse((String)imageName).asCompatibleSubstituteFor("mongo"));
                this.addPort(fixedPort);
            }

            private void addPort(boolean fixedPort) {
                if (fixedPort) {
                    this.addFixedExposedPort(27017, 27017);
                } else {
                    this.addExposedPort(27017);
                }
            }
        }
        return new TestInfraMongoDBContainer(ContainerEnvironmentUtil.isFixedPort(this.getClass()), imageName);
    }

    @Override
    public String getReplicaSetUrl() {
        return String.format("mongodb://%s:%s", this.container.getHost(), this.container.getMappedPort(27017));
    }

    @Override
    public String getConnectionAddress() {
        return this.container.getHost() + ":" + this.container.getMappedPort(27017);
    }

    public void registerProperties() {
        System.setProperty("mongodb.url", this.getReplicaSetUrl());
        System.setProperty("mongodb.connection.address", this.getConnectionAddress());
    }

    public void initialize() {
        LOG.info("Trying to start the MongoDB service");
        this.container.start();
        this.registerProperties();
        LOG.info("MongoDB service running at {}", (Object)this.container.getReplicaSetUrl());
    }

    public void shutdown() {
        LOG.info("Stopping the MongoDB container");
        this.container.stop();
    }

    public MongoDBContainer getContainer() {
        return this.container;
    }
}

