/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.kafka.services;

import org.apache.camel.spi.annotations.InfraService;
import org.apache.camel.test.infra.common.TestUtils;
import org.apache.camel.test.infra.common.services.ContainerEnvironmentUtil;
import org.apache.camel.test.infra.common.services.ContainerService;
import org.apache.camel.test.infra.kafka.services.ConfluentContainer;
import org.apache.camel.test.infra.kafka.services.KafkaInfraService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.Network;

@InfraService(service=KafkaInfraService.class, description="Apache Kafka, Distributed event streaming platform", serviceAlias={"kafka"}, serviceImplementationAlias={"confluent"})
public class ConfluentInfraService
implements KafkaInfraService,
ContainerService<ConfluentContainer> {
    private static final Logger LOG = LoggerFactory.getLogger(ConfluentInfraService.class);
    private final ConfluentContainer confluentContainer;

    public ConfluentInfraService() {
        this("confluent-" + TestUtils.randomWithRange((int)1, (int)100));
    }

    public ConfluentInfraService(String confluentInstanceName) {
        Network network = Network.newNetwork();
        this.confluentContainer = this.initConfluentContainer(network, confluentInstanceName);
    }

    public ConfluentInfraService(ConfluentContainer confluentContainer) {
        this.confluentContainer = confluentContainer;
    }

    protected ConfluentContainer initConfluentContainer(Network network, String instanceName) {
        class TestInfraConfluentContainer
        extends ConfluentContainer {
            public TestInfraConfluentContainer(Network network, String name, boolean fixedPort) {
                super(network, name);
                if (fixedPort) {
                    this.addFixedExposedPort(9092, 9092);
                }
            }
        }
        return new TestInfraConfluentContainer(network, instanceName, ContainerEnvironmentUtil.isFixedPort(this.getClass()));
    }

    protected Integer getKafkaPort() {
        return this.confluentContainer.getKafkaPort();
    }

    @Override
    public String getBootstrapServers() {
        return this.confluentContainer.getHost() + ":" + this.getKafkaPort();
    }

    @Override
    public String brokers() {
        return this.getBootstrapServers();
    }

    public void registerProperties() {
        System.setProperty("kafka.bootstrap.servers", this.getBootstrapServers());
    }

    public void initialize() {
        this.confluentContainer.start();
        this.registerProperties();
        LOG.info("Kafka bootstrap server running at address {}", (Object)this.getBootstrapServers());
    }

    private boolean stopped() {
        return !this.confluentContainer.isRunning();
    }

    public void shutdown() {
        try {
            LOG.info("Stopping Kafka container");
            this.confluentContainer.stop();
        }
        finally {
            TestUtils.waitFor(this::stopped);
        }
    }

    public ConfluentContainer getContainer() {
        return this.confluentContainer;
    }
}

