/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.kafka.services;

import org.apache.camel.spi.annotations.InfraService;
import org.apache.camel.test.infra.common.TestUtils;
import org.apache.camel.test.infra.common.services.ContainerEnvironmentUtil;
import org.apache.camel.test.infra.common.services.ContainerService;
import org.apache.camel.test.infra.kafka.services.KafkaInfraService;
import org.apache.camel.test.infra.kafka.services.StrimziContainer;
import org.apache.camel.test.infra.kafka.services.ZookeeperContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.Network;

@InfraService(service=KafkaInfraService.class, description="Apache Kafka, Distributed event streaming platform", serviceAlias={"kafka"}, serviceImplementationAlias={"strimzi"})
public class StrimziInfraService
implements KafkaInfraService,
ContainerService<StrimziContainer> {
    private static final Logger LOG = LoggerFactory.getLogger(StrimziInfraService.class);
    private final ZookeeperContainer zookeeperContainer;
    private final StrimziContainer strimziContainer;

    public StrimziInfraService() {
        this("zookeeper-" + TestUtils.randomWithRange((int)1, (int)100), "strimzi-" + TestUtils.randomWithRange((int)1, (int)100));
    }

    public StrimziInfraService(String zookeeperInstanceName, String strimziInstanceName) {
        Network network = Network.newNetwork();
        this.zookeeperContainer = this.initZookeeperContainer(network, zookeeperInstanceName);
        this.strimziContainer = this.initStrimziContainer(network, strimziInstanceName, zookeeperInstanceName);
        String name = ContainerEnvironmentUtil.containerName(this.getClass());
        if (name != null) {
            this.strimziContainer.withCreateContainerCmdModifier(cmd -> cmd.withName(name));
        }
    }

    public StrimziInfraService(ZookeeperContainer zookeeperContainer, StrimziContainer strimziContainer) {
        this.zookeeperContainer = zookeeperContainer;
        this.strimziContainer = strimziContainer;
    }

    protected StrimziContainer initStrimziContainer(Network network, String instanceName, String zookeeperInstanceName) {
        class TestInfraStrimziContainer
        extends StrimziContainer {
            public TestInfraStrimziContainer(Network network, String name, String zookeeperInstanceName, boolean fixedPort) {
                super(network, name, zookeeperInstanceName);
                if (fixedPort) {
                    this.addFixedExposedPort(9092, 9092);
                }
            }
        }
        return new TestInfraStrimziContainer(network, instanceName, zookeeperInstanceName, ContainerEnvironmentUtil.isFixedPort(this.getClass()));
    }

    protected ZookeeperContainer initZookeeperContainer(Network network, String instanceName) {
        class TestInfraZookeeperContainer
        extends ZookeeperContainer {
            public TestInfraZookeeperContainer(Network network, String name, boolean fixedPort) {
                super(network, name);
                if (fixedPort) {
                    this.addFixedExposedPort(2181, 2181);
                }
            }
        }
        return new TestInfraZookeeperContainer(network, instanceName, ContainerEnvironmentUtil.isFixedPort(this.getClass()));
    }

    protected Integer getKafkaPort() {
        return this.strimziContainer.getKafkaPort();
    }

    @Override
    public String getBootstrapServers() {
        return this.strimziContainer.getHost() + ":" + this.getKafkaPort();
    }

    @Override
    public String brokers() {
        return this.getBootstrapServers();
    }

    public void registerProperties() {
        System.setProperty("kafka.bootstrap.servers", this.getBootstrapServers());
    }

    public void initialize() {
        this.zookeeperContainer.start();
        String zookeeperConnect = this.zookeeperContainer.getHost() + ":" + this.zookeeperContainer.getZookeeperPort();
        LOG.info("Apache Zookeeper running at address {}", (Object)zookeeperConnect);
        this.strimziContainer.start();
        this.registerProperties();
        LOG.info("Kafka bootstrap server running at address {}", (Object)this.getBootstrapServers());
    }

    private boolean stopped() {
        return !this.strimziContainer.isRunning() && !this.zookeeperContainer.isRunning();
    }

    public void shutdown() {
        try {
            LOG.info("Stopping Kafka container");
            this.strimziContainer.stop();
        }
        finally {
            LOG.info("Stopping Zookeeper container");
            this.zookeeperContainer.stop();
            TestUtils.waitFor(this::stopped);
        }
    }

    public StrimziContainer getContainer() {
        return this.strimziContainer;
    }

    protected ZookeeperContainer getZookeeperContainer() {
        return this.zookeeperContainer;
    }
}

