/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.common.services;

import org.apache.camel.test.infra.common.services.ContainerEnvironmentUtil;
import org.apache.camel.test.infra.common.services.ContainerService;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface ContainerTestService
extends ExecutionCondition {
    default public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext extensionContext) {
        if (ContainerEnvironmentUtil.isDockerAvailable()) {
            return ConditionEvaluationResult.enabled((String)"Docker is available");
        }
        Logger logger = LoggerFactory.getLogger(ContainerService.class);
        logger.warn("Test {} is disabled because docker is not available", extensionContext.getElement().orElse(null));
        logger.warn("Container-based tests were disabled because Docker is NOT available. Check the log files on target/failsafe-reports");
        return ConditionEvaluationResult.disabled((String)"Docker is NOT available");
    }
}

