/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.aws2.services;

import java.net.URI;
import java.util.Properties;
import org.apache.camel.test.infra.aws.common.services.AWSInfraService;
import org.apache.camel.test.infra.aws2.services.AWSContainer;
import org.apache.camel.test.infra.aws2.services.Service;
import org.apache.camel.test.infra.common.LocalPropertyResolver;
import org.apache.camel.test.infra.common.services.ContainerEnvironmentUtil;
import org.apache.camel.test.infra.common.services.ContainerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.regions.Region;

public abstract class AWSLocalContainerInfraService
implements AWSInfraService,
ContainerService<AWSContainer> {
    private static final Logger LOG = LoggerFactory.getLogger(AWSLocalContainerInfraService.class);
    private final AWSContainer container;

    public AWSLocalContainerInfraService(Service ... services) {
        this(LocalPropertyResolver.getProperty(AWSContainer.class, (String)"aws.container"), services);
    }

    public AWSLocalContainerInfraService(AWSContainer container) {
        this.container = container;
    }

    public AWSLocalContainerInfraService(String imageName, Service ... services) {
        this.container = this.initContainer(imageName, new Service[0]);
        String name = ContainerEnvironmentUtil.containerName(this.getClass());
        if (name != null) {
            this.container.withCreateContainerCmdModifier(cmd -> cmd.withName(name));
        }
        this.container.setupServices(services);
    }

    protected AWSContainer initContainer(String imageName, Service ... services) {
        boolean fixedPort = !this.getClass().getName().contains("TestService");
        return new AWSContainer(imageName, fixedPort, services);
    }

    private String getAmazonHost() {
        return this.container.getAmazonHost();
    }

    public AWSContainer getContainer() {
        return this.container;
    }

    public String amazonAWSHost() {
        return this.container.getAmazonHost();
    }

    public String region() {
        return Region.US_EAST_1.toString();
    }

    public String protocol() {
        return "http";
    }

    public String accessKey() {
        return this.container.getCredentialsProvider().resolveCredentials().accessKeyId();
    }

    public String secretKey() {
        return this.container.getCredentialsProvider().resolveCredentials().secretAccessKey();
    }

    public Properties getConnectionProperties() {
        Properties properties = new Properties();
        properties.put("aws.access.key", this.accessKey());
        properties.put("aws.secret.key", this.secretKey());
        properties.put("aws.region", this.region());
        properties.put("aws.host", this.amazonAWSHost());
        properties.put("aws.protocol", this.protocol());
        return properties;
    }

    public URI getServiceEndpoint() {
        return this.container.getServiceEndpoint();
    }

    public void registerProperties() {
        AwsCredentials credentials = this.container.getCredentialsProvider().resolveCredentials();
        System.setProperty("aws.host", this.getAmazonHost());
        System.setProperty("aws.secret.key", credentials.secretAccessKey());
        System.setProperty("aws.access.key", credentials.accessKeyId());
        System.setProperty("aws.host", this.getAmazonHost());
        System.setProperty("aws.region", Region.US_EAST_1.toString());
        System.setProperty("aws.protocol", "http");
    }

    public void initialize() {
        LOG.debug("Trying to start the container");
        this.container.withStartupAttempts(5);
        this.container.start();
        this.registerProperties();
        LOG.info("AWS service running at address {}", (Object)this.getServiceEndpoint());
    }

    public void shutdown() {
        LOG.info("Stopping the local AWS services");
        this.container.stop();
    }
}

