/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.telegram.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.camel.component.telegram.model.InputMessageContent;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class InputTextMessageContent
implements InputMessageContent {
    @JsonProperty(value="message_text")
    private String messageText;
    @JsonProperty(value="parse_mode")
    private String parseMode;
    @JsonProperty(value="disable_web_page_preview")
    private Boolean disableWebPagePreview;

    public InputTextMessageContent(String messageText, String parseMode, Boolean disableWebPagePreview) {
        this.messageText = messageText;
        this.parseMode = parseMode;
        this.disableWebPagePreview = disableWebPagePreview;
    }

    public InputTextMessageContent() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getMessageText() {
        return this.messageText;
    }

    public void setMessageText(String messageText) {
        this.messageText = messageText;
    }

    public String getParseMode() {
        return this.parseMode;
    }

    public void setParseMode(String parseMode) {
        this.parseMode = parseMode;
    }

    public Boolean getDisableWebPagePreview() {
        return this.disableWebPagePreview;
    }

    public void setDisableWebPagePreview(Boolean disableWebPagePreview) {
        this.disableWebPagePreview = disableWebPagePreview;
    }

    public static final class Builder {
        private String messageText;
        private String parseMode;
        private Boolean disableWebPagePreview;

        private Builder() {
        }

        public Builder messageText(String messageText) {
            this.messageText = messageText;
            return this;
        }

        public Builder parseMode(String parseMode) {
            this.parseMode = parseMode;
            return this;
        }

        public Builder disableWebPagePreview(Boolean disableWebPagePreview) {
            this.disableWebPagePreview = disableWebPagePreview;
            return this;
        }

        public InputTextMessageContent build() {
            InputTextMessageContent inputTextMessageContent = new InputTextMessageContent();
            inputTextMessageContent.setMessageText(this.messageText);
            inputTextMessageContent.setParseMode(this.parseMode);
            inputTextMessageContent.setDisableWebPagePreview(this.disableWebPagePreview);
            return inputTextMessageContent;
        }
    }
}

