/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.github;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import org.apache.camel.CamelContext;
import org.apache.camel.support.ResourceSupport;

public final class GistResource
extends ResourceSupport {
    private final CamelContext camelContext;
    private byte[] cache;
    private boolean init;

    public GistResource(CamelContext camelContext, String location) {
        super("gist", location);
        this.camelContext = camelContext;
    }

    public boolean exists() {
        if (!this.init) {
            try {
                URL u = URI.create(this.getLocation()).toURL();
                try (InputStream is = u.openStream();){
                    this.cache = (byte[])this.camelContext.getTypeConverter().tryConvertTo(byte[].class, (Object)is);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.init = true;
        }
        return this.cache != null;
    }

    public InputStream getInputStream() throws IOException {
        if (this.exists()) {
            return new ByteArrayInputStream(this.cache);
        }
        return null;
    }
}

