/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.camel.catalog.common.CatalogHelper;
import org.apache.camel.maven.htmlxlsx.process.CoverageResultsProcessor;
import org.apache.camel.maven.model.RouteCoverageNode;
import org.apache.camel.parser.RouteBuilderParser;
import org.apache.camel.parser.XmlRouteParser;
import org.apache.camel.parser.helper.RouteCoverageHelper;
import org.apache.camel.parser.model.CamelNodeDetails;
import org.apache.camel.parser.model.CoverageData;
import org.apache.camel.util.FileUtil;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.jboss.forge.roaster.Roaster;
import org.jboss.forge.roaster.model.JavaType;
import org.jboss.forge.roaster.model.source.JavaClassSource;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Mojo(name="route-coverage", threadSafe=true)
public class RouteCoverageMojo
extends AbstractMojo {
    public static final String DESTINATION_DIR = "/target/camel-route-coverage";
    private static final String MAIN_FORMAT_PATTERN = "%8s    %8s    %s%n";
    @Parameter(property="project", required=true, readonly=true)
    protected MavenProject project;
    @Parameter(property="camel.skipRouteCoverage", defaultValue="false")
    private boolean skip;
    @Parameter(property="camel.failOnError", defaultValue="false")
    private boolean failOnError;
    @Parameter(property="camel.coverageThreshold", defaultValue="100")
    private byte coverageThreshold = (byte)100;
    @Parameter(property="camel.overallCoverageThreshold", defaultValue="0")
    private byte overallCoverageThreshold;
    @Parameter(property="camel.includeTest", defaultValue="false")
    private boolean includeTest;
    @Parameter(property="camel.includes")
    private String includes;
    @Parameter(property="camel.excludes")
    private String excludes;
    @Deprecated
    @Parameter(property="camel.anonymousRoutes", defaultValue="false")
    private boolean anonymousRoutes;
    @Parameter(property="camel.generateJacocoXmlReport", defaultValue="false")
    private boolean generateJacocoXmlReport;
    @Parameter(property="camel.generateHtmlReport", defaultValue="false")
    private boolean generateHtmlReport;

    private File createJacocoDir() {
        File file = new File(this.project.getBasedir() + "/target/site/jacoco");
        if (!file.exists() && !file.mkdirs()) {
            this.getLog().warn((CharSequence)("Could not create jacoco directory: " + file.getAbsolutePath()));
        }
        return file;
    }

    public void execute() throws MojoExecutionException {
        String packageName;
        String sourceFileName;
        String fileName;
        if (this.skip) {
            this.getLog().info((CharSequence)"skipping route coverage as per configuration");
            return;
        }
        if (this.anonymousRoutes) {
            this.getLog().warn((CharSequence)"AnonymousRoutes is deprecated. Add route ids to these routes for route coverage support.");
        }
        List<CamelNodeDetails> routeTrees = this.discoverRoutes();
        AtomicInteger notCovered = new AtomicInteger();
        AtomicInteger coveredNodes = new AtomicInteger();
        int totalNumberOfNodes = 0;
        List<CamelNodeDetails> routeIdTrees = routeTrees.stream().filter(t -> t.getRouteId() != null).toList();
        ArrayList<CamelNodeDetails> anonymousRouteTrees = new ArrayList<CamelNodeDetails>(routeTrees.stream().filter(t -> t.getRouteId() == null).toList());
        Document document = null;
        File file = null;
        Element report = null;
        if (this.generateJacocoXmlReport) {
            try {
                file = this.createJacocoDir();
                document = RouteCoverageMojo.createDocument();
                report = document.createElement("report");
                RouteCoverageMojo.createAttrString(document, report, "name", "Camel Xml");
                document.appendChild(report);
            }
            catch (Exception e) {
                this.getLog().warn((CharSequence)("Error generating Jacoco XML report due " + e.getMessage()));
            }
        }
        for (CamelNodeDetails camelNodeDetails : routeIdTrees) {
            String routeId = camelNodeDetails.getRouteId();
            fileName = CatalogHelper.stripRootPath((String)CatalogHelper.asRelativeFile((String)camelNodeDetails.getFileName(), (MavenProject)this.project), (MavenProject)this.project);
            sourceFileName = new File(fileName).getName();
            packageName = new File(fileName).getParent();
            Element pack = null;
            if (report != null) {
                pack = document.createElement("package");
                RouteCoverageMojo.createAttrString(document, pack, "name", packageName);
                report.appendChild(pack);
            }
            totalNumberOfNodes += this.grabDumpData(camelNodeDetails, routeId, totalNumberOfNodes, fileName, notCovered, coveredNodes, report, document, sourceFileName, pack);
        }
        ArrayList<CamelNodeDetails> anonymousHandled = new ArrayList<CamelNodeDetails>();
        for (CamelNodeDetails t3 : anonymousRouteTrees) {
            int extra;
            fileName = CatalogHelper.stripRootPath((String)CatalogHelper.asRelativeFile((String)t3.getFileName(), (MavenProject)this.project), (MavenProject)this.project);
            sourceFileName = new File(fileName).getName();
            packageName = new File(fileName).getParent();
            String loc = sourceFileName + ":" + t3.getLineNumber();
            Element pack = null;
            if (report != null) {
                pack = document.createElement("package");
                RouteCoverageMojo.createAttrString(document, pack, "name", packageName);
                report.appendChild(pack);
            }
            if ((extra = this.grabDumpDataBySourceLocation(t3, loc, totalNumberOfNodes, fileName, notCovered, coveredNodes, report, document, sourceFileName, pack)) > 0) {
                anonymousHandled.add(t3);
            }
            totalNumberOfNodes += extra;
        }
        anonymousRouteTrees.removeAll(anonymousHandled);
        if (!anonymousRouteTrees.isEmpty()) {
            if (this.anonymousRoutes) {
                totalNumberOfNodes = this.handleAnonymousRoutes(anonymousRouteTrees, totalNumberOfNodes, notCovered, coveredNodes);
            } else {
                this.getLog().warn((CharSequence)("Discovered " + anonymousRouteTrees.size() + " anonymous routes. Add route ids to these routes for route coverage support."));
            }
        }
        if (report != null) {
            this.doGenerateJacocoReport(file, document);
        }
        if (this.generateHtmlReport) {
            this.doGenerateHtmlReport();
        }
        AtomicBoolean atomicBoolean = new AtomicBoolean();
        String out = this.templateOverallCoverageData(coveredNodes.get(), totalNumberOfNodes, atomicBoolean);
        this.getLog().info((CharSequence)("Overall coverage summary:\n\n" + out));
        this.getLog().info((CharSequence)"");
        this.evalFailingConditions(notCovered, atomicBoolean);
    }

    private void evalFailingConditions(AtomicInteger notCovered, AtomicBoolean overallCoverageAboveThreshold) throws MojoExecutionException {
        if (!this.failOnError) {
            return;
        }
        if (notCovered.get() > 0) {
            throw new MojoExecutionException("There are " + notCovered.get() + " route(s) not fully covered!");
        }
        if (!overallCoverageAboveThreshold.get()) {
            throw new MojoExecutionException("The overall coverage is below " + this.overallCoverageThreshold + "%!");
        }
    }

    private List<CamelNodeDetails> discoverRoutes() {
        LinkedHashSet javaFiles = new LinkedHashSet();
        LinkedHashSet xmlFiles = new LinkedHashSet();
        CatalogHelper.findJavaRouteBuilderClasses(javaFiles, (boolean)true, (boolean)this.includeTest, (MavenProject)this.project);
        CatalogHelper.findXmlRouters(xmlFiles, (boolean)true, (boolean)this.includeTest, (MavenProject)this.project);
        ArrayList<CamelNodeDetails> routeTrees = new ArrayList<CamelNodeDetails>();
        for (File file : javaFiles) {
            this.addJavaFiles(file, routeTrees);
        }
        for (File file : xmlFiles) {
            this.addXmlFiles(file, routeTrees);
        }
        this.getLog().info((CharSequence)("Discovered " + routeTrees.size() + " routes"));
        return routeTrees;
    }

    private int grabDumpData(CamelNodeDetails t, String routeId, int totalNumberOfNodes, String fileName, AtomicInteger notCovered, AtomicInteger coveredNodes, Element report, Document document, String sourceFileName, Element pack) throws MojoExecutionException {
        try {
            List coverageData = RouteCoverageHelper.parseDumpRouteCoverageByRouteId((String)(this.project.getBasedir() + DESTINATION_DIR), (String)routeId);
            if (coverageData.isEmpty()) {
                this.getLog().warn((CharSequence)("No route coverage data found for route: " + routeId + ". Make sure to enable route coverage in your unit tests and assign unique route ids to your routes. Also remember to run unit tests first."));
            } else {
                List<RouteCoverageNode> coverage = RouteCoverageMojo.gatherRouteCoverageSummary(List.of(t), coverageData);
                totalNumberOfNodes += coverage.size();
                String out = this.templateCoverageData(fileName, routeId, coverage, notCovered, coveredNodes);
                this.getLog().info((CharSequence)("Route coverage summary:\n\n" + out));
                this.getLog().info((CharSequence)"");
                if (report != null) {
                    this.appendSourcefileNode(document, sourceFileName, pack, coverage);
                }
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error during gathering route coverage data for route: " + routeId, e);
        }
        return totalNumberOfNodes;
    }

    private int grabDumpDataBySourceLocation(CamelNodeDetails t, String sourceLocation, int totalNumberOfNodes, String fileName, AtomicInteger notCovered, AtomicInteger coveredNodes, Element report, Document document, String sourceFileName, Element pack) throws MojoExecutionException {
        try {
            List coverageData = RouteCoverageHelper.parseDumpRouteCoverageByLineNumber((String)(this.project.getBasedir() + DESTINATION_DIR), (String)sourceLocation);
            if (coverageData.isEmpty()) {
                this.getLog().warn((CharSequence)("No route coverage data found for route: " + sourceLocation + ". Make sure to enable route coverage in your unit tests and assign unique route ids to your routes. Also remember to run unit tests first."));
            } else {
                List<RouteCoverageNode> coverage = RouteCoverageMojo.gatherRouteCoverageSummary(List.of(t), coverageData);
                totalNumberOfNodes += coverage.size();
                String routeId = ((CoverageData)coverageData.get(0)).getRouteId();
                String out = this.templateCoverageData(fileName, routeId, coverage, notCovered, coveredNodes);
                this.getLog().info((CharSequence)("Route coverage summary:\n\n" + out));
                this.getLog().info((CharSequence)"");
                if (report != null) {
                    this.appendSourcefileNode(document, sourceFileName, pack, coverage);
                }
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error during gathering route coverage data for route: " + sourceFileName, e);
        }
        return totalNumberOfNodes;
    }

    private void doGenerateJacocoReport(File file, Document document) {
        try {
            this.getLog().info((CharSequence)("Generating Jacoco XML report: " + file + "\n\n"));
            RouteCoverageMojo.createJacocoXmlFile(document, file);
        }
        catch (Exception e) {
            this.getLog().warn((CharSequence)("Error generating Jacoco XML report due " + e.getMessage()));
        }
    }

    private int handleAnonymousRoutes(List<CamelNodeDetails> anonymousRouteTrees, int totalNumberOfNodes, AtomicInteger notCovered, AtomicInteger coveredNodes) throws MojoExecutionException {
        try {
            Map datas = RouteCoverageHelper.parseDumpRouteCoverageByClassAndTestMethod((String)(this.project.getBasedir() + DESTINATION_DIR));
            if (datas.isEmpty()) {
                this.getLog().warn((CharSequence)"No route coverage data found. Make sure to enable route coverage in your unit tests. Also remember to run unit tests first.");
            } else {
                Map<String, List<CamelNodeDetails>> routes = this.groupAnonymousRoutesByClassName(anonymousRouteTrees);
                for (Map.Entry<String, List<CamelNodeDetails>> t : routes.entrySet()) {
                    ArrayList<RouteCoverageNode> coverage = new ArrayList<RouteCoverageNode>();
                    String className = t.getKey();
                    for (Map.Entry entry : datas.entrySet()) {
                        String key = (String)entry.getKey();
                        String dataClassName = key.substring(0, key.indexOf(45));
                        if (!dataClassName.equals(className)) continue;
                        List<RouteCoverageNode> result = RouteCoverageMojo.gatherRouteCoverageSummary(t.getValue(), (List)entry.getValue());
                        this.mergeCoverageData(coverage, result);
                    }
                    if (coverage.isEmpty()) continue;
                    totalNumberOfNodes += coverage.size();
                    String fileName = CatalogHelper.stripRootPath((String)CatalogHelper.asRelativeFile((String)t.getValue().get(0).getFileName(), (MavenProject)this.project), (MavenProject)this.project);
                    String out = this.templateCoverageData(fileName, null, coverage, notCovered, coveredNodes);
                    this.getLog().info((CharSequence)("Route coverage summary:\n\n" + out));
                    this.getLog().info((CharSequence)"");
                }
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error during gathering route coverage data ", e);
        }
        return totalNumberOfNodes;
    }

    private void doGenerateHtmlReport() {
        try {
            File jsPath;
            File cssPath;
            String baseHtmlPath = "/target/site/route-coverage/html";
            File htmlPath = new File(this.project.getBasedir() + "/target/site/route-coverage/html");
            if (!htmlPath.exists()) {
                htmlPath.mkdirs();
            }
            if (!(cssPath = new File(this.project.getBasedir() + "/target/site/route-coverage/html/static/css")).exists()) {
                cssPath.mkdirs();
            }
            if (!(jsPath = new File(this.project.getBasedir() + "/target/site/route-coverage/html/static/js")).exists()) {
                jsPath.mkdirs();
            }
            this.getLog().info((CharSequence)"");
            this.getLog().info((CharSequence)("Generating HTML route coverage reports: " + htmlPath + "\n"));
            CoverageResultsProcessor processor = new CoverageResultsProcessor();
            processor.writeCSS(cssPath);
            processor.writeJS(jsPath);
            File xmlPath = new File(this.project.getBasedir() + DESTINATION_DIR);
            String out = processor.generateReport(this.project, xmlPath, htmlPath);
            this.getLog().info((CharSequence)out);
        }
        catch (Exception e) {
            this.getLog().warn((CharSequence)("Error generating HTML route coverage reports due " + e.getMessage()));
        }
    }

    private void addXmlFiles(File file, List<CamelNodeDetails> routeTrees) {
        if (this.matchFile(file)) {
            try {
                String fqn = file.getPath();
                String baseDir = ".";
                FileInputStream is = new FileInputStream(file);
                List result = XmlRouteParser.parseXmlRouteTree((InputStream)is, (String)baseDir, (String)fqn);
                routeTrees.addAll(result);
                ((InputStream)is).close();
            }
            catch (Exception e) {
                this.getLog().warn((CharSequence)("Error parsing xml file " + file + " code due " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private void addJavaFiles(File file, List<CamelNodeDetails> routeTrees) {
        if (this.matchFile(file)) {
            try {
                String fqn = file.getPath();
                JavaType out = Roaster.parse((File)file);
                if (out instanceof JavaClassSource) {
                    JavaClassSource clazz = (JavaClassSource)out;
                    List result = RouteBuilderParser.parseRouteBuilderTree((JavaClassSource)clazz, (String)fqn, (boolean)true);
                    routeTrees.addAll(result);
                }
            }
            catch (Exception e) {
                this.getLog().warn((CharSequence)("Error parsing java file " + file + " code due " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private Map<String, List<CamelNodeDetails>> groupAnonymousRoutesByClassName(List<CamelNodeDetails> anonymousRouteTrees) {
        LinkedHashMap<String, List<CamelNodeDetails>> answer = new LinkedHashMap<String, List<CamelNodeDetails>>();
        for (CamelNodeDetails t : anonymousRouteTrees) {
            String fileName = CatalogHelper.asRelativeFile((String)t.getFileName(), (MavenProject)this.project);
            String className = FileUtil.stripExt((String)FileUtil.stripPath((String)fileName));
            List list = answer.computeIfAbsent(className, k -> new ArrayList());
            list.add(t);
        }
        return answer;
    }

    private void mergeCoverageData(List<RouteCoverageNode> coverage, List<RouteCoverageNode> result) {
        ArrayList<RouteCoverageNode> toBeAdded = new ArrayList<RouteCoverageNode>();
        ListIterator<RouteCoverageNode> it = null;
        for (RouteCoverageNode node : result) {
            RouteCoverageNode existing;
            RouteCoverageNode routeCoverageNode = existing = (it = this.positionToLineNumber(it, coverage, node.getLineNumber())).hasNext() ? it.next() : null;
            if (existing != null) {
                int count = existing.getCount() + node.getCount();
                existing.setCount(count);
                continue;
            }
            toBeAdded.add(node);
        }
        if (!toBeAdded.isEmpty()) {
            coverage.addAll(toBeAdded);
        }
    }

    private ListIterator<RouteCoverageNode> positionToLineNumber(ListIterator<RouteCoverageNode> it, List<RouteCoverageNode> coverage, int lineNumber) {
        if (it == null || !it.hasNext()) {
            it = coverage.listIterator();
        }
        while (it.hasNext()) {
            RouteCoverageNode node = it.next();
            if (node.getLineNumber() != lineNumber) continue;
            it.previous();
            return it;
        }
        return it;
    }

    private String templateCoverageData(String fileName, String routeId, List<RouteCoverageNode> model, AtomicInteger notCovered, AtomicInteger coveredNodes) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintStream sw = new PrintStream(bos);
        if (model.get(0).getClassName() != null) {
            sw.println("Class:\t" + model.get(0).getClassName());
        } else {
            sw.println("File:\t" + fileName);
        }
        if (routeId != null) {
            sw.println("Route:\t" + routeId);
        }
        sw.println();
        sw.printf(MAIN_FORMAT_PATTERN, "Line #", "Count", "Route");
        sw.printf(MAIN_FORMAT_PATTERN, "------", "-----", "-----");
        int covered = 0;
        for (RouteCoverageNode node : model) {
            if (node.getCount() > 0) {
                ++covered;
            }
            String pad = RouteCoverageMojo.padString(node.getLevel());
            sw.printf(MAIN_FORMAT_PATTERN, node.getLineNumber(), node.getCount(), pad + node.getName());
        }
        coveredNodes.addAndGet(covered);
        double percentage = (double)covered / (double)model.size() * 100.0;
        boolean success = true;
        if (covered != model.size() && percentage < (double)this.coverageThreshold) {
            notCovered.incrementAndGet();
            success = false;
        }
        sw.println();
        sw.println("Coverage: " + covered + " out of " + model.size() + " (" + String.format(Locale.ROOT, "%.1f", percentage) + "% / threshold " + this.coverageThreshold + ".0%)");
        sw.println("Status: " + (success ? "Success" : "Failed"));
        sw.println();
        return bos.toString();
    }

    private String templateOverallCoverageData(int coveredNodes, int totalNumberOfNodes, AtomicBoolean overallCoverageAboveThreshold) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintStream sw = new PrintStream(bos);
        double percentage = totalNumberOfNodes > 0 ? (double)coveredNodes / (double)totalNumberOfNodes * 100.0 : 100.0;
        overallCoverageAboveThreshold.set(coveredNodes == totalNumberOfNodes || percentage >= (double)this.overallCoverageThreshold);
        sw.println("Coverage: " + coveredNodes + " out of " + totalNumberOfNodes + " (" + String.format(Locale.ROOT, "%.1f", percentage) + "% / threshold " + this.overallCoverageThreshold + ".0%)");
        sw.println("Status: " + (overallCoverageAboveThreshold.get() ? "Success" : "Failed"));
        sw.println();
        return bos.toString();
    }

    private static List<RouteCoverageNode> gatherRouteCoverageSummary(List<CamelNodeDetails> route, List<CoverageData> coverageData) {
        ArrayList<RouteCoverageNode> answer = new ArrayList<RouteCoverageNode>();
        Iterator<CoverageData> it = coverageData.iterator();
        for (CamelNodeDetails r : route) {
            AtomicInteger level = new AtomicInteger();
            RouteCoverageMojo.gatherRouteCoverageSummary(r, it, level, answer);
        }
        return answer;
    }

    private static void gatherRouteCoverageSummary(CamelNodeDetails node, Iterator<CoverageData> it, AtomicInteger level, List<RouteCoverageNode> answer) {
        boolean skipData;
        boolean bl = skipData = "policy".equals(node.getName()) || "transacted".equals(node.getName());
        if (skipData) {
            for (CamelNodeDetails child : node.getOutputs()) {
                RouteCoverageMojo.gatherRouteCoverageSummary(child, it, level, answer);
            }
            return;
        }
        RouteCoverageNode data = new RouteCoverageNode();
        data.setName(node.getName());
        data.setLineNumber(Integer.parseInt(node.getLineNumber()));
        data.setLevel(level.get());
        data.setClassName(node.getClassName());
        data.setMethodName(node.getMethodName());
        answer.add(data);
        boolean found = false;
        while (!found && it.hasNext()) {
            CoverageData holder = it.next();
            found = holder.getNode().equals(node.getName());
            if (!found) continue;
            data.setCount(holder.getCount());
        }
        if (node.getOutputs() != null) {
            level.addAndGet(1);
            for (CamelNodeDetails child : node.getOutputs()) {
                RouteCoverageMojo.gatherRouteCoverageSummary(child, it, level, answer);
            }
            level.addAndGet(-1);
        }
    }

    private static String padString(int level) {
        if (level > 0) {
            return "  ".repeat(level);
        }
        return "";
    }

    private boolean matchFile(File file) {
        return CatalogHelper.matchRouteFile((File)file, (String)this.excludes, (String)this.includes, (MavenProject)this.project);
    }

    private void appendSourcefileNode(Document document, String sourceFileName, Element pack, List<RouteCoverageNode> coverage) {
        Element sourcefile = document.createElement("sourcefile");
        RouteCoverageMojo.createAttrString(document, sourcefile, "name", sourceFileName);
        pack.appendChild(sourcefile);
        int covered = 0;
        int missed = 0;
        for (RouteCoverageNode node : coverage) {
            int missedCount = 0;
            if (node.getCount() > 0) {
                ++covered;
            } else {
                ++missedCount;
                ++missed;
            }
            Element line = document.createElement("line");
            RouteCoverageMojo.createAttrInt(document, line, "nr", node.getLineNumber());
            RouteCoverageMojo.createAttrInt(document, line, "mi", missedCount);
            RouteCoverageMojo.createAttrInt(document, line, "ci", node.getCount());
            RouteCoverageMojo.createAttrInt(document, line, "mb", 0);
            RouteCoverageMojo.createAttrInt(document, line, "cb", 0);
            sourcefile.appendChild(line);
        }
        Element counter = document.createElement("counter");
        RouteCoverageMojo.createAttrString(document, counter, "type", "LINE");
        RouteCoverageMojo.createAttrInt(document, counter, "missed", missed);
        RouteCoverageMojo.createAttrInt(document, counter, "covered", covered);
        sourcefile.appendChild(counter);
    }

    private static Attr createAttrInt(Document doc, Element e, String name, Integer value) {
        Attr a = doc.createAttribute(name);
        a.setValue(value.toString());
        e.setAttributeNode(a);
        return a;
    }

    private static Attr createAttrString(Document doc, Element e, String name, String value) {
        Attr a = doc.createAttribute(name);
        a.setValue(value);
        e.setAttributeNode(a);
        return a;
    }

    private static Document createDocument() throws ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setValidating(false);
        dbf.setNamespaceAware(true);
        dbf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        dbf.setFeature("http://xml.org/sax/features/namespaces", false);
        dbf.setFeature("http://xml.org/sax/features/validation", false);
        dbf.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
        dbf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        dbf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        dbf.setFeature("http://xml.org/sax/features/external-general-entities", false);
        dbf.setXIncludeAware(false);
        dbf.setExpandEntityReferences(false);
        DocumentBuilder documentBuilder = dbf.newDocumentBuilder();
        return documentBuilder.newDocument();
    }

    private static void createJacocoXmlFile(Document document, File file) throws TransformerException {
        String xmlFilePath = file.toString() + "/xmlJacoco.xml";
        TransformerFactory factory = TransformerFactory.newInstance();
        factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        Transformer transformer = factory.newTransformer();
        DOMSource domSource = new DOMSource(document);
        StreamResult streamResult = new StreamResult(new File(xmlFilePath));
        transformer.transform(domSource, streamResult);
    }
}

