/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mock;

import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.spi.EndpointStrategy;
import org.apache.camel.spi.InterceptSendToEndpoint;
import org.apache.camel.support.DefaultInterceptSendToEndpoint;
import org.apache.camel.support.EndpointHelper;
import org.apache.camel.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InterceptSendToMockEndpointStrategy
implements EndpointStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(InterceptSendToMockEndpointStrategy.class);
    private final String pattern;
    private final boolean skip;

    public InterceptSendToMockEndpointStrategy() {
        this(null);
    }

    public InterceptSendToMockEndpointStrategy(String pattern) {
        this(pattern, false);
    }

    public InterceptSendToMockEndpointStrategy(String pattern, boolean skip) {
        this.pattern = pattern;
        this.skip = skip;
    }

    public Endpoint registerEndpoint(String uri, Endpoint endpoint) {
        if (endpoint instanceof InterceptSendToEndpoint) {
            return endpoint;
        }
        if (endpoint.getEndpointUri().startsWith("mock:")) {
            return endpoint;
        }
        if (this.matchPattern(uri, endpoint, this.pattern)) {
            DefaultInterceptSendToEndpoint proxy = new DefaultInterceptSendToEndpoint(endpoint, this.skip);
            try {
                Producer producer = this.createProducer(endpoint.getCamelContext(), uri, (Endpoint)proxy);
                producer = this.onInterceptEndpoint(uri, endpoint, producer.getEndpoint(), producer);
                proxy.setBefore((Processor)producer);
            }
            catch (Exception e) {
                throw new RuntimeCamelException((Throwable)e);
            }
            return proxy;
        }
        return endpoint;
    }

    protected Producer createProducer(CamelContext camelContext, String uri, Endpoint endpoint) throws Exception {
        Object key = "mock:" + endpoint.getEndpointKey().replaceFirst("://", ":");
        if (((String)key).contains("?")) {
            key = StringHelper.before((String)key, (String)"?");
        }
        LOG.info("Adviced endpoint [{}] with mock endpoint [{}]", (Object)uri, key);
        Endpoint mock = endpoint.getCamelContext().getEndpoint((String)key, Endpoint.class);
        return mock.createProducer();
    }

    protected boolean matchPattern(String uri, Endpoint endpoint, String pattern) {
        return uri == null || pattern == null || EndpointHelper.matchEndpoint((CamelContext)endpoint.getCamelContext(), (String)uri, (String)pattern);
    }

    protected Producer onInterceptEndpoint(String uri, Endpoint endpoint, Endpoint mockEndpoint, Producer mockProducer) {
        return mockProducer;
    }

    public String toString() {
        return "InterceptSendToMockEndpointStrategy";
    }
}

