/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.micrometer.prometheus;

import io.micrometer.core.instrument.binder.MeterBinder;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.camel.CamelContext;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.StringHelper;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BindersHelper {
    private static final Logger LOG = LoggerFactory.getLogger(BindersHelper.class);
    private static final String JANDEX_INDEX = "META-INF/micrometer-binder-index.dat";

    private BindersHelper() {
    }

    public static List<String> discoverBinders(ClassResolver classResolver, String names) throws IOException {
        ArrayList<String> answer = new ArrayList<String>();
        LOG.debug("Loading {}", (Object)JANDEX_INDEX);
        Index index = BindersHelper.readJandexIndex(classResolver);
        if (index == null) {
            LOG.warn("Cannot read {} with list of known MeterBinder classes", (Object)JANDEX_INDEX);
        } else {
            DotName dn = DotName.createSimple(MeterBinder.class);
            List classes = index.getKnownDirectImplementors(dn);
            LOG.debug("Found {} MeterBinder classes from {}", (Object)classes.size(), (Object)JANDEX_INDEX);
            for (String binder : names.split(",")) {
                binder = binder.trim();
                binder = StringHelper.dashToCamelCase((String)binder);
                String target = binder = binder.toLowerCase();
                Optional<ClassInfo> found = classes.stream().filter(c -> c.name().local().toLowerCase().equals(target) || c.name().local().toLowerCase().equals(target + "metrics")).findFirst();
                if (!found.isPresent()) continue;
                String fqn = found.get().name().toString();
                answer.add(fqn);
            }
        }
        return answer;
    }

    public static List<MeterBinder> loadBinders(CamelContext camelContext, List<String> binders) {
        ArrayList<MeterBinder> answer = new ArrayList<MeterBinder>();
        for (String fqn : binders) {
            LOG.debug("Creating MeterBinder: {}", (Object)fqn);
            try {
                Class clazz = camelContext.getClassResolver().resolveClass(fqn, MeterBinder.class);
                MeterBinder mb = (MeterBinder)camelContext.getInjector().newInstance(clazz);
                if (mb == null) continue;
                answer.add(mb);
            }
            catch (Exception e) {
                LOG.warn("Error creating MeterBinder: {} due to: {}. This exception is ignored.", new Object[]{fqn, e.getMessage(), e});
            }
        }
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Index readJandexIndex(ClassResolver classResolver) throws IOException {
        InputStream is = classResolver.loadResourceAsStream(JANDEX_INDEX);
        try {
            if (is != null) {
                IndexReader reader = new IndexReader(is);
                Index index = reader.read();
                return index;
            }
        }
        finally {
            IOHelper.close((Closeable)is);
        }
        return null;
    }
}

