/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hazelcast.ringbuffer;

import com.hazelcast.core.HazelcastInstance;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.hazelcast.HazelcastCommand;
import org.apache.camel.component.hazelcast.HazelcastConstants;
import org.apache.camel.component.hazelcast.HazelcastDefaultEndpoint;
import org.apache.camel.component.hazelcast.ringbuffer.HazelcastRingbufferProducer;
import org.apache.camel.spi.UriEndpoint;

@UriEndpoint(firstVersion="2.16.0", scheme="hazelcast-ringbuffer", title="Hazelcast Ringbuffer", syntax="hazelcast-ringbuffer:cacheName", producerOnly=true, category={Category.CACHE, Category.CLUSTERING}, headersClass=HazelcastConstants.class)
public class HazelcastRingbufferEndpoint
extends HazelcastDefaultEndpoint {
    public HazelcastRingbufferEndpoint(HazelcastInstance hazelcastInstance, String uri, Component component, String cacheName) {
        super(hazelcastInstance, uri, component, cacheName);
        this.setCommand(HazelcastCommand.ringbuffer);
    }

    @Override
    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("You cannot send messages to this endpoint: " + this.getEndpointUri());
    }

    @Override
    public Producer createProducer() throws Exception {
        return new HazelcastRingbufferProducer(this.hazelcastInstance, this, this.cacheName);
    }
}

