/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.remote;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Logger;
import com.jcraft.jsch.Proxy;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import com.jcraft.jsch.SocketFactory;
import com.jcraft.jsch.UIKeyboardInteractive;
import com.jcraft.jsch.UserInfo;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.KeyPair;
import java.time.Duration;
import java.util.Base64;
import java.util.Hashtable;
import java.util.Vector;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.LoggingLevel;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.file.GenericFileEndpoint;
import org.apache.camel.component.file.GenericFileExist;
import org.apache.camel.component.file.GenericFileOperationFailedException;
import org.apache.camel.component.file.GenericFileOperations;
import org.apache.camel.component.file.remote.RemoteFile;
import org.apache.camel.component.file.remote.RemoteFileConfiguration;
import org.apache.camel.component.file.remote.RemoteFileOperations;
import org.apache.camel.component.file.remote.SftpConfiguration;
import org.apache.camel.component.file.remote.SftpEndpoint;
import org.apache.camel.component.file.remote.SftpRemoteFile;
import org.apache.camel.component.file.remote.SftpRemoteFileJCraft;
import org.apache.camel.spi.CamelLogger;
import org.apache.camel.support.ResourceHelper;
import org.apache.camel.support.task.ForegroundTask;
import org.apache.camel.support.task.Tasks;
import org.apache.camel.support.task.budget.Budgets;
import org.apache.camel.support.task.budget.IterationBudget;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StopWatch;
import org.apache.camel.util.TimeUtils;
import org.slf4j.LoggerFactory;

public class SftpOperations
implements RemoteFileOperations<SftpRemoteFile> {
    private static final org.slf4j.Logger LOG = LoggerFactory.getLogger(SftpOperations.class);
    private static final Pattern UP_DIR_PATTERN = Pattern.compile("/[^/]+");
    private static final int OK_STATUS = 0;
    private static final String OK_MESSAGE = "OK";
    private Proxy proxy;
    private SftpEndpoint endpoint;
    private ChannelSftp channel;
    private Session session;
    private final Lock lock = new ReentrantLock();

    public SftpOperations() {
    }

    public SftpOperations(Proxy proxy) {
        this.proxy = proxy;
    }

    public void setEndpoint(GenericFileEndpoint<SftpRemoteFile> endpoint) {
        this.endpoint = (SftpEndpoint)endpoint;
    }

    public GenericFile<SftpRemoteFile> newGenericFile() {
        return new RemoteFile<SftpRemoteFile>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean connect(RemoteFileConfiguration configuration, Exchange exchange) throws GenericFileOperationFailedException {
        this.lock.lock();
        try {
            if (this.isConnected()) {
                boolean bl = true;
                return bl;
            }
            ForegroundTask task = Tasks.foregroundTask().withBudget((IterationBudget)Budgets.iterationBudget().withMaxIterations(Budgets.atLeastOnce((int)this.endpoint.getMaximumReconnectAttempts())).withInterval(Duration.ofMillis(this.endpoint.getReconnectDelay())).build()).build();
            TaskPayload payload = new TaskPayload(configuration);
            if (!task.run(this.endpoint.getCamelContext(), this::tryConnect, (Object)payload)) {
                throw new GenericFileOperationFailedException("Cannot connect to " + configuration.remoteServerInformation(), (Throwable)payload.exception);
            }
            this.configureBulkRequests();
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    private boolean tryConnect(TaskPayload payload) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Reconnect attempt to {}", (Object)payload.configuration.remoteServerInformation());
        }
        try {
            if (this.channel == null || !this.channel.isConnected()) {
                if (this.session == null || !this.session.isConnected()) {
                    LOG.trace("Session isn't connected, trying to recreate and connect.");
                    this.session = this.createSession(payload.configuration);
                    if (this.endpoint.getConfiguration().getConnectTimeout() > 0) {
                        LOG.trace("Connecting use connectTimeout: {} ...", (Object)this.endpoint.getConfiguration().getConnectTimeout());
                        this.session.connect(this.endpoint.getConfiguration().getConnectTimeout());
                    } else {
                        LOG.trace("Connecting ...");
                        this.session.connect();
                    }
                }
                LOG.trace("Channel isn't connected, trying to recreate and connect.");
                this.channel = (ChannelSftp)this.session.openChannel("sftp");
                if (this.endpoint.getConfiguration().getFilenameEncoding() != null) {
                    Charset ch = Charset.forName(this.endpoint.getConfiguration().getFilenameEncoding());
                    LOG.trace("Using filename encoding: {}", (Object)ch);
                    this.channel.setFilenameEncoding(ch);
                }
                if (this.endpoint.getConfiguration().getConnectTimeout() > 0) {
                    LOG.trace("Connecting use connectTimeout: {} ...", (Object)this.endpoint.getConfiguration().getConnectTimeout());
                    this.channel.connect(this.endpoint.getConfiguration().getConnectTimeout());
                } else {
                    LOG.trace("Connecting ...");
                    this.channel.connect();
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Connected to {}", (Object)payload.configuration.remoteServerInformation());
                }
            }
        }
        catch (JSchException e) {
            payload.exception = e;
            return false;
        }
        return true;
    }

    private void configureBulkRequests() {
        try {
            this.tryConfigureBulkRequests();
        }
        catch (JSchException e) {
            throw new GenericFileOperationFailedException("Failed to configure number of bulk requests", (Throwable)e);
        }
    }

    private void tryConfigureBulkRequests() throws JSchException {
        Integer bulkRequests = this.endpoint.getConfiguration().getBulkRequests();
        if (bulkRequests != null) {
            LOG.trace("configuring channel to use up to {} bulk request(s)", (Object)bulkRequests);
            this.channel.setBulkRequests(bulkRequests.intValue());
        }
    }

    protected Session createSession(final RemoteFileConfiguration configuration) throws JSchException {
        Object knownHostsFile;
        byte[] passphrase;
        JSch jsch = new JSch();
        JSch.setLogger((Logger)new JSchLogger(this.endpoint.getConfiguration().getJschLoggingLevel()));
        final SftpConfiguration sftpConfig = (SftpConfiguration)configuration;
        if (ObjectHelper.isNotEmpty((String)sftpConfig.getCiphers())) {
            LOG.debug("Using ciphers: {}", (Object)sftpConfig.getCiphers());
            Hashtable<String, String> ciphers = new Hashtable<String, String>();
            ciphers.put("cipher.s2c", sftpConfig.getCiphers());
            ciphers.put("cipher.c2s", sftpConfig.getCiphers());
            JSch.setConfig(ciphers);
        }
        if (ObjectHelper.isNotEmpty((String)sftpConfig.getKeyExchangeProtocols())) {
            LOG.debug("Using KEX: {}", (Object)sftpConfig.getKeyExchangeProtocols());
            JSch.setConfig((String)"kex", (String)sftpConfig.getKeyExchangeProtocols());
        }
        if (ObjectHelper.isNotEmpty((String)sftpConfig.getPrivateKeyFile())) {
            LOG.debug("Using private keyfile: {}", (Object)sftpConfig.getPrivateKeyFile());
            if (ObjectHelper.isNotEmpty((String)sftpConfig.getPrivateKeyPassphrase())) {
                jsch.addIdentity(sftpConfig.getPrivateKeyFile(), sftpConfig.getPrivateKeyPassphrase());
            } else {
                jsch.addIdentity(sftpConfig.getPrivateKeyFile());
            }
        }
        if (sftpConfig.getPrivateKey() != null) {
            LOG.debug("Using private key information from byte array");
            passphrase = null;
            if (ObjectHelper.isNotEmpty((String)sftpConfig.getPrivateKeyPassphrase())) {
                passphrase = sftpConfig.getPrivateKeyPassphrase().getBytes(StandardCharsets.UTF_8);
            }
            jsch.addIdentity("ID", sftpConfig.getPrivateKey(), null, passphrase);
        }
        if (sftpConfig.getPrivateKeyUri() != null) {
            LOG.debug("Using private key uri : {}", (Object)sftpConfig.getPrivateKeyUri());
            passphrase = null;
            if (ObjectHelper.isNotEmpty((String)sftpConfig.getPrivateKeyPassphrase())) {
                passphrase = sftpConfig.getPrivateKeyPassphrase().getBytes(StandardCharsets.UTF_8);
            }
            try {
                InputStream is = ResourceHelper.resolveMandatoryResourceAsInputStream((CamelContext)this.endpoint.getCamelContext(), (String)sftpConfig.getPrivateKeyUri());
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                IOHelper.copyAndCloseInput((InputStream)is, (OutputStream)bos);
                jsch.addIdentity("ID", bos.toByteArray(), null, passphrase);
            }
            catch (IOException e) {
                throw new JSchException("Cannot read resource: " + sftpConfig.getPrivateKeyUri(), (Throwable)e);
            }
        }
        if (sftpConfig.getKeyPair() != null) {
            LOG.debug("Using private key information from key pair");
            KeyPair keyPair = sftpConfig.getKeyPair();
            if (keyPair.getPrivate() != null) {
                StringBuilder sb = new StringBuilder(256);
                sb.append("-----BEGIN PRIVATE KEY-----").append("\n");
                sb.append(Base64.getEncoder().encodeToString(keyPair.getPrivate().getEncoded())).append("\n");
                sb.append("-----END PRIVATE KEY-----").append("\n");
                jsch.addIdentity("ID", sb.toString().getBytes(StandardCharsets.UTF_8), null, null);
            } else {
                LOG.warn("PrivateKey in the KeyPair must be filled");
            }
        }
        if (ObjectHelper.isNotEmpty((String)sftpConfig.getKnownHostsFile())) {
            LOG.debug("Using knownhosts file: {}", (Object)sftpConfig.getKnownHostsFile());
            jsch.setKnownHosts(sftpConfig.getKnownHostsFile());
        }
        if (ObjectHelper.isNotEmpty((String)sftpConfig.getKnownHostsUri())) {
            LOG.debug("Using known hosts uri: {}", (Object)sftpConfig.getKnownHostsUri());
            try {
                InputStream is = ResourceHelper.resolveMandatoryResourceAsInputStream((CamelContext)this.endpoint.getCamelContext(), (String)sftpConfig.getKnownHostsUri());
                jsch.setKnownHosts(is);
            }
            catch (IOException e) {
                throw new JSchException("Cannot read resource: " + sftpConfig.getKnownHostsUri(), (Throwable)e);
            }
        }
        if (sftpConfig.getKnownHosts() != null) {
            LOG.debug("Using known hosts information from byte array");
            jsch.setKnownHosts((InputStream)new ByteArrayInputStream(sftpConfig.getKnownHosts()));
        }
        if ((knownHostsFile = sftpConfig.getKnownHostsFile()) == null && sftpConfig.isUseUserKnownHostsFile()) {
            knownHostsFile = System.getProperty("user.home") + "/.ssh/known_hosts";
            LOG.info("Known host file not configured, using user known host file: {}", knownHostsFile);
        }
        if (ObjectHelper.isNotEmpty((String)knownHostsFile)) {
            LOG.debug("Using known hosts information from file: {}", knownHostsFile);
            jsch.setKnownHosts((String)knownHostsFile);
        }
        final Session session = jsch.getSession(configuration.getUsername(), configuration.getHost(), configuration.getPort());
        if (ObjectHelper.isNotEmpty((String)sftpConfig.getStrictHostKeyChecking())) {
            LOG.debug("Using StrictHostKeyChecking: {}", (Object)sftpConfig.getStrictHostKeyChecking());
            session.setConfig("StrictHostKeyChecking", sftpConfig.getStrictHostKeyChecking());
        }
        session.setServerAliveInterval(sftpConfig.getServerAliveInterval());
        session.setServerAliveCountMax(sftpConfig.getServerAliveCountMax());
        if (sftpConfig.getCompression() > 0) {
            LOG.debug("Using compression: {}", (Object)sftpConfig.getCompression());
            session.setConfig("compression.s2c", "zlib@openssh.com,zlib,none");
            session.setConfig("compression.c2s", "zlib@openssh.com,zlib,none");
            session.setConfig("compression_level", Integer.toString(sftpConfig.getCompression()));
        }
        if (sftpConfig.getPreferredAuthentications() != null) {
            LOG.debug("Using PreferredAuthentications: {}", (Object)sftpConfig.getPreferredAuthentications());
            session.setConfig("PreferredAuthentications", sftpConfig.getPreferredAuthentications());
        }
        if (sftpConfig.getServerHostKeys() != null) {
            LOG.debug("Using ServerHostKeys: {}", (Object)sftpConfig.getServerHostKeys());
            session.setConfig("server_host_key", sftpConfig.getServerHostKeys());
        }
        if (sftpConfig.getPublicKeyAcceptedAlgorithms() != null) {
            LOG.debug("Using PublicKeyAcceptedAlgorithms: {}", (Object)sftpConfig.getPublicKeyAcceptedAlgorithms());
            session.setConfig("PubkeyAcceptedAlgorithms", sftpConfig.getPublicKeyAcceptedAlgorithms());
        }
        session.setUserInfo((UserInfo)new ExtendedUserInfo(){
            private final CamelLogger messageLogger;
            {
                this.messageLogger = new CamelLogger(LOG, ((SftpConfiguration)configuration).getServerMessageLoggingLevel());
            }

            public String getPassphrase() {
                return null;
            }

            public String getPassword() {
                return configuration.getPassword();
            }

            public boolean promptPassword(String s) {
                return true;
            }

            public boolean promptPassphrase(String s) {
                return true;
            }

            public boolean promptYesNo(String s) {
                boolean knownHostFile;
                boolean bl = knownHostFile = s != null && s.endsWith("Are you sure you want to create it?");
                if (knownHostFile && ((SftpConfiguration)configuration).isAutoCreateKnownHostsFile()) {
                    LOG.warn("Server asks for confirmation (yes|no): {}. Camel will answer yes.", (Object)s);
                    return true;
                }
                LOG.warn("Server asks for confirmation (yes|no): {}. Camel will answer no.", (Object)s);
                return false;
            }

            public void showMessage(String s) {
                this.messageLogger.log("FTP Server: " + s);
            }

            public String[] promptKeyboardInteractive(String destination, String name, String instruction, String[] prompt, boolean[] echo) {
                if (configuration.getPassword() == null) {
                    return new String[0];
                }
                return new String[]{configuration.getPassword()};
            }
        });
        if (sftpConfig.getServerAliveInterval() == 0) {
            if (configuration.getSoTimeout() > 0) {
                session.setTimeout(configuration.getSoTimeout());
            }
        } else {
            LOG.debug("The Server Alive Internal is already set, the socket timeout won't be considered to avoid overidding the provided Server alive interval value");
        }
        if (this.proxy != null) {
            session.setProxy(this.proxy);
        }
        if (ObjectHelper.isNotEmpty((String)sftpConfig.getBindAddress())) {
            session.setSocketFactory(new SocketFactory(){

                public OutputStream getOutputStream(Socket socket) throws IOException {
                    return socket.getOutputStream();
                }

                public InputStream getInputStream(Socket socket) throws IOException {
                    return socket.getInputStream();
                }

                public Socket createSocket(String host, int port) throws IOException {
                    return SftpOperations.createSocketUtil(host, port, sftpConfig.getBindAddress(), session.getTimeout());
                }
            });
        }
        return session;
    }

    @Override
    public boolean isConnected() throws GenericFileOperationFailedException {
        this.lock.lock();
        try {
            boolean bl = this.session != null && this.session.isConnected() && this.channel != null && this.channel.isConnected();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void disconnect() throws GenericFileOperationFailedException {
        this.lock.lock();
        try {
            if (this.session != null && this.session.isConnected()) {
                this.session.disconnect();
            }
            if (this.channel != null && this.channel.isConnected()) {
                this.channel.disconnect();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void forceDisconnect() throws GenericFileOperationFailedException {
        this.lock.lock();
        try {
            if (this.session != null) {
                this.session.disconnect();
            }
            if (this.channel != null) {
                this.channel.disconnect();
            }
        }
        finally {
            this.session = null;
            this.channel = null;
            this.lock.unlock();
        }
    }

    private void reconnectIfNecessary(Exchange exchange) {
        if (!this.isConnected()) {
            this.connect(this.endpoint.getConfiguration(), exchange);
        }
    }

    public boolean deleteFile(String name) throws GenericFileOperationFailedException {
        this.lock.lock();
        try {
            LOG.debug("Deleting file: {}", (Object)name);
            this.reconnectIfNecessary(null);
            this.channel.rm(name);
            boolean bl = true;
            return bl;
        }
        catch (SftpException e) {
            LOG.debug("Cannot delete file {}: {}", new Object[]{name, e.getMessage(), e});
            throw new GenericFileOperationFailedException("Cannot delete file: " + name, (Throwable)e);
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean renameFile(String from, String to) throws GenericFileOperationFailedException {
        this.lock.lock();
        try {
            LOG.debug("Renaming file: {} to: {}", (Object)from, (Object)to);
            this.reconnectIfNecessary(null);
            to = FileUtil.compactPath((String)to, (char)'/');
            this.channel.rename(from, to);
            boolean bl = true;
            return bl;
        }
        catch (SftpException e) {
            LOG.debug("Cannot rename file from: {} to: {}", new Object[]{from, to, e});
            throw new GenericFileOperationFailedException("Cannot rename file from: " + from + " to: " + to, (Throwable)e);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean buildDirectory(String directory, boolean absolute) throws GenericFileOperationFailedException {
        this.lock.lock();
        try {
            directory = this.endpoint.getConfiguration().normalizePath(directory);
            LOG.trace("buildDirectory({},{})", (Object)directory, (Object)absolute);
            boolean success = false;
            boolean cdCheck = !this.endpoint.getConfiguration().isExistDirCheckUsingLs();
            String originalDirectory = cdCheck ? this.getCurrentDirectory() : null;
            try {
                try {
                    if (cdCheck) {
                        this.channel.cd(directory);
                    } else {
                        this.channel.ls(directory, entry -> 1);
                    }
                    success = true;
                }
                catch (SftpException sftpException) {
                    // empty catch block
                }
                if (!success) {
                    LOG.debug("Trying to build remote directory: {}", (Object)directory);
                    try {
                        this.channel.mkdir(directory);
                        success = true;
                    }
                    catch (SftpException e) {
                        success = this.buildDirectoryChunks(directory);
                    }
                    if (success) {
                        this.chmodOfDirectory(directory);
                    }
                }
                if (originalDirectory != null) {
                    this.changeCurrentDirectory(originalDirectory);
                }
            }
            catch (SftpException e) {
                throw new GenericFileOperationFailedException("Cannot build directory: " + directory, (Throwable)e);
            }
            boolean bl = success;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    private boolean buildDirectoryChunks(String dirName) throws SftpException {
        StringBuilder sb = new StringBuilder(dirName.length());
        String[] dirs = dirName.split("/|\\\\");
        boolean success = false;
        boolean first = true;
        for (String dir : dirs) {
            if (first) {
                first = false;
            } else {
                sb.append('/');
            }
            sb.append(dir);
            String directory = this.endpoint.getConfiguration().normalizePath(sb.toString());
            if (directory.equals("/") || directory.equals("\\")) continue;
            try {
                LOG.trace("Trying to build remote directory by chunk: {}", (Object)directory);
                this.channel.mkdir(directory);
                success = true;
            }
            catch (SftpException sftpException) {
                // empty catch block
            }
            if (!success) continue;
            this.chmodOfDirectory(directory);
        }
        return success;
    }

    public String getCurrentDirectory() throws GenericFileOperationFailedException {
        this.lock.lock();
        try {
            LOG.trace("getCurrentDirectory()");
            String answer = this.channel.pwd();
            LOG.trace("Current dir: {}", (Object)answer);
            String string = answer;
            return string;
        }
        catch (SftpException e) {
            throw new GenericFileOperationFailedException("Cannot get current directory", (Throwable)e);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeCurrentDirectory(String path) throws GenericFileOperationFailedException {
        this.lock.lock();
        try {
            String[] dirs;
            LOG.trace("changeCurrentDirectory({})", (Object)path);
            if (ObjectHelper.isEmpty((String)path)) {
                return;
            }
            String before = path;
            char separatorChar = '/';
            path = FileUtil.compactPath((String)path, (char)separatorChar);
            if (LOG.isTraceEnabled()) {
                LOG.trace("Compacted path: {} -> {} using separator: {}", new Object[]{before, path, Character.valueOf(separatorChar)});
            }
            if (!this.endpoint.getConfiguration().isStepwise()) {
                this.doChangeDirectory(path);
                return;
            }
            if (this.getCurrentDirectory().startsWith(path)) {
                String p = this.getCurrentDirectory().substring(path.length() - (path.endsWith("/") ? 1 : 0));
                if (p.isEmpty()) {
                    return;
                }
                path = UP_DIR_PATTERN.matcher(p).replaceAll("/..").substring(1);
            }
            if (FileUtil.hasLeadingSeparator((String)path)) {
                if (!path.matches("^[a-zA-Z]:(//|\\\\).*$")) {
                    this.doChangeDirectory(path.substring(0, 1));
                    path = path.substring(1);
                } else if (path.matches("^[a-zA-Z]:(//).*$")) {
                    this.doChangeDirectory(path.substring(0, 3));
                    path = path.substring(3);
                } else if (path.matches("^[a-zA-Z]:(\\\\).*$")) {
                    this.doChangeDirectory(path.substring(0, 4));
                    path = path.substring(4);
                }
            }
            if ((dirs = path.split("/|\\\\")) == null || dirs.length == 0) {
                this.doChangeDirectory(path);
                return;
            }
            for (String dir : dirs) {
                this.doChangeDirectory(dir);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void doChangeDirectory(String path) {
        if (path == null || ".".equals(path) || ObjectHelper.isEmpty((String)path)) {
            return;
        }
        LOG.trace("Changing directory: {}", (Object)path);
        try {
            this.channel.cd(path);
        }
        catch (SftpException e) {
            throw new GenericFileOperationFailedException("Cannot change directory to: " + path, (Throwable)e);
        }
    }

    public void changeToParentDirectory() throws GenericFileOperationFailedException {
        this.lock.lock();
        try {
            LOG.trace("changeToParentDirectory()");
            String current = this.getCurrentDirectory();
            Object parent = FileUtil.compactPath((String)(current + "/.."));
            if (!((String)parent).startsWith("/")) {
                parent = "/" + (String)parent;
            }
            this.changeCurrentDirectory((String)parent);
        }
        finally {
            this.lock.unlock();
        }
    }

    public SftpRemoteFile[] listFiles() throws GenericFileOperationFailedException {
        this.lock.lock();
        try {
            SftpRemoteFile[] sftpRemoteFileArray = this.listFiles(".");
            return sftpRemoteFileArray;
        }
        finally {
            this.lock.unlock();
        }
    }

    public SftpRemoteFile[] listFiles(String path) throws GenericFileOperationFailedException {
        this.lock.lock();
        try {
            LOG.trace("Listing remote files from path {}", (Object)path);
            if (ObjectHelper.isEmpty((String)path)) {
                path = ".";
            }
            Vector files = this.channel.ls(path);
            SftpRemoteFile[] sftpRemoteFileArray = (SftpRemoteFile[])files.stream().map(f -> new SftpRemoteFileJCraft((ChannelSftp.LsEntry)f)).toArray(SftpRemoteFileJCraft[]::new);
            return sftpRemoteFileArray;
        }
        catch (SftpException e) {
            throw new GenericFileOperationFailedException("Cannot list directory: " + path, (Throwable)e);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retrieveFile(String name, Exchange exchange, long size) throws GenericFileOperationFailedException {
        this.lock.lock();
        try {
            LOG.trace("retrieveFile({})", (Object)name);
            if (ObjectHelper.isNotEmpty((String)this.endpoint.getLocalWorkDirectory())) {
                boolean bl = this.retrieveFileToFileInLocalWorkDirectory(name, exchange);
                return bl;
            }
            boolean bl = this.retrieveFileToStreamInBody(name, exchange);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseRetrievedFileResources(Exchange exchange) throws GenericFileOperationFailedException {
        block5: {
            this.lock.lock();
            try {
                InputStream is = (InputStream)exchange.getIn().getHeader("CamelRemoteFileInputStream", InputStream.class);
                if (is == null) break block5;
                try {
                    is.close();
                }
                catch (IOException e) {
                    throw new GenericFileOperationFailedException(e.getMessage(), (Throwable)e);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    private boolean retrieveFileToStreamInBody(String name, Exchange exchange) throws GenericFileOperationFailedException {
        try {
            String currentDir = null;
            GenericFile target = (GenericFile)exchange.getProperty("CamelFileExchangeFile");
            ObjectHelper.notNull((Object)target, (String)"Exchange should have the CamelFileExchangeFile set");
            String remoteName = name;
            if (this.endpoint.getConfiguration().isStepwise()) {
                currentDir = this.getCurrentDirectory();
                String path = FileUtil.onlyPath((String)name);
                if (path != null) {
                    this.changeCurrentDirectory(path);
                }
                remoteName = FileUtil.stripPath((String)name);
            }
            InputStream is = this.channel.get(remoteName);
            if (this.endpoint.getConfiguration().isStreamDownload()) {
                target.setBody((Object)is);
                exchange.getIn().setHeader("CamelRemoteFileInputStream", (Object)is);
            } else {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                IOHelper.copyAndCloseInput((InputStream)is, (OutputStream)bos);
                IOHelper.close((Closeable)bos);
                target.setBody((Object)bos.toByteArray());
            }
            this.createResultHeadersFromExchange(null, exchange);
            if (currentDir != null) {
                this.changeCurrentDirectory(currentDir);
            }
            return true;
        }
        catch (SftpException e) {
            this.createResultHeadersFromExchange(e, exchange);
            throw new GenericFileOperationFailedException("Cannot retrieve file: " + name, (Throwable)e);
        }
        catch (IOException e) {
            throw new GenericFileOperationFailedException("Cannot retrieve file: " + name, (Throwable)e);
        }
    }

    private boolean retrieveFileToFileInLocalWorkDirectory(String name, Exchange exchange) throws GenericFileOperationFailedException {
        FileOutputStream os;
        File temp;
        File local = new File(this.endpoint.getLocalWorkDirectory());
        GenericFile file = (GenericFile)exchange.getProperty("CamelFileExchangeFile");
        ObjectHelper.notNull((Object)file, (String)"Exchange should have the CamelFileExchangeFile set");
        try {
            String relativeName = file.getRelativeFilePath();
            temp = new File(local, relativeName + ".inprogress");
            local = new File(local, relativeName);
            local.mkdirs();
            if (temp.exists() && !FileUtil.deleteFile((File)temp)) {
                throw new GenericFileOperationFailedException("Cannot delete existing local work file: " + temp);
            }
            if (local.exists() && !FileUtil.deleteFile((File)local)) {
                throw new GenericFileOperationFailedException("Cannot delete existing local work file: " + local);
            }
            if (!temp.createNewFile()) {
                throw new GenericFileOperationFailedException("Cannot create new local work file: " + temp);
            }
            os = new FileOutputStream(temp);
            exchange.getIn().setHeader("CamelFileLocalWorkPath", (Object)local.getPath());
        }
        catch (Exception e) {
            throw new GenericFileOperationFailedException("Cannot create new local work file: " + local, (Throwable)e);
        }
        try {
            String currentDir = null;
            file.setBody((Object)local);
            String remoteName = name;
            if (this.endpoint.getConfiguration().isStepwise()) {
                currentDir = this.getCurrentDirectory();
                String path = FileUtil.onlyPath((String)name);
                if (path != null) {
                    this.changeCurrentDirectory(path);
                }
                remoteName = FileUtil.stripPath((String)name);
            }
            this.channel.get(remoteName, (OutputStream)os);
            if (currentDir != null) {
                this.changeCurrentDirectory(currentDir);
            }
        }
        catch (SftpException e) {
            this.createResultHeadersFromExchange(e, exchange);
            LOG.trace("Error occurred during retrieving file: {} to local directory. Deleting local work file: {}", (Object)name, (Object)temp);
            IOHelper.close((Closeable)os, (String)("retrieve: " + name), (org.slf4j.Logger)LOG);
            boolean deleted = FileUtil.deleteFile((File)temp);
            if (!deleted) {
                LOG.warn("Error occurred during retrieving file: {} to local directory. Cannot delete local work file: {}", (Object)name, (Object)temp);
            }
            throw new GenericFileOperationFailedException("Cannot retrieve file: " + name, (Throwable)e);
        }
        finally {
            IOHelper.close((Closeable)os, (String)("retrieve: " + name), (org.slf4j.Logger)LOG);
        }
        this.createResultHeadersFromExchange(null, exchange);
        LOG.debug("Retrieve file to local work file result: true");
        LOG.trace("Renaming local in progress file from: {} to: {}", (Object)temp, (Object)local);
        try {
            if (!FileUtil.renameFile((File)temp, (File)local, (boolean)false)) {
                throw new GenericFileOperationFailedException("Cannot rename local work file from: " + temp + " to: " + local);
            }
        }
        catch (IOException e) {
            throw new GenericFileOperationFailedException("Cannot rename local work file from: " + temp + " to: " + local, (Throwable)e);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean storeFile(String name, Exchange exchange, long size) throws GenericFileOperationFailedException {
        this.lock.lock();
        try {
            name = this.endpoint.getConfiguration().normalizePath(name);
            LOG.trace("storeFile({})", (Object)name);
            String currentDir = null;
            String path = FileUtil.onlyPath((String)name);
            String targetName = name;
            if (path != null && this.endpoint.getConfiguration().isStepwise()) {
                currentDir = this.getCurrentDirectory();
                this.changeCurrentDirectory(path);
                targetName = FileUtil.stripPath((String)name);
            }
            boolean answer = this.doStoreFile(name, targetName, exchange);
            if (currentDir != null) {
                this.changeCurrentDirectory(currentDir);
            }
            boolean bl = answer;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean doStoreFile(String name, String targetName, Exchange exchange) throws GenericFileOperationFailedException {
        boolean bl;
        LOG.trace("doStoreFile({})", (Object)targetName);
        if (this.endpoint.getFileExist() == GenericFileExist.Ignore || this.endpoint.getFileExist() == GenericFileExist.Fail || this.endpoint.getFileExist() == GenericFileExist.Move) {
            boolean existFile = this.existsFile(targetName);
            if (existFile && this.endpoint.getFileExist() == GenericFileExist.Ignore) {
                LOG.trace("An existing file already exists: {}. Ignore and do not override it.", (Object)name);
                return true;
            }
            if (existFile && this.endpoint.getFileExist() == GenericFileExist.Fail) {
                throw new GenericFileOperationFailedException("File already exist: " + name + ". Cannot write new file.");
            }
            if (existFile && this.endpoint.getFileExist() == GenericFileExist.Move) {
                this.endpoint.getMoveExistingFileStrategy().moveExistingFile((GenericFileEndpoint)this.endpoint, (GenericFileOperations)this, targetName);
            }
        }
        InputStream is = null;
        if (exchange.getIn().getBody() == null) {
            if (!this.endpoint.isAllowNullBody()) {
                throw new GenericFileOperationFailedException("Cannot write null body to file: " + name);
            }
            LOG.trace("Writing empty file.");
            is = new ByteArrayInputStream(new byte[0]);
        }
        try {
            String mode;
            if (is == null) {
                String charset = this.endpoint.getCharset();
                if (charset != null) {
                    is = new ByteArrayInputStream(((String)exchange.getIn().getMandatoryBody(String.class)).getBytes(charset));
                    LOG.trace("Using InputStream {} with charset {}.", (Object)is, (Object)charset);
                } else {
                    is = (InputStream)exchange.getIn().getMandatoryBody(InputStream.class);
                }
            }
            StopWatch watch = new StopWatch();
            LOG.debug("About to store file: {} using stream: {}", (Object)targetName, is);
            if (this.endpoint.getFileExist() == GenericFileExist.Append) {
                LOG.trace("Client appendFile: {}", (Object)targetName);
                this.channel.put(is, targetName, 2);
            } else {
                LOG.trace("Client storeFile: {}", (Object)targetName);
                this.channel.put(is, targetName);
            }
            if (LOG.isDebugEnabled()) {
                long time = watch.taken();
                LOG.debug("Took {} ({} millis) to store file: {} and FTP client returned: true", new Object[]{TimeUtils.printDuration((long)time, (boolean)true), time, targetName});
            }
            if (ObjectHelper.isNotEmpty((String)(mode = this.endpoint.getConfiguration().getChmod()))) {
                int permissions = Integer.parseInt(mode, 8);
                LOG.trace("Setting chmod: {} on file: {}", (Object)mode, (Object)targetName);
                this.channel.chmod(permissions, targetName);
            }
            this.createResultHeadersFromExchange(null, exchange);
            bl = true;
        }
        catch (SftpException e) {
            try {
                this.createResultHeadersFromExchange(e, exchange);
                throw new GenericFileOperationFailedException("Cannot store file: " + name, (Throwable)e);
                catch (UnsupportedEncodingException | InvalidPayloadException e2) {
                    throw new GenericFileOperationFailedException("Cannot store file: " + name, e2);
                }
            }
            catch (Throwable throwable) {
                IOHelper.close(is, (String)("store: " + name), (org.slf4j.Logger)LOG);
                throw throwable;
            }
        }
        IOHelper.close((Closeable)is, (String)("store: " + name), (org.slf4j.Logger)LOG);
        return bl;
    }

    public boolean existsFile(String name) throws GenericFileOperationFailedException {
        this.lock.lock();
        try {
            Vector files;
            LOG.trace("existsFile({})", (Object)name);
            if (this.endpoint.isFastExistsCheck()) {
                boolean bl = this.fastExistsFile(name);
                return bl;
            }
            String directory = FileUtil.onlyPath((String)name);
            if (directory == null) {
                directory = ".";
            }
            String onlyName = FileUtil.stripPath((String)name);
            try {
                files = this.channel.ls(directory);
                if (files == null) {
                    boolean bl = false;
                    return bl;
                }
            }
            catch (SftpException e) {
                if (2 == e.id) {
                    boolean bl = false;
                    return bl;
                }
                throw new GenericFileOperationFailedException(e.getMessage(), (Throwable)e);
            }
            for (Object file : files) {
                ChannelSftp.LsEntry entry = (ChannelSftp.LsEntry)file;
                String existing = entry.getFilename();
                LOG.trace("Existing file: {}, target file: {}", (Object)existing, (Object)name);
                existing = FileUtil.stripPath((String)existing);
                if (existing == null || !existing.equals(onlyName)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected boolean fastExistsFile(String name) throws GenericFileOperationFailedException {
        LOG.trace("fastExistsFile({})", (Object)name);
        try {
            Vector files = this.channel.ls(name);
            if (files == null) {
                return false;
            }
            return !files.isEmpty();
        }
        catch (SftpException e) {
            if (2 == e.id) {
                return false;
            }
            throw new GenericFileOperationFailedException(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public boolean sendNoop() throws GenericFileOperationFailedException {
        this.lock.lock();
        try {
            if (this.isConnected()) {
                try {
                    this.session.sendKeepAliveMsg();
                    boolean bl = true;
                    return bl;
                }
                catch (Exception e) {
                    LOG.debug("SFTP session was closed. Ignoring this exception.", (Throwable)e);
                    boolean bl = false;
                    this.lock.unlock();
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean sendSiteCommand(String command) throws GenericFileOperationFailedException {
        return true;
    }

    static Socket createSocketUtil(String host, int port, String bindAddress, int timeout) {
        if (timeout == 0) {
            try {
                Socket socket = new Socket(InetAddress.getByName(host), port, InetAddress.getByName(bindAddress), 0);
                return socket;
            }
            catch (Exception e) {
                String message = e.toString();
                throw new RuntimeCamelException(message, (Throwable)e);
            }
        }
        Socket[] sockp = new Socket[1];
        Exception[] ee = new Exception[1];
        Object message = "";
        Thread tmp = new Thread(() -> {
            sockp[0] = null;
            try {
                sockp[0] = new Socket(InetAddress.getByName(host), port, InetAddress.getByName(bindAddress), 0);
            }
            catch (Exception e) {
                ee[0] = e;
                if (sockp[0] != null && sockp[0].isConnected()) {
                    IOHelper.close((Closeable)sockp[0]);
                }
                sockp[0] = null;
            }
        });
        tmp.setName("Opening Socket " + host);
        tmp.start();
        try {
            tmp.join(timeout);
            message = "timeout: ";
        }
        catch (InterruptedException eee) {
            Thread.currentThread().interrupt();
        }
        if (sockp[0] == null || !sockp[0].isConnected()) {
            message = (String)message + "socket is not established";
            if (ee[0] != null) {
                message = ee[0].toString();
            }
            tmp.interrupt();
            throw new RuntimeCamelException((String)message, (Throwable)ee[0]);
        }
        Socket socket = sockp[0];
        return socket;
    }

    private void createResultHeadersFromExchange(SftpException sftpException, Exchange exchange) {
        if (sftpException == null) {
            exchange.getIn().setHeader("CamelFtpReplyCode", (Object)0);
            exchange.getIn().setHeader("CamelFtpReplyString", (Object)OK_MESSAGE);
        } else {
            exchange.getIn().setHeader("CamelFtpReplyCode", (Object)sftpException.id);
            exchange.getIn().setHeader("CamelFtpReplyString", (Object)sftpException.getMessage());
        }
    }

    private void chmodOfDirectory(String directory) {
        String chmodDirectory = this.endpoint.getConfiguration().getChmodDirectory();
        if (ObjectHelper.isNotEmpty((String)chmodDirectory)) {
            LOG.trace("Setting permission: {} on directory: {}", (Object)chmodDirectory, (Object)directory);
            int permissions = Integer.parseInt(chmodDirectory, 8);
            try {
                this.channel.chmod(permissions, directory);
            }
            catch (SftpException e) {
                throw new GenericFileOperationFailedException("Cannot set permission on directory: " + directory, (Throwable)e);
            }
        }
    }

    private static class TaskPayload {
        final RemoteFileConfiguration configuration;
        private Exception exception;

        public TaskPayload(RemoteFileConfiguration configuration) {
            this.configuration = configuration;
        }
    }

    private static final class JSchLogger
    implements Logger {
        private final LoggingLevel loggingLevel;

        private JSchLogger(LoggingLevel loggingLevel) {
            this.loggingLevel = loggingLevel;
        }

        public boolean isEnabled(int level) {
            switch (level) {
                case 4: {
                    return this.loggingLevel.isEnabled(LoggingLevel.ERROR) && LOG.isErrorEnabled();
                }
                case 3: {
                    return this.loggingLevel.isEnabled(LoggingLevel.ERROR) && LOG.isErrorEnabled();
                }
                case 2: {
                    return this.loggingLevel.isEnabled(LoggingLevel.WARN) && LOG.isWarnEnabled();
                }
                case 1: {
                    return this.loggingLevel.isEnabled(LoggingLevel.INFO) && LOG.isInfoEnabled();
                }
            }
            return this.loggingLevel.isEnabled(LoggingLevel.DEBUG) && LOG.isDebugEnabled();
        }

        public void log(int level, String message) {
            switch (level) {
                case 4: {
                    LOG.error("JSCH -> {}", (Object)message);
                    break;
                }
                case 3: {
                    LOG.error("JSCH -> {}", (Object)message);
                    break;
                }
                case 2: {
                    LOG.warn("JSCH -> {}", (Object)message);
                    break;
                }
                case 1: {
                    LOG.info("JSCH -> {}", (Object)message);
                    break;
                }
                default: {
                    LOG.debug("JSCH -> {}", (Object)message);
                }
            }
        }
    }

    public static interface ExtendedUserInfo
    extends UserInfo,
    UIKeyboardInteractive {
    }
}

