/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.debezium;

import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.camel.Consumer;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.debezium.DebeziumComponent;
import org.apache.camel.component.debezium.DebeziumConsumer;
import org.apache.camel.component.debezium.DebeziumTypeConverter;
import org.apache.camel.component.debezium.configuration.EmbeddedDebeziumConfiguration;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.errors.DataException;
import org.apache.kafka.connect.source.SourceRecord;

public abstract class DebeziumEndpoint<C extends EmbeddedDebeziumConfiguration>
extends DefaultEndpoint {
    protected DebeziumEndpoint(String uri, DebeziumComponent<C> component) {
        super(uri, component);
    }

    protected DebeziumEndpoint() {
    }

    public Producer createProducer() throws Exception {
        throw new UnsupportedOperationException("Cannot produce from a DebeziumEndpoint: " + this.getEndpointUri());
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        DebeziumConsumer consumer = new DebeziumConsumer(this, processor);
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    public ExecutorService createExecutor(Object source) {
        return this.getCamelContext().getExecutorServiceManager().newSingleThreadExecutor(source, "DebeziumConsumer");
    }

    public Exchange createDbzExchange(DebeziumConsumer consumer, SourceRecord sourceRecord) {
        Exchange exchange = consumer != null ? consumer.createExchange(false) : super.createExchange();
        Message message = exchange.getIn();
        Schema valueSchema = sourceRecord.valueSchema();
        Object value = sourceRecord.value();
        Map<String, Object> sourceMetadata = this.extractSourceMetadataValueFromValueStruct(valueSchema, value);
        Object operation = this.extractValueFromValueStruct(valueSchema, value, "op");
        Object before = this.extractValueFromValueStruct(valueSchema, value, "before");
        Object body = this.extractBodyValueFromValueStruct(valueSchema, value);
        Object timestamp = this.extractValueFromValueStruct(valueSchema, value, "ts_ms");
        Object ddl = this.extractValueFromValueStruct(valueSchema, value, "ddl");
        message.setHeader("CamelDebeziumIdentifier", (Object)sourceRecord.topic());
        message.setHeader("CamelDebeziumKey", sourceRecord.key());
        message.setHeader("CamelDebeziumSourceMetadata", sourceMetadata);
        message.setHeader("CamelDebeziumOperation", operation);
        message.setHeader("CamelDebeziumBefore", before);
        message.setHeader("CamelDebeziumTimestamp", timestamp);
        message.setHeader("CamelDebeziumDdlSQL", ddl);
        message.setHeader("CamelMessageTimestamp", timestamp);
        message.setBody(body);
        return exchange;
    }

    public abstract C getConfiguration();

    public abstract void setConfiguration(C var1);

    protected Object extractBodyValueFromValueStruct(Schema schema, Object value) {
        return this.extractFieldValueFromValueStruct(schema, value, "after");
    }

    protected Object extractFieldValueFromValueStruct(Schema schema, Object value, String fieldName) {
        Object valueExtracted = this.extractValueFromValueStruct(schema, value, fieldName);
        if (valueExtracted == null && !this.isSchemaAStructSchema(schema)) {
            return value;
        }
        return valueExtracted;
    }

    private Map<String, Object> extractSourceMetadataValueFromValueStruct(Schema schema, Object value) {
        Object valueExtracted = this.extractValueFromValueStruct(schema, value, "source");
        if (valueExtracted != null) {
            return DebeziumTypeConverter.toMap((Struct)valueExtracted);
        }
        return null;
    }

    private Object extractValueFromValueStruct(Schema schema, Object value, String fieldName) {
        if (this.isSchemaAStructSchema(schema) && value != null) {
            try {
                Struct valueStruct = (Struct)value;
                return valueStruct.get(fieldName);
            }
            catch (DataException e) {
                return null;
            }
        }
        return null;
    }

    private boolean isSchemaAStructSchema(Schema schema) {
        return schema != null && schema.type().equals((Object)Schema.Type.STRUCT);
    }
}

