/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.couchbase;

import com.couchbase.client.java.Bucket;
import com.couchbase.client.java.Collection;
import com.couchbase.client.java.Scope;
import com.couchbase.client.java.kv.GetResult;
import com.couchbase.client.java.kv.MutationResult;
import com.couchbase.client.java.kv.PersistTo;
import com.couchbase.client.java.kv.ReplicateTo;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.couchbase.CouchbaseCollectionOperation;
import org.apache.camel.component.couchbase.CouchbaseEndpoint;
import org.apache.camel.component.couchbase.CouchbaseException;
import org.apache.camel.support.DefaultProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CouchbaseProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(CouchbaseProducer.class);
    private final AtomicLong startId = new AtomicLong();
    private final CouchbaseEndpoint endpoint;
    private final Bucket client;
    private final Collection collection;
    private final PersistTo persistTo;
    private final ReplicateTo replicateTo;
    private final int producerRetryPause;
    private final long queryTimeout;
    private final long writeQueryTimeout;

    public CouchbaseProducer(CouchbaseEndpoint endpoint, Bucket client, int persistTo, int replicateTo) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
        this.client = client;
        Scope scope = endpoint.getScope() != null ? client.scope(endpoint.getScope()) : client.defaultScope();
        this.collection = endpoint.getCollection() != null ? scope.collection(endpoint.getCollection()) : client.defaultCollection();
        if (endpoint.isAutoStartIdForInserts()) {
            this.startId.set(endpoint.getStartingIdForInsertsFrom());
        }
        this.producerRetryPause = endpoint.getProducerRetryPause();
        this.writeQueryTimeout = endpoint.getWriteQueryTimeout();
        this.queryTimeout = endpoint.getQueryTimeout();
        switch (persistTo) {
            case 0: {
                this.persistTo = PersistTo.NONE;
                break;
            }
            case 1: {
                this.persistTo = PersistTo.ACTIVE;
                break;
            }
            case 3: {
                this.persistTo = PersistTo.THREE;
                break;
            }
            case 4: {
                this.persistTo = PersistTo.FOUR;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported persistTo parameter. Supported values are 0 to 4. Currently provided: " + persistTo);
            }
        }
        switch (replicateTo) {
            case 0: {
                this.replicateTo = ReplicateTo.NONE;
                break;
            }
            case 1: {
                this.replicateTo = ReplicateTo.ONE;
                break;
            }
            case 2: {
                this.replicateTo = ReplicateTo.TWO;
                break;
            }
            case 3: {
                this.replicateTo = ReplicateTo.THREE;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported replicateTo parameter. Supported values are 0 to 3. Currently provided: " + replicateTo);
            }
        }
    }

    public void process(Exchange exchange) throws Exception {
        int ttl;
        Map headers = exchange.getIn().getHeaders();
        String id = headers.containsKey("CCB_ID") ? (String)exchange.getIn().getHeader("CCB_ID", String.class) : this.endpoint.getId();
        int n = ttl = headers.containsKey("CCB_TTL") ? Integer.parseInt((String)exchange.getIn().getHeader("CCB_TTL", String.class)) : 0;
        if (this.endpoint.isAutoStartIdForInserts()) {
            id = Long.toString(this.startId.getAndIncrement());
        } else if (id == null) {
            throw new CouchbaseException("CCB_ID is not specified in message header or endpoint URL.", exchange);
        }
        if (this.endpoint.getOperation().equals("CCB_PUT")) {
            LOG.trace("Type of operation: PUT");
            Object obj = exchange.getIn().getBody();
            Boolean result = CouchbaseCollectionOperation.setDocument(this.collection, id, ttl, obj, this.persistTo, this.replicateTo, this.writeQueryTimeout, this.producerRetryPause);
            exchange.getMessage().setBody((Object)result);
        } else if (this.endpoint.getOperation().equals("CCB_GET")) {
            LOG.trace("Type of operation: GET");
            GetResult result = CouchbaseCollectionOperation.getDocument(this.collection, id, this.queryTimeout, this.producerRetryPause);
            exchange.getMessage().setBody((Object)result);
        } else if (this.endpoint.getOperation().equals("CCB_DEL")) {
            LOG.trace("Type of operation: DELETE");
            MutationResult result = CouchbaseCollectionOperation.removeDocument(this.collection, id, this.writeQueryTimeout, this.producerRetryPause);
            exchange.getMessage().setBody((Object)result.toString());
        }
        exchange.getIn().removeHeader("CCB_ID");
    }

    protected void doShutdown() throws Exception {
        super.doShutdown();
        if (this.client != null) {
            this.client.core().shutdown();
        }
    }
}

