/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.console;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.apache.camel.CamelContext;
import org.apache.camel.Route;
import org.apache.camel.api.management.ManagedCamelContext;
import org.apache.camel.api.management.mbean.ManagedRouteMBean;
import org.apache.camel.impl.console.ConsoleHelper;
import org.apache.camel.spi.ModelDumpLine;
import org.apache.camel.spi.ModelToStructureDumper;
import org.apache.camel.spi.annotations.DevConsole;
import org.apache.camel.support.LoggerHelper;
import org.apache.camel.support.PatternHelper;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.support.console.AbstractDevConsole;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.json.JsonObject;
import org.apache.camel.util.json.Jsoner;

@DevConsole(name="route-structure", description="Dump route structure")
public class RouteStructureDevConsole
extends AbstractDevConsole {
    public static final String FILTER = "filter";
    public static final String LIMIT = "limit";
    public static final String BRIEF = "brief";

    public RouteStructureDevConsole() {
        super("camel", "route-structure", "Route Structure", "Dump route structure");
    }

    protected String doCallText(Map<String, Object> options) {
        String brief = (String)options.getOrDefault(BRIEF, "false");
        StringBuilder sb = new StringBuilder();
        Function<ManagedRouteMBean, Object> task = mrb -> {
            try {
                ModelToStructureDumper dumper = PluginHelper.getModelToStructureDumper((CamelContext)this.getCamelContext());
                Route route = this.getCamelContext().getRoute(mrb.getRouteId());
                List lines = dumper.dumpStructure(this.getCamelContext(), route, "true".equalsIgnoreCase(brief));
                sb.append(String.format("    Id: %s", mrb.getRouteId()));
                if (mrb.getSourceLocation() != null) {
                    sb.append(String.format("\n    Source: %s", mrb.getSourceLocation()));
                }
                sb.append("\n\n");
                for (ModelDumpLine line : lines) {
                    String pad = StringHelper.padString((int)line.level());
                    String num = "       ";
                    Integer idx = ConsoleHelper.extractSourceLocationLineNumber(line.location());
                    if (idx != null) {
                        num = String.format("%4d:  ", idx);
                    }
                    sb.append(num).append(pad).append(line.code()).append("\n");
                }
                sb.append("\n");
            }
            catch (Exception exception) {
                // empty catch block
            }
            sb.append("\n");
            return null;
        };
        this.doCall(options, task);
        return sb.toString();
    }

    protected JsonObject doCallJson(Map<String, Object> options) {
        String brief = (String)options.getOrDefault(BRIEF, "false");
        JsonObject root = new JsonObject();
        ArrayList list = new ArrayList();
        Function<ManagedRouteMBean, Object> task = mrb -> {
            JsonObject jo = new JsonObject();
            list.add(jo);
            jo.put((Object)"routeId", (Object)mrb.getRouteId());
            jo.put((Object)"from", (Object)mrb.getEndpointUri());
            if (mrb.getSourceLocation() != null) {
                jo.put((Object)"source", (Object)mrb.getSourceLocation());
            }
            try {
                ModelToStructureDumper dumper = PluginHelper.getModelToStructureDumper((CamelContext)this.getCamelContext());
                Route route = this.getCamelContext().getRoute(mrb.getRouteId());
                List lines = dumper.dumpStructure(this.getCamelContext(), route, "true".equalsIgnoreCase(brief));
                List<JsonObject> code = RouteStructureDevConsole.dumpAsJSon(lines);
                jo.put((Object)"code", code);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        };
        this.doCall(options, task);
        root.put((Object)"routes", list);
        return root;
    }

    protected void doCall(Map<String, Object> options, Function<ManagedRouteMBean, Object> task) {
        String path = (String)options.get("CamelHttpPath");
        String subPath = path != null ? StringHelper.after((String)path, (String)"/") : null;
        String filter = (String)options.get(FILTER);
        String limit = (String)options.get(LIMIT);
        int max = limit == null ? Integer.MAX_VALUE : Integer.parseInt(limit);
        ManagedCamelContext mcc = (ManagedCamelContext)this.getCamelContext().getCamelContextExtension().getContextPlugin(ManagedCamelContext.class);
        if (mcc != null) {
            List routes = this.getCamelContext().getRoutes();
            routes.sort((o1, o2) -> o1.getRouteId().compareToIgnoreCase(o2.getRouteId()));
            routes.stream().map(route -> mcc.getManagedRoute(route.getRouteId())).filter(Objects::nonNull).filter(r -> RouteStructureDevConsole.accept(r, filter)).filter(r -> RouteStructureDevConsole.accept(r, subPath)).sorted(RouteStructureDevConsole::sort).limit(max).forEach(task::apply);
        }
    }

    private static boolean accept(ManagedRouteMBean mrb, String filter) {
        if (filter == null || filter.isBlank()) {
            return true;
        }
        String onlyName = LoggerHelper.sourceNameOnly((String)mrb.getSourceLocation());
        return PatternHelper.matchPattern((String)mrb.getRouteId(), (String)filter) || PatternHelper.matchPattern((String)mrb.getEndpointUri(), (String)filter) || PatternHelper.matchPattern((String)mrb.getSourceLocationShort(), (String)filter) || PatternHelper.matchPattern((String)onlyName, (String)filter);
    }

    private static int sort(ManagedRouteMBean o1, ManagedRouteMBean o2) {
        return o1.getRouteId().compareTo(o2.getRouteId());
    }

    private static List<JsonObject> dumpAsJSon(List<ModelDumpLine> lines) {
        ArrayList<JsonObject> code = new ArrayList<JsonObject>();
        int counter = 0;
        for (ModelDumpLine line : lines) {
            ++counter;
            JsonObject c = new JsonObject();
            Integer idx = ConsoleHelper.extractSourceLocationLineNumber(line.location());
            if (idx == null) {
                idx = counter;
            }
            c.put((Object)"line", (Object)idx);
            c.put((Object)"type", (Object)line.type());
            c.put((Object)"id", (Object)line.id());
            c.put((Object)"level", (Object)line.level());
            c.put((Object)"code", (Object)Jsoner.escape((String)line.code()));
            code.add(c);
        }
        return code;
    }
}

