/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.neo4j.Neo4jComponent;
import org.apache.camel.component.neo4j.Neo4jConfiguration;
import org.apache.camel.component.neo4j.Neo4jSimilarityFunction;
import org.neo4j.driver.Driver;

public interface Neo4jComponentBuilderFactory {
    public static Neo4jComponentBuilder neo4j() {
        return new Neo4jComponentBuilderImpl();
    }

    public static class Neo4jComponentBuilderImpl
    extends AbstractComponentBuilder<Neo4jComponent>
    implements Neo4jComponentBuilder {
        @Override
        protected Neo4jComponent buildConcreteComponent() {
            return new Neo4jComponent();
        }

        private Neo4jConfiguration getOrCreateConfiguration(Neo4jComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new Neo4jConfiguration());
            }
            return component.getConfiguration();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "alias": {
                    this.getOrCreateConfiguration((Neo4jComponent)component).setAlias((String)value);
                    return true;
                }
                case "configuration": {
                    ((Neo4jComponent)component).setConfiguration((Neo4jConfiguration)value);
                    return true;
                }
                case "databaseUrl": {
                    this.getOrCreateConfiguration((Neo4jComponent)component).setDatabaseUrl((String)value);
                    return true;
                }
                case "detachRelationship": {
                    this.getOrCreateConfiguration((Neo4jComponent)component).setDetachRelationship(((Boolean)value).booleanValue());
                    return true;
                }
                case "dimension": {
                    this.getOrCreateConfiguration((Neo4jComponent)component).setDimension((Integer)value);
                    return true;
                }
                case "label": {
                    this.getOrCreateConfiguration((Neo4jComponent)component).setLabel((String)value);
                    return true;
                }
                case "lazyStartProducer": {
                    ((Neo4jComponent)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "maxResults": {
                    this.getOrCreateConfiguration((Neo4jComponent)component).setMaxResults(((Integer)value).intValue());
                    return true;
                }
                case "minScore": {
                    this.getOrCreateConfiguration((Neo4jComponent)component).setMinScore(((Double)value).doubleValue());
                    return true;
                }
                case "query": {
                    this.getOrCreateConfiguration((Neo4jComponent)component).setQuery((String)value);
                    return true;
                }
                case "similarityFunction": {
                    this.getOrCreateConfiguration((Neo4jComponent)component).setSimilarityFunction((Neo4jSimilarityFunction)value);
                    return true;
                }
                case "vectorIndexName": {
                    this.getOrCreateConfiguration((Neo4jComponent)component).setVectorIndexName((String)value);
                    return true;
                }
                case "autowiredEnabled": {
                    ((Neo4jComponent)component).setAutowiredEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "driver": {
                    this.getOrCreateConfiguration((Neo4jComponent)component).setDriver((Driver)value);
                    return true;
                }
                case "kerberosAuthTicket": {
                    this.getOrCreateConfiguration((Neo4jComponent)component).setKerberosAuthTicket((String)value);
                    return true;
                }
                case "password": {
                    this.getOrCreateConfiguration((Neo4jComponent)component).setPassword((String)value);
                    return true;
                }
                case "realm": {
                    this.getOrCreateConfiguration((Neo4jComponent)component).setRealm((String)value);
                    return true;
                }
                case "token": {
                    this.getOrCreateConfiguration((Neo4jComponent)component).setToken((String)value);
                    return true;
                }
                case "username": {
                    this.getOrCreateConfiguration((Neo4jComponent)component).setUsername((String)value);
                    return true;
                }
            }
            return false;
        }
    }

    public static interface Neo4jComponentBuilder
    extends ComponentBuilder<Neo4jComponent> {
        default public Neo4jComponentBuilder alias(String alias) {
            this.doSetProperty("alias", alias);
            return this;
        }

        default public Neo4jComponentBuilder configuration(Neo4jConfiguration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public Neo4jComponentBuilder databaseUrl(String databaseUrl) {
            this.doSetProperty("databaseUrl", databaseUrl);
            return this;
        }

        default public Neo4jComponentBuilder detachRelationship(boolean detachRelationship) {
            this.doSetProperty("detachRelationship", detachRelationship);
            return this;
        }

        default public Neo4jComponentBuilder dimension(Integer dimension) {
            this.doSetProperty("dimension", dimension);
            return this;
        }

        default public Neo4jComponentBuilder label(String label) {
            this.doSetProperty("label", label);
            return this;
        }

        default public Neo4jComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public Neo4jComponentBuilder maxResults(int maxResults) {
            this.doSetProperty("maxResults", maxResults);
            return this;
        }

        default public Neo4jComponentBuilder minScore(double minScore) {
            this.doSetProperty("minScore", minScore);
            return this;
        }

        default public Neo4jComponentBuilder query(String query) {
            this.doSetProperty("query", query);
            return this;
        }

        default public Neo4jComponentBuilder similarityFunction(Neo4jSimilarityFunction similarityFunction) {
            this.doSetProperty("similarityFunction", similarityFunction);
            return this;
        }

        default public Neo4jComponentBuilder vectorIndexName(String vectorIndexName) {
            this.doSetProperty("vectorIndexName", vectorIndexName);
            return this;
        }

        default public Neo4jComponentBuilder autowiredEnabled(boolean autowiredEnabled) {
            this.doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }

        default public Neo4jComponentBuilder driver(Driver driver) {
            this.doSetProperty("driver", driver);
            return this;
        }

        default public Neo4jComponentBuilder kerberosAuthTicket(String kerberosAuthTicket) {
            this.doSetProperty("kerberosAuthTicket", kerberosAuthTicket);
            return this;
        }

        default public Neo4jComponentBuilder password(String password) {
            this.doSetProperty("password", password);
            return this;
        }

        default public Neo4jComponentBuilder realm(String realm) {
            this.doSetProperty("realm", realm);
            return this;
        }

        default public Neo4jComponentBuilder token(String token) {
            this.doSetProperty("token", token);
            return this;
        }

        default public Neo4jComponentBuilder username(String username) {
            this.doSetProperty("username", username);
            return this;
        }
    }
}

