/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.aws2.transcribe.Transcribe2Component;
import org.apache.camel.component.aws2.transcribe.Transcribe2Configuration;
import org.apache.camel.component.aws2.transcribe.Transcribe2Operations;
import software.amazon.awssdk.core.Protocol;
import software.amazon.awssdk.services.transcribe.TranscribeClient;

public interface Aws2TranscribeComponentBuilderFactory {
    public static Aws2TranscribeComponentBuilder aws2Transcribe() {
        return new Aws2TranscribeComponentBuilderImpl();
    }

    public static class Aws2TranscribeComponentBuilderImpl
    extends AbstractComponentBuilder<Transcribe2Component>
    implements Aws2TranscribeComponentBuilder {
        @Override
        protected Transcribe2Component buildConcreteComponent() {
            return new Transcribe2Component();
        }

        private Transcribe2Configuration getOrCreateConfiguration(Transcribe2Component component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new Transcribe2Configuration());
            }
            return component.getConfiguration();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "configuration": {
                    ((Transcribe2Component)component).setConfiguration((Transcribe2Configuration)value);
                    return true;
                }
                case "lazyStartProducer": {
                    ((Transcribe2Component)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "operation": {
                    this.getOrCreateConfiguration((Transcribe2Component)component).setOperation((Transcribe2Operations)value);
                    return true;
                }
                case "overrideEndpoint": {
                    this.getOrCreateConfiguration((Transcribe2Component)component).setOverrideEndpoint(((Boolean)value).booleanValue());
                    return true;
                }
                case "pojoRequest": {
                    this.getOrCreateConfiguration((Transcribe2Component)component).setPojoRequest(((Boolean)value).booleanValue());
                    return true;
                }
                case "profileCredentialsName": {
                    this.getOrCreateConfiguration((Transcribe2Component)component).setProfileCredentialsName((String)value);
                    return true;
                }
                case "protocol": {
                    this.getOrCreateConfiguration((Transcribe2Component)component).setProtocol((Protocol)value);
                    return true;
                }
                case "proxyHost": {
                    this.getOrCreateConfiguration((Transcribe2Component)component).setProxyHost((String)value);
                    return true;
                }
                case "proxyPort": {
                    this.getOrCreateConfiguration((Transcribe2Component)component).setProxyPort((Integer)value);
                    return true;
                }
                case "proxyProtocol": {
                    this.getOrCreateConfiguration((Transcribe2Component)component).setProxyProtocol((String)value);
                    return true;
                }
                case "region": {
                    this.getOrCreateConfiguration((Transcribe2Component)component).setRegion((String)value);
                    return true;
                }
                case "transcribeClient": {
                    this.getOrCreateConfiguration((Transcribe2Component)component).setTranscribeClient((TranscribeClient)value);
                    return true;
                }
                case "trustAllCertificates": {
                    this.getOrCreateConfiguration((Transcribe2Component)component).setTrustAllCertificates(((Boolean)value).booleanValue());
                    return true;
                }
                case "uriEndpointOverride": {
                    this.getOrCreateConfiguration((Transcribe2Component)component).setUriEndpointOverride((String)value);
                    return true;
                }
                case "useDefaultCredentialsProvider": {
                    this.getOrCreateConfiguration((Transcribe2Component)component).setUseDefaultCredentialsProvider(((Boolean)value).booleanValue());
                    return true;
                }
                case "useProfileCredentialsProvider": {
                    this.getOrCreateConfiguration((Transcribe2Component)component).setUseProfileCredentialsProvider(((Boolean)value).booleanValue());
                    return true;
                }
                case "useSessionCredentials": {
                    this.getOrCreateConfiguration((Transcribe2Component)component).setUseSessionCredentials(((Boolean)value).booleanValue());
                    return true;
                }
                case "autowiredEnabled": {
                    ((Transcribe2Component)component).setAutowiredEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "accessKey": {
                    this.getOrCreateConfiguration((Transcribe2Component)component).setAccessKey((String)value);
                    return true;
                }
                case "proxyPassword": {
                    this.getOrCreateConfiguration((Transcribe2Component)component).setProxyPassword((String)value);
                    return true;
                }
                case "proxyUsername": {
                    this.getOrCreateConfiguration((Transcribe2Component)component).setProxyUsername((String)value);
                    return true;
                }
                case "secretKey": {
                    this.getOrCreateConfiguration((Transcribe2Component)component).setSecretKey((String)value);
                    return true;
                }
                case "sessionToken": {
                    this.getOrCreateConfiguration((Transcribe2Component)component).setSessionToken((String)value);
                    return true;
                }
            }
            return false;
        }
    }

    public static interface Aws2TranscribeComponentBuilder
    extends ComponentBuilder<Transcribe2Component> {
        default public Aws2TranscribeComponentBuilder configuration(Transcribe2Configuration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public Aws2TranscribeComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public Aws2TranscribeComponentBuilder operation(Transcribe2Operations operation) {
            this.doSetProperty("operation", operation);
            return this;
        }

        default public Aws2TranscribeComponentBuilder overrideEndpoint(boolean overrideEndpoint) {
            this.doSetProperty("overrideEndpoint", overrideEndpoint);
            return this;
        }

        default public Aws2TranscribeComponentBuilder pojoRequest(boolean pojoRequest) {
            this.doSetProperty("pojoRequest", pojoRequest);
            return this;
        }

        default public Aws2TranscribeComponentBuilder profileCredentialsName(String profileCredentialsName) {
            this.doSetProperty("profileCredentialsName", profileCredentialsName);
            return this;
        }

        default public Aws2TranscribeComponentBuilder protocol(Protocol protocol) {
            this.doSetProperty("protocol", protocol);
            return this;
        }

        default public Aws2TranscribeComponentBuilder proxyHost(String proxyHost) {
            this.doSetProperty("proxyHost", proxyHost);
            return this;
        }

        default public Aws2TranscribeComponentBuilder proxyPort(Integer proxyPort) {
            this.doSetProperty("proxyPort", proxyPort);
            return this;
        }

        default public Aws2TranscribeComponentBuilder proxyProtocol(String proxyProtocol) {
            this.doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }

        default public Aws2TranscribeComponentBuilder region(String region) {
            this.doSetProperty("region", region);
            return this;
        }

        default public Aws2TranscribeComponentBuilder transcribeClient(TranscribeClient transcribeClient) {
            this.doSetProperty("transcribeClient", transcribeClient);
            return this;
        }

        default public Aws2TranscribeComponentBuilder trustAllCertificates(boolean trustAllCertificates) {
            this.doSetProperty("trustAllCertificates", trustAllCertificates);
            return this;
        }

        default public Aws2TranscribeComponentBuilder uriEndpointOverride(String uriEndpointOverride) {
            this.doSetProperty("uriEndpointOverride", uriEndpointOverride);
            return this;
        }

        default public Aws2TranscribeComponentBuilder useDefaultCredentialsProvider(boolean useDefaultCredentialsProvider) {
            this.doSetProperty("useDefaultCredentialsProvider", useDefaultCredentialsProvider);
            return this;
        }

        default public Aws2TranscribeComponentBuilder useProfileCredentialsProvider(boolean useProfileCredentialsProvider) {
            this.doSetProperty("useProfileCredentialsProvider", useProfileCredentialsProvider);
            return this;
        }

        default public Aws2TranscribeComponentBuilder useSessionCredentials(boolean useSessionCredentials) {
            this.doSetProperty("useSessionCredentials", useSessionCredentials);
            return this;
        }

        default public Aws2TranscribeComponentBuilder autowiredEnabled(boolean autowiredEnabled) {
            this.doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }

        default public Aws2TranscribeComponentBuilder accessKey(String accessKey) {
            this.doSetProperty("accessKey", accessKey);
            return this;
        }

        default public Aws2TranscribeComponentBuilder proxyPassword(String proxyPassword) {
            this.doSetProperty("proxyPassword", proxyPassword);
            return this;
        }

        default public Aws2TranscribeComponentBuilder proxyUsername(String proxyUsername) {
            this.doSetProperty("proxyUsername", proxyUsername);
            return this;
        }

        default public Aws2TranscribeComponentBuilder secretKey(String secretKey) {
            this.doSetProperty("secretKey", secretKey);
            return this;
        }

        default public Aws2TranscribeComponentBuilder sessionToken(String sessionToken) {
            this.doSetProperty("sessionToken", sessionToken);
            return this;
        }
    }
}

