/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.eventhubs.client;

import com.azure.core.credential.TokenCredential;
import com.azure.identity.DefaultAzureCredentialBuilder;
import com.azure.messaging.eventhubs.CheckpointStore;
import com.azure.messaging.eventhubs.EventHubClientBuilder;
import com.azure.messaging.eventhubs.EventHubConsumerAsyncClient;
import com.azure.messaging.eventhubs.EventHubProducerAsyncClient;
import com.azure.messaging.eventhubs.EventProcessorClient;
import com.azure.messaging.eventhubs.EventProcessorClientBuilder;
import com.azure.messaging.eventhubs.checkpointstore.blob.BlobCheckpointStore;
import com.azure.messaging.eventhubs.models.ErrorContext;
import com.azure.messaging.eventhubs.models.EventContext;
import com.azure.storage.blob.BlobContainerAsyncClient;
import com.azure.storage.blob.BlobContainerClientBuilder;
import com.azure.storage.common.StorageSharedKeyCredential;
import java.util.Locale;
import java.util.function.Consumer;
import org.apache.camel.component.azure.eventhubs.CredentialType;
import org.apache.camel.component.azure.eventhubs.EventHubsConfiguration;
import org.apache.camel.util.ObjectHelper;

public final class EventHubsClientFactory {
    private static final String SERVICE_URI_SEGMENT = "servicebus.windows.net";
    private static final String BLOB_SERVICE_URI_SEGMENT = ".blob.core.windows.net";

    private EventHubsClientFactory() {
    }

    public static EventHubProducerAsyncClient createEventHubProducerAsyncClient(EventHubsConfiguration configuration) {
        EventHubClientBuilder eventHubClientBuilder = new EventHubClientBuilder().transportType(configuration.getAmqpTransportType()).retryOptions(configuration.getAmqpRetryOptions());
        CredentialType type = configuration.getCredentialType();
        if (type == null) {
            type = CredentialType.CONNECTION_STRING;
        }
        if (CredentialType.CONNECTION_STRING.equals((Object)type)) {
            return eventHubClientBuilder.connectionString(EventHubsClientFactory.buildConnectionString(configuration)).buildAsyncProducerClient();
        }
        if (CredentialType.TOKEN_CREDENTIAL.equals((Object)type)) {
            EventHubsClientFactory.checkTokenCredentialConfiguration(configuration);
            return eventHubClientBuilder.fullyQualifiedNamespace(EventHubsClientFactory.getFullyQualifiedNamespace(configuration)).eventHubName(configuration.getEventHubName()).credential(configuration.getTokenCredential()).buildAsyncProducerClient();
        }
        return eventHubClientBuilder.fullyQualifiedNamespace(EventHubsClientFactory.getFullyQualifiedNamespace(configuration)).eventHubName(configuration.getEventHubName()).credential((TokenCredential)new DefaultAzureCredentialBuilder().build()).buildAsyncProducerClient();
    }

    public static EventHubConsumerAsyncClient createEventHubConsumerAsyncClient(EventHubsConfiguration configuration) {
        EventHubClientBuilder eventHubClientBuilder = new EventHubClientBuilder().consumerGroup(configuration.getConsumerGroupName()).prefetchCount(configuration.getPrefetchCount()).transportType(configuration.getAmqpTransportType()).retryOptions(configuration.getAmqpRetryOptions());
        CredentialType type = configuration.getCredentialType();
        if (type == null) {
            type = CredentialType.CONNECTION_STRING;
        }
        if (CredentialType.CONNECTION_STRING.equals((Object)type)) {
            return eventHubClientBuilder.connectionString(EventHubsClientFactory.buildConnectionString(configuration)).buildAsyncConsumerClient();
        }
        if (CredentialType.TOKEN_CREDENTIAL.equals((Object)type)) {
            EventHubsClientFactory.checkTokenCredentialConfiguration(configuration);
            return eventHubClientBuilder.fullyQualifiedNamespace(EventHubsClientFactory.getFullyQualifiedNamespace(configuration)).eventHubName(configuration.getEventHubName()).credential(configuration.getTokenCredential()).buildAsyncConsumerClient();
        }
        return eventHubClientBuilder.fullyQualifiedNamespace(EventHubsClientFactory.getFullyQualifiedNamespace(configuration)).eventHubName(configuration.getEventHubName()).credential((TokenCredential)new DefaultAzureCredentialBuilder().build()).buildAsyncConsumerClient();
    }

    public static EventProcessorClient createEventProcessorClient(EventHubsConfiguration configuration, Consumer<EventContext> processEvent, Consumer<ErrorContext> processError) {
        EventProcessorClientBuilder eventProcessorClientBuilder = new EventProcessorClientBuilder().initialPartitionEventPosition(configuration.getEventPosition()).checkpointStore(EventHubsClientFactory.createCheckpointStore(configuration)).consumerGroup(configuration.getConsumerGroupName()).retryOptions(configuration.getAmqpRetryOptions()).transportType(configuration.getAmqpTransportType()).processError(processError).processEvent(processEvent);
        CredentialType type = configuration.getCredentialType();
        if (type == null) {
            type = CredentialType.CONNECTION_STRING;
        }
        if (CredentialType.CONNECTION_STRING.equals((Object)type)) {
            return eventProcessorClientBuilder.connectionString(EventHubsClientFactory.buildConnectionString(configuration)).buildEventProcessorClient();
        }
        if (CredentialType.TOKEN_CREDENTIAL.equals((Object)type)) {
            EventHubsClientFactory.checkTokenCredentialConfiguration(configuration);
            return eventProcessorClientBuilder.fullyQualifiedNamespace(EventHubsClientFactory.getFullyQualifiedNamespace(configuration)).eventHubName(configuration.getEventHubName()).credential(configuration.getTokenCredential()).buildEventProcessorClient();
        }
        return eventProcessorClientBuilder.fullyQualifiedNamespace(EventHubsClientFactory.getFullyQualifiedNamespace(configuration)).eventHubName(configuration.getEventHubName()).credential((TokenCredential)new DefaultAzureCredentialBuilder().build()).buildEventProcessorClient();
    }

    public static BlobContainerAsyncClient createBlobContainerClient(EventHubsConfiguration configuration) {
        return new BlobContainerClientBuilder().endpoint(EventHubsClientFactory.buildAzureEndpointUri(configuration)).containerName(configuration.getBlobContainerName()).credential(EventHubsClientFactory.getCredentialForClient(configuration)).buildAsyncClient();
    }

    private static void checkTokenCredentialConfiguration(EventHubsConfiguration configuration) {
        if (ObjectHelper.isEmpty((String)configuration.getNamespace()) || ObjectHelper.isEmpty((String)configuration.getEventHubName())) {
            throw new IllegalArgumentException("EventHub's namespace and name is required for the Azure-AD authentication");
        }
    }

    private static CheckpointStore createCheckpointStore(EventHubsConfiguration configuration) {
        if (ObjectHelper.isNotEmpty((Object)configuration.getCheckpointStore())) {
            return configuration.getCheckpointStore();
        }
        if (ObjectHelper.isEmpty((String)configuration.getBlobContainerName()) || !EventHubsClientFactory.isCredentialsSet(configuration)) {
            throw new IllegalArgumentException("Since there is no provided CheckpointStore, you will need to set blobAccountName, blobAccessName or blobContainerName in order to use the default BlobCheckpointStore");
        }
        return new BlobCheckpointStore(EventHubsClientFactory.createBlobContainerClient(configuration));
    }

    private static boolean isCredentialsSet(EventHubsConfiguration configuration) {
        if (ObjectHelper.isNotEmpty((Object)configuration.getBlobStorageSharedKeyCredential())) {
            return true;
        }
        return ObjectHelper.isNotEmpty((String)configuration.getBlobAccessKey()) && ObjectHelper.isNotEmpty((String)configuration.getBlobAccountName());
    }

    private static String buildConnectionString(EventHubsConfiguration configuration) {
        if (ObjectHelper.isNotEmpty((String)configuration.getConnectionString())) {
            return configuration.getConnectionString();
        }
        return String.format(Locale.ROOT, "Endpoint=sb://%s.%s/;SharedAccessKeyName=%s;SharedAccessKey=%s;EntityPath=%s", configuration.getNamespace(), SERVICE_URI_SEGMENT, configuration.getSharedAccessName(), configuration.getSharedAccessKey(), configuration.getEventHubName());
    }

    private static String buildAzureEndpointUri(EventHubsConfiguration configuration) {
        return String.format(Locale.ROOT, "https://%s.blob.core.windows.net", EventHubsClientFactory.getAccountName(configuration));
    }

    private static StorageSharedKeyCredential getCredentialForClient(EventHubsConfiguration configuration) {
        StorageSharedKeyCredential storageSharedKeyCredential = configuration.getBlobStorageSharedKeyCredential();
        if (storageSharedKeyCredential != null) {
            return storageSharedKeyCredential;
        }
        return new StorageSharedKeyCredential(configuration.getBlobAccountName(), configuration.getBlobAccessKey());
    }

    private static String getAccountName(EventHubsConfiguration configuration) {
        return ObjectHelper.isNotEmpty((Object)configuration.getBlobStorageSharedKeyCredential()) ? configuration.getBlobStorageSharedKeyCredential().getAccountName() : configuration.getBlobAccountName();
    }

    private static String getFullyQualifiedNamespace(EventHubsConfiguration configuration) {
        return configuration.getNamespace() + ".servicebus.windows.net";
    }
}

