/*
 * Decompiled with CFR 0.152.
 */
package zio.schema.validation;

import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichChar;
import zio.schema.validation.Regex;
import zio.schema.validation.Regex$Digit$;
import zio.schema.validation.Regex$Empty$;
import zio.schema.validation.Regex$Letter$;

public final class Regex$ {
    public static final Regex$ MODULE$ = new Regex$();
    private static final Regex digit = Regex$Digit$.MODULE$;
    private static final Regex digitNonZero = MODULE$.between('1', '9');
    private static final Regex letter = Regex$Letter$.MODULE$;
    private static final Regex digitOrLetter = MODULE$.digit().$bar(MODULE$.letter());
    private static final Regex hexDigit = Regex$Digit$.MODULE$.$bar(MODULE$.between('a', 'f')).$bar(MODULE$.between('A', 'F'));
    private static final Regex hexDigitNonZero = MODULE$.digitNonZero().$bar(MODULE$.between('a', 'f')).$bar(MODULE$.between('A', 'F'));

    public Regex between(char minChar, char maxChar) {
        return new Regex.Between(minChar, maxChar);
    }

    public Regex filter(Function1<Object, Object> f) {
        return new Regex.CharacterSet((Set<Object>)((IterableOnceOps)new RichChar(Predef$.MODULE$.charWrapper('\u0000')).to((Object)BoxesRunTime.boxToCharacter((char)'\uffff')).filter(f)).toSet());
    }

    public Regex literal(String str) {
        return new Regex.Literal(str);
    }

    public Regex oneOf(Seq<Object> chars) {
        return new Regex.CharacterSet((Set<Object>)chars.toSet());
    }

    public Regex digit() {
        return digit;
    }

    public Regex digitNonZero() {
        return digitNonZero;
    }

    public Regex letter() {
        return letter;
    }

    public Regex digitOrLetter() {
        return digitOrLetter;
    }

    public Regex hexDigit() {
        return hexDigit;
    }

    public Regex hexDigitNonZero() {
        return hexDigitNonZero;
    }

    private String escapeChar(char ch) {
        char c = ch;
        switch (c) {
            case '.': {
                return "\\.";
            }
            case '^': {
                return "\\^";
            }
            case '$': {
                return "\\$";
            }
            case '|': {
                return "\\|";
            }
            case '*': {
                return "\\*";
            }
            case '+': {
                return "\\+";
            }
            case '?': {
                return "\\?";
            }
            case '(': {
                return "\\(";
            }
            case ')': {
                return "\\)";
            }
            case '[': {
                return "\\[";
            }
            case ']': {
                return "\\]";
            }
            case '{': {
                return "\\{";
            }
            case '}': {
                return "\\}";
            }
            case '\\': {
                return "\\\\";
            }
        }
        return Character.toString(ch);
    }

    public String toRegexString(Regex regex) {
        return this.loop$1(regex);
    }

    private final String loop$1(Regex regex) {
        boolean bl = false;
        Regex.CharacterSet characterSet = null;
        boolean bl2 = false;
        Regex.Repeat repeat = null;
        Regex regex2 = regex;
        if (regex2 instanceof Regex.CharacterSet) {
            bl = true;
            characterSet = (Regex.CharacterSet)regex2;
            Set<Object> elem = characterSet.set();
            if (elem.size() == 1) {
                return this.escapeChar(BoxesRunTime.unboxToChar((Object)elem.head()));
            }
        }
        if (bl) {
            Set<Object> set = characterSet.set();
            return ((List)set.toList().sorted((Ordering)Ordering.Char$.MODULE$)).map((Function1 & Serializable)ch -> Regex$.MODULE$.escapeChar(BoxesRunTime.unboxToChar((Object)ch))).mkString("[", "", "]");
        }
        if (regex2 instanceof Regex.Literal) {
            Regex.Literal literal = (Regex.Literal)regex2;
            String str = literal.str();
            String escaped = StringOps$.MODULE$.flatMap$extension(Predef$.MODULE$.augmentString(str), (Function1 & Serializable)ch -> Regex$.MODULE$.escapeChar(BoxesRunTime.unboxToChar((Object)ch)));
            return new StringBuilder(2).append("(").append(escaped).append(")").toString();
        }
        if (regex2 instanceof Regex.Between) {
            Regex.Between between = (Regex.Between)regex2;
            char start = between.start();
            char end = between.end();
            String escapedStart = this.escapeChar(start);
            String escapedEnd = this.escapeChar(end);
            return new StringBuilder(3).append("[").append(escapedStart).append("-").append(escapedEnd).append("]").toString();
        }
        if (regex2 instanceof Regex.Repeat) {
            Some some;
            int n;
            bl2 = true;
            repeat = (Regex.Repeat)regex2;
            Regex regex3 = repeat.regex();
            Option<Object> option = repeat.min();
            Option<Object> option2 = repeat.max();
            if (option instanceof Some && 0 == (n = BoxesRunTime.unboxToInt((Object)(some = (Some)option).value())) && None$.MODULE$.equals(option2)) {
                return new StringBuilder(3).append("(").append(this.loop$1(regex3)).append(")*").toString();
            }
        }
        if (bl2) {
            Some some;
            int n;
            Regex regex4 = repeat.regex();
            Option<Object> option = repeat.min();
            Option<Object> option3 = repeat.max();
            if (option instanceof Some && 1 == (n = BoxesRunTime.unboxToInt((Object)(some = (Some)option).value())) && None$.MODULE$.equals(option3)) {
                return new StringBuilder(3).append("(").append(this.loop$1(regex4)).append(")+").toString();
            }
        }
        if (bl2) {
            Some some;
            int n;
            Regex regex5 = repeat.regex();
            Option<Object> option = repeat.min();
            Option<Object> option4 = repeat.max();
            if (None$.MODULE$.equals(option) && option4 instanceof Some && 1 == (n = BoxesRunTime.unboxToInt((Object)(some = (Some)option4).value()))) {
                return new StringBuilder(3).append("(").append(this.loop$1(regex5)).append(")?").toString();
            }
        }
        if (bl2) {
            Regex regex6 = repeat.regex();
            Option<Object> option = repeat.min();
            Option<Object> option5 = repeat.max();
            if (option instanceof Some) {
                Some some;
                int m;
                Some some2 = (Some)option;
                int n = BoxesRunTime.unboxToInt((Object)some2.value());
                if (option5 instanceof Some && n == (m = BoxesRunTime.unboxToInt((Object)(some = (Some)option5).value()))) {
                    return new StringBuilder(4).append("(").append(this.loop$1(regex6)).append("){").append(n).append("}").toString();
                }
            }
        }
        if (bl2) {
            Regex regex7 = repeat.regex();
            Option<Object> option = repeat.min();
            Option<Object> option6 = repeat.max();
            if (option instanceof Some) {
                Some some = (Some)option;
                int n = BoxesRunTime.unboxToInt((Object)some.value());
                if (None$.MODULE$.equals(option6)) {
                    return new StringBuilder(5).append("(").append(this.loop$1(regex7)).append("){").append(n).append(",}").toString();
                }
            }
        }
        if (bl2) {
            Regex regex8 = repeat.regex();
            Option<Object> option = repeat.min();
            Option<Object> option7 = repeat.max();
            if (None$.MODULE$.equals(option) && option7 instanceof Some) {
                Some some = (Some)option7;
                int m = BoxesRunTime.unboxToInt((Object)some.value());
                return new StringBuilder(6).append("(").append(this.loop$1(regex8)).append("){0,").append(m).append("}").toString();
            }
        }
        if (bl2) {
            Regex regex9 = repeat.regex();
            Option<Object> option = repeat.min();
            Option<Object> option8 = repeat.max();
            if (option instanceof Some) {
                Some some = (Some)option;
                int n = BoxesRunTime.unboxToInt((Object)some.value());
                if (option8 instanceof Some) {
                    Some some3 = (Some)option8;
                    int m = BoxesRunTime.unboxToInt((Object)some3.value());
                    return new StringBuilder(5).append("(").append(this.loop$1(regex9)).append("){").append(n).append(",").append(m).append("}").toString();
                }
            }
        }
        if (bl2) {
            Option<Object> option = repeat.min();
            Option<Object> option9 = repeat.max();
            if (None$.MODULE$.equals(option) && None$.MODULE$.equals(option9)) {
                throw new IllegalArgumentException("Cannot have no repeat count");
            }
        }
        if (Regex$Empty$.MODULE$.equals(regex2)) {
            return "";
        }
        if (regex2 instanceof Regex.Alternate) {
            Regex.Alternate alternate = (Regex.Alternate)regex2;
            Regex left = alternate.left();
            Regex right = alternate.right();
            return new StringBuilder(7).append("((").append(this.loop$1(left)).append(")|(").append(this.loop$1(right)).append("))").toString();
        }
        if (Regex$Letter$.MODULE$.equals(regex2)) {
            return "[a-zA-Z]";
        }
        if (Regex$Digit$.MODULE$.equals(regex2)) {
            return "\\d";
        }
        if (regex2 instanceof Regex.Sequence) {
            Regex.Sequence sequence = (Regex.Sequence)regex2;
            Regex first = sequence.first();
            Regex second = sequence.second();
            return new StringBuilder(0).append(this.loop$1(first)).append(this.loop$1(second)).toString();
        }
        throw new MatchError((Object)regex2);
    }

    private Regex$() {
    }
}

