/*
 * Decompiled with CFR 0.152.
 */
package zio.schema.meta;

import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import zio.Chunk;
import zio.Chunk$;
import zio.constraintless.TypeList;
import zio.schema.TypeId;
import zio.schema.meta.ExtensibleMetaSchema;
import zio.schema.meta.NodePath$;
import zio.schema.meta.NodePath$NodePathSyntax$;

public final class AstRenderer$ {
    public static final AstRenderer$ MODULE$ = new AstRenderer$();
    private static final int INDENT_STEP = 2;

    private int INDENT_STEP() {
        return INDENT_STEP;
    }

    public String render(ExtensibleMetaSchema<?> ast) {
        ExtensibleMetaSchema<?> extensibleMetaSchema = ast;
        if (extensibleMetaSchema instanceof ExtensibleMetaSchema.Value) {
            ExtensibleMetaSchema.Value value = (ExtensibleMetaSchema.Value)extensibleMetaSchema;
            return this.renderValue(value, 0, (Option<String>)None$.MODULE$);
        }
        if (extensibleMetaSchema instanceof ExtensibleMetaSchema.FailNode) {
            ExtensibleMetaSchema.FailNode failNode = (ExtensibleMetaSchema.FailNode)extensibleMetaSchema;
            return this.renderFail(failNode, 0, (Option<String>)None$.MODULE$);
        }
        if (extensibleMetaSchema instanceof ExtensibleMetaSchema.Product) {
            ExtensibleMetaSchema.Product product = (ExtensibleMetaSchema.Product)extensibleMetaSchema;
            Chunk fields = product.fields();
            boolean optional2 = product.optional();
            StringBuffer buffer = new StringBuffer();
            buffer.append("product");
            Object object = optional2 ? buffer.append("?") : BoxedUnit.UNIT;
            return buffer.append("\n").append(fields.map((Function1 & Serializable)x$1 -> MODULE$.renderField((ExtensibleMetaSchema.Labelled)x$1, MODULE$.INDENT_STEP())).mkString("\n")).toString();
        }
        if (extensibleMetaSchema instanceof ExtensibleMetaSchema.Tuple) {
            ExtensibleMetaSchema.Tuple tuple2 = (ExtensibleMetaSchema.Tuple)extensibleMetaSchema;
            ExtensibleMetaSchema left = tuple2.left();
            ExtensibleMetaSchema right = tuple2.right();
            boolean optional3 = tuple2.optional();
            StringBuffer buffer = new StringBuffer();
            buffer.append("tuple");
            Object object = optional3 ? buffer.append("?") : BoxedUnit.UNIT;
            return buffer.append("\n").append(Chunk$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ExtensibleMetaSchema.Labelled[]{new ExtensibleMetaSchema.Labelled("left", left), new ExtensibleMetaSchema.Labelled("right", right)})).map((Function1 & Serializable)x$2 -> MODULE$.renderField((ExtensibleMetaSchema.Labelled)x$2, MODULE$.INDENT_STEP())).mkString("\n")).toString();
        }
        if (extensibleMetaSchema instanceof ExtensibleMetaSchema.Sum) {
            ExtensibleMetaSchema.Sum sum = (ExtensibleMetaSchema.Sum)extensibleMetaSchema;
            Chunk cases = sum.cases();
            boolean optional4 = sum.optional();
            StringBuffer buffer = new StringBuffer();
            buffer.append("enum");
            Object object = optional4 ? buffer.append("?") : BoxedUnit.UNIT;
            return buffer.append("\n").append(cases.map((Function1 & Serializable)x$3 -> MODULE$.renderField((ExtensibleMetaSchema.Labelled)x$3, MODULE$.INDENT_STEP())).mkString("\n")).toString();
        }
        if (extensibleMetaSchema instanceof ExtensibleMetaSchema.Either) {
            ExtensibleMetaSchema.Either either2 = (ExtensibleMetaSchema.Either)extensibleMetaSchema;
            ExtensibleMetaSchema left = either2.left();
            ExtensibleMetaSchema right = either2.right();
            boolean optional5 = either2.optional();
            StringBuffer buffer = new StringBuffer();
            buffer.append("either");
            Object object = optional5 ? buffer.append("?") : BoxedUnit.UNIT;
            return buffer.append("\n").append(Chunk$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ExtensibleMetaSchema.Labelled[]{new ExtensibleMetaSchema.Labelled("left", left), new ExtensibleMetaSchema.Labelled("right", right)})).map((Function1 & Serializable)x$4 -> MODULE$.renderField((ExtensibleMetaSchema.Labelled)x$4, MODULE$.INDENT_STEP())).mkString("\n")).toString();
        }
        if (extensibleMetaSchema instanceof ExtensibleMetaSchema.ListNode) {
            ExtensibleMetaSchema.ListNode listNode = (ExtensibleMetaSchema.ListNode)extensibleMetaSchema;
            ExtensibleMetaSchema items = listNode.item();
            boolean optional6 = listNode.optional();
            StringBuffer buffer = new StringBuffer();
            buffer.append("list");
            Object object = optional6 ? buffer.append("?") : BoxedUnit.UNIT;
            return buffer.append("\n").append(Chunk$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ExtensibleMetaSchema.Labelled[]{new ExtensibleMetaSchema.Labelled("item", items)})).map((Function1 & Serializable)x$5 -> MODULE$.renderField((ExtensibleMetaSchema.Labelled)x$5, MODULE$.INDENT_STEP())).mkString("\n")).toString();
        }
        if (extensibleMetaSchema instanceof ExtensibleMetaSchema.Dictionary) {
            ExtensibleMetaSchema.Dictionary dictionary = (ExtensibleMetaSchema.Dictionary)extensibleMetaSchema;
            ExtensibleMetaSchema keys = dictionary.keys();
            ExtensibleMetaSchema values = dictionary.values();
            boolean optional7 = dictionary.optional();
            StringBuffer buffer = new StringBuffer();
            buffer.append("map");
            Object object = optional7 ? buffer.append("?") : BoxedUnit.UNIT;
            return buffer.append("\n").append(Chunk$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ExtensibleMetaSchema.Labelled[]{new ExtensibleMetaSchema.Labelled("keys", keys), new ExtensibleMetaSchema.Labelled("values", values)})).map((Function1 & Serializable)x$6 -> MODULE$.renderField((ExtensibleMetaSchema.Labelled)x$6, MODULE$.INDENT_STEP())).mkString("\n")).toString();
        }
        if (extensibleMetaSchema instanceof ExtensibleMetaSchema.Ref) {
            ExtensibleMetaSchema.Ref ref = (ExtensibleMetaSchema.Ref)extensibleMetaSchema;
            Chunk refPath = ref.refPath();
            boolean optional8 = ref.optional();
            StringBuffer buffer = new StringBuffer();
            buffer.append(new StringBuilder(4).append("ref#").append(refPath).toString());
            Object object = optional8 ? buffer.append("?") : BoxedUnit.UNIT;
            return buffer.toString();
        }
        if (extensibleMetaSchema instanceof ExtensibleMetaSchema.Known) {
            ExtensibleMetaSchema.Known known = (ExtensibleMetaSchema.Known)extensibleMetaSchema;
            TypeId typeId = known.typeId();
            boolean optional9 = known.optional();
            StringBuffer buffer = new StringBuffer();
            buffer.append(typeId.toString());
            Object object = optional9 ? buffer.append("?") : BoxedUnit.UNIT;
            return buffer.toString();
        }
        throw new MatchError(extensibleMetaSchema);
    }

    public <BuiltIn extends TypeList> String renderField(ExtensibleMetaSchema.Labelled<BuiltIn> labelled, int indent) {
        StringBuffer buffer = new StringBuffer();
        ExtensibleMetaSchema<BuiltIn> extensibleMetaSchema = labelled.schema();
        if (extensibleMetaSchema instanceof ExtensibleMetaSchema.Value) {
            ExtensibleMetaSchema.Value value = (ExtensibleMetaSchema.Value)extensibleMetaSchema;
            return this.renderValue(value, indent, (Option<String>)new Some((Object)labelled.label()));
        }
        if (extensibleMetaSchema instanceof ExtensibleMetaSchema.FailNode) {
            ExtensibleMetaSchema.FailNode failNode = (ExtensibleMetaSchema.FailNode)extensibleMetaSchema;
            return this.renderFail(failNode, indent, (Option<String>)new Some((Object)labelled.label()));
        }
        if (extensibleMetaSchema instanceof ExtensibleMetaSchema.Product) {
            ExtensibleMetaSchema.Product product = (ExtensibleMetaSchema.Product)extensibleMetaSchema;
            Chunk fields = product.fields();
            boolean optional2 = product.optional();
            this.pad(buffer, indent);
            buffer.append(new StringBuilder(8).append(labelled.label()).append(": record").toString());
            Object object = optional2 ? buffer.append("?") : BoxedUnit.UNIT;
            return buffer.append("\n").append(fields.map((Function1 & Serializable)x$7 -> MODULE$.renderField((ExtensibleMetaSchema.Labelled)x$7, indent + MODULE$.INDENT_STEP())).mkString("\n")).toString();
        }
        if (extensibleMetaSchema instanceof ExtensibleMetaSchema.Tuple) {
            ExtensibleMetaSchema.Tuple tuple2 = (ExtensibleMetaSchema.Tuple)extensibleMetaSchema;
            ExtensibleMetaSchema left = tuple2.left();
            ExtensibleMetaSchema right = tuple2.right();
            boolean optional3 = tuple2.optional();
            this.pad(buffer, indent);
            buffer.append(new StringBuilder(7).append(labelled.label()).append(": tuple").toString());
            Object object = optional3 ? buffer.append("?") : BoxedUnit.UNIT;
            return buffer.append("\n").append(Chunk$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ExtensibleMetaSchema.Labelled[]{new ExtensibleMetaSchema.Labelled("left", left), new ExtensibleMetaSchema.Labelled("right", right)})).map((Function1 & Serializable)x$8 -> MODULE$.renderField((ExtensibleMetaSchema.Labelled)x$8, indent + MODULE$.INDENT_STEP())).mkString("\n")).toString();
        }
        if (extensibleMetaSchema instanceof ExtensibleMetaSchema.Sum) {
            ExtensibleMetaSchema.Sum sum = (ExtensibleMetaSchema.Sum)extensibleMetaSchema;
            Chunk cases = sum.cases();
            boolean optional4 = sum.optional();
            this.pad(buffer, indent);
            buffer.append(new StringBuilder(6).append(labelled.label()).append(": enum").toString());
            Object object = optional4 ? buffer.append("?") : BoxedUnit.UNIT;
            return buffer.append("\n").append(cases.map((Function1 & Serializable)x$9 -> MODULE$.renderField((ExtensibleMetaSchema.Labelled)x$9, indent + MODULE$.INDENT_STEP())).mkString("\n")).toString();
        }
        if (extensibleMetaSchema instanceof ExtensibleMetaSchema.Either) {
            ExtensibleMetaSchema.Either either2 = (ExtensibleMetaSchema.Either)extensibleMetaSchema;
            ExtensibleMetaSchema left = either2.left();
            ExtensibleMetaSchema right = either2.right();
            boolean optional5 = either2.optional();
            this.pad(buffer, indent);
            buffer.append(new StringBuilder(8).append(labelled.label()).append(": either").toString());
            Object object = optional5 ? buffer.append("?") : BoxedUnit.UNIT;
            return buffer.append("\n").append(Chunk$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ExtensibleMetaSchema.Labelled[]{new ExtensibleMetaSchema.Labelled("left", left), new ExtensibleMetaSchema.Labelled("right", right)})).map((Function1 & Serializable)x$10 -> MODULE$.renderField((ExtensibleMetaSchema.Labelled)x$10, indent + MODULE$.INDENT_STEP())).mkString("\n")).toString();
        }
        if (extensibleMetaSchema instanceof ExtensibleMetaSchema.ListNode) {
            ExtensibleMetaSchema.ListNode listNode = (ExtensibleMetaSchema.ListNode)extensibleMetaSchema;
            ExtensibleMetaSchema items = listNode.item();
            boolean optional6 = listNode.optional();
            StringBuffer buffer2 = new StringBuffer();
            buffer2.append(new StringBuilder(6).append(labelled.label()).append(": list").toString());
            Object object = optional6 ? buffer2.append("?") : BoxedUnit.UNIT;
            return buffer2.append("\n").append(Chunk$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ExtensibleMetaSchema.Labelled[]{new ExtensibleMetaSchema.Labelled("item", items)})).map((Function1 & Serializable)x$11 -> MODULE$.renderField((ExtensibleMetaSchema.Labelled)x$11, MODULE$.INDENT_STEP())).mkString("\n")).toString();
        }
        if (extensibleMetaSchema instanceof ExtensibleMetaSchema.Dictionary) {
            ExtensibleMetaSchema.Dictionary dictionary = (ExtensibleMetaSchema.Dictionary)extensibleMetaSchema;
            ExtensibleMetaSchema keys = dictionary.keys();
            ExtensibleMetaSchema values = dictionary.values();
            boolean optional7 = dictionary.optional();
            StringBuffer buffer3 = new StringBuffer();
            buffer3.append(new StringBuilder(5).append(labelled.label()).append(": map").toString());
            Object object = optional7 ? buffer3.append("?") : BoxedUnit.UNIT;
            return buffer3.append("\n").append(Chunk$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ExtensibleMetaSchema.Labelled[]{new ExtensibleMetaSchema.Labelled("keys", keys), new ExtensibleMetaSchema.Labelled("values", values)})).map((Function1 & Serializable)x$12 -> MODULE$.renderField((ExtensibleMetaSchema.Labelled)x$12, MODULE$.INDENT_STEP())).mkString("\n")).toString();
        }
        if (extensibleMetaSchema instanceof ExtensibleMetaSchema.Ref) {
            ExtensibleMetaSchema.Ref ref = (ExtensibleMetaSchema.Ref)extensibleMetaSchema;
            Chunk refPath = ref.refPath();
            boolean optional8 = ref.optional();
            this.pad(buffer, indent);
            buffer.append(new StringBuilder(2).append(labelled.label()).append(": ").toString());
            Object object = optional8 ? buffer.append("?") : BoxedUnit.UNIT;
            return buffer.append(new StringBuilder(6).append("{ref#").append(NodePath$NodePathSyntax$.MODULE$.render$extension(NodePath$.MODULE$.NodePathSyntax(refPath))).append("}").toString()).toString();
        }
        if (extensibleMetaSchema instanceof ExtensibleMetaSchema.Known) {
            ExtensibleMetaSchema.Known known = (ExtensibleMetaSchema.Known)extensibleMetaSchema;
            TypeId typeId = known.typeId();
            boolean optional9 = known.optional();
            this.pad(buffer, indent);
            buffer.append(new StringBuilder(2).append(labelled.label()).append(": ").toString());
            buffer.append(typeId.toString());
            Object object = optional9 ? buffer.append("?") : BoxedUnit.UNIT;
            return buffer.toString();
        }
        throw new MatchError(extensibleMetaSchema);
    }

    public String renderValue(ExtensibleMetaSchema.Value<?> value, int indent, Option<String> label) {
        StringBuffer buffer = new StringBuffer();
        this.pad(buffer, indent);
        label.foreach((Function1 & Serializable)l -> buffer.append(new StringBuilder(2).append((String)l).append(": ").toString()));
        Object object = value.optional() ? buffer.append("?") : BoxedUnit.UNIT;
        return buffer.append(value.valueType().tag()).toString();
    }

    public String renderFail(ExtensibleMetaSchema.FailNode<?> fail2, int indent, Option<String> label) {
        StringBuffer buffer = new StringBuffer();
        this.pad(buffer, indent);
        label.foreach((Function1 & Serializable)l -> buffer.append(new StringBuilder(2).append((String)l).append(": ").toString()));
        Object object = fail2.optional() ? buffer.append("?") : BoxedUnit.UNIT;
        return buffer.append(new StringBuilder(6).append("FAIL: ").append(fail2.message()).toString()).toString();
    }

    private StringBuffer pad(StringBuffer buffer, int indent) {
        block0: {
            if (indent <= 0) break block0;
            buffer.append("|");
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), indent).foreach((Function1 & Serializable)x$13 -> AstRenderer$.$anonfun$pad$1(buffer, BoxesRunTime.unboxToInt((Object)x$13)));
        }
        return buffer;
    }

    public static final /* synthetic */ StringBuffer $anonfun$pad$1(StringBuffer buffer$3, int x$13) {
        int n = x$13;
        return buffer$3.append("-");
    }

    private AstRenderer$() {
    }
}

