/*
 * Decompiled with CFR 0.152.
 */
package org.xbean.spring.generator;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.xbean.spring.generator.ElementMapping;

public class NamespaceMapping
implements Comparable {
    private final String namespace;
    private final Set elements;
    private final Map elementsByName;
    private final ElementMapping rootElement;

    public NamespaceMapping(String namespace, Set elements, ElementMapping rootElement) {
        this.namespace = namespace;
        this.elements = Collections.unmodifiableSet(new TreeSet(elements));
        this.rootElement = rootElement;
        HashMap<String, ElementMapping> elementsByName = new HashMap<String, ElementMapping>();
        Iterator iterator = elements.iterator();
        while (iterator.hasNext()) {
            ElementMapping elementMapping = (ElementMapping)iterator.next();
            elementsByName.put(elementMapping.getElementName(), elementMapping);
        }
        this.elementsByName = Collections.unmodifiableMap(elementsByName);
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Set getElements() {
        return this.elements;
    }

    public ElementMapping getElement(String elementName) {
        return (ElementMapping)this.elementsByName.get(elementName);
    }

    public ElementMapping getRootElement() {
        return this.rootElement;
    }

    public int hashCode() {
        return this.namespace.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof NamespaceMapping) {
            return this.namespace.equals(((NamespaceMapping)obj).namespace);
        }
        return false;
    }

    public int compareTo(Object obj) {
        return this.namespace.compareTo(((NamespaceMapping)obj).namespace);
    }
}

