/*
 * Decompiled with CFR 0.152.
 */
package org.xbean.spring.context.impl;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.xml.DefaultXmlBeanDefinitionParser;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.support.AbstractApplicationContext;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xbean.spring.context.impl.MappingMetaData;
import org.xbean.spring.context.impl.NamedConstructorArgs;
import org.xbean.spring.context.impl.NamespaceHelper;
import org.xbean.spring.context.impl.PropertyEditorHelper;
import org.xbean.spring.context.impl.QNameReflectionHelper;

public class XBeanXmlBeanDefinitionParser
extends DefaultXmlBeanDefinitionParser {
    public static final String SPRING_SCHEMA = "http://xbean.org/schemas/spring/1.0";
    private static final Log log;
    protected static final String[] RESERVED_ELEMENT_NAMES;
    protected static final String[] RESERVED_BEAN_ATTRIBUTE_NAMES;
    private static final String JAVA_PACKAGE_PREFIX = "java://";
    private static final String BEAN_REFERENCE_PREFIX = "#";
    private Set reservedElementNames = new HashSet<String>(Arrays.asList(RESERVED_ELEMENT_NAMES));
    private Set reservedBeanAttributeNames = new HashSet<String>(Arrays.asList(RESERVED_BEAN_ATTRIBUTE_NAMES));
    protected final NamedConstructorArgs namedConstructorArgs = new NamedConstructorArgs();
    private boolean qnameIsOnClassPath;
    private boolean initQNameOnClassPath;
    static /* synthetic */ Class class$org$xbean$spring$context$impl$XBeanXmlBeanDefinitionParser;
    static /* synthetic */ Class class$java$util$Collection;

    public static void configure(AbstractApplicationContext context, XmlBeanDefinitionReader reader) {
        reader.setValidating(false);
        reader.setNamespaceAware(true);
        reader.setParserClass(class$org$xbean$spring$context$impl$XBeanXmlBeanDefinitionParser == null ? (class$org$xbean$spring$context$impl$XBeanXmlBeanDefinitionParser = XBeanXmlBeanDefinitionParser.class$("org.xbean.spring.context.impl.XBeanXmlBeanDefinitionParser")) : class$org$xbean$spring$context$impl$XBeanXmlBeanDefinitionParser);
    }

    public static void registerCustomEditors(DefaultListableBeanFactory beanFactory) {
        PropertyEditorHelper.registerCustomEditors();
    }

    protected BeanDefinitionHolder parseBeanFromExtensionElement(Element element) {
        String className;
        String localName;
        String uri = element.getNamespaceURI();
        MappingMetaData metadata = this.findNamespaceProperties(uri, localName = this.getLocalName(element));
        if (metadata != null && (className = metadata.getClassName(localName)) != null) {
            Element original = this.cloneElement(element);
            element.setAttributeNS(null, "class", className);
            this.addSpringAttributeValues(className, element);
            BeanDefinitionHolder definition = this.parseBeanDefinitionElement(element, false);
            this.addAttributeProperties(definition, metadata, className, original);
            this.addContentProperty(definition, metadata, element);
            this.addNestedPropertyElements(definition, metadata, className, element);
            this.coerceNamespaceAwarePropertyValues(definition, element);
            this.declareLifecycleMethods(definition, metadata, element);
            this.namedConstructorArgs.processParameters(definition, metadata);
            return definition;
        }
        return null;
    }

    protected void addSpringAttributeValues(String className, Element element) {
        NamedNodeMap attributes = element.getAttributes();
        int size = attributes.getLength();
        for (int i = 0; i < size; ++i) {
            Attr attribute = (Attr)attributes.item(i);
            String uri = attribute.getNamespaceURI();
            String localName = attribute.getLocalName();
            if (uri == null || !uri.equals(SPRING_SCHEMA)) continue;
            element.setAttributeNS(null, localName, attribute.getNodeValue());
        }
    }

    protected Element cloneElement(Element element) {
        Element answer = element.getOwnerDocument().createElement(this.getLocalName(element));
        NamedNodeMap attributes = element.getAttributes();
        int size = attributes.getLength();
        for (int i = 0; i < size; ++i) {
            Attr attribute = (Attr)attributes.item(i);
            String uri = attribute.getNamespaceURI();
            answer.setAttributeNS(uri, attribute.getName(), attribute.getNodeValue());
        }
        return answer;
    }

    protected void addAttributeProperties(BeanDefinitionHolder definition, MappingMetaData metadata, String className, Element element) {
        NamedNodeMap attributes = element.getAttributes();
        int size = attributes.getLength();
        for (int i = 0; i < size; ++i) {
            Attr attribute = (Attr)attributes.item(i);
            String uri = attribute.getNamespaceURI();
            String localName = attribute.getLocalName();
            if (localName == null || localName.equals("xmlns") || localName.startsWith("xmlns:") || !this.isEmpty(uri) || localName.equals("class")) continue;
            boolean addProperty = true;
            if (this.reservedBeanAttributeNames.contains(localName)) {
                PropertyDescriptor descriptor = this.getPropertyDescriptor(className, localName);
                boolean bl = addProperty = descriptor != null;
            }
            if (!addProperty) continue;
            this.addAttributeProperty(definition, metadata, element, attribute);
        }
    }

    protected void addContentProperty(BeanDefinitionHolder definition, MappingMetaData metadata, Element element) {
        String name = metadata.getContentProperty(this.getLocalName(element));
        if (name != null) {
            String value = this.getElementText(element);
            this.addProperty(definition, metadata, element, name, value);
        } else {
            NodeList childNodes = element.getChildNodes();
            if (childNodes.getLength() == 1 && childNodes.item(0) instanceof Text) {
                Text text = (Text)childNodes.item(0);
                ByteArrayInputStream in = new ByteArrayInputStream(text.getData().getBytes());
                Properties properties = new Properties();
                try {
                    properties.load(in);
                }
                catch (IOException e) {
                    return;
                }
                Enumeration<?> enumeration = properties.propertyNames();
                while (enumeration.hasMoreElements()) {
                    name = (String)enumeration.nextElement();
                    String value = properties.getProperty(name);
                    definition.getBeanDefinition().getPropertyValues().addPropertyValue(name, (Object)value);
                }
            }
        }
    }

    protected void addAttributeProperty(BeanDefinitionHolder definition, MappingMetaData metadata, Element element, Attr attribute) {
        String localName = attribute.getName();
        String value = attribute.getValue();
        this.addProperty(definition, metadata, element, localName, value);
    }

    protected void addProperty(BeanDefinitionHolder definition, MappingMetaData metadata, Element element, String localName, String value) {
        if (value != null) {
            boolean reference = false;
            if (value.startsWith(BEAN_REFERENCE_PREFIX) && !(value = value.substring(BEAN_REFERENCE_PREFIX.length())).startsWith(BEAN_REFERENCE_PREFIX)) {
                reference = true;
            }
            if (reference) {
                String propertyName = metadata.getPropertyName(this.getLocalName(element), localName);
                if (propertyName != null) {
                    definition.getBeanDefinition().getPropertyValues().addPropertyValue(propertyName, (Object)new RuntimeBeanReference(value));
                }
            } else {
                String propertyName = metadata.getPropertyName(this.getLocalName(element), localName);
                if (propertyName != null) {
                    definition.getBeanDefinition().getPropertyValues().addPropertyValue(propertyName, (Object)value);
                }
            }
        }
    }

    protected String getLocalName(Element element) {
        String localName = element.getLocalName();
        if (localName == null) {
            localName = element.getNodeName();
        }
        return localName;
    }

    protected void addNestedPropertyElements(BeanDefinitionHolder definition, MappingMetaData metadata, String className, Element element) {
        NodeList nl = element.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            if (!(node instanceof Element)) continue;
            Element childElement = (Element)node;
            String uri = childElement.getNamespaceURI();
            String localName = childElement.getLocalName();
            if (this.isEmpty(uri) && this.reservedElementNames.contains(localName)) continue;
            Object value = null;
            String propertyName = metadata.getNestedListProperty(this.getLocalName(element), localName);
            if (propertyName != null) {
                value = this.parseListElement(childElement, propertyName);
            } else {
                propertyName = metadata.getNestedProperty(this.getLocalName(element), localName);
                if (propertyName != null) {
                    value = this.parseChildExtensionBean(childElement);
                }
            }
            if (propertyName == null) {
                value = this.tryParseNestedPropertyViaIntrospection(metadata, className, childElement);
                propertyName = localName;
            }
            if (value != null) {
                definition.getBeanDefinition().getPropertyValues().addPropertyValue(propertyName, value);
                continue;
            }
            String text = this.getElementText(childElement);
            if (text == null) continue;
            this.addProperty(definition, metadata, element, localName, text);
        }
    }

    protected Object tryParseNestedPropertyViaIntrospection(MappingMetaData metadata, String className, Element element) {
        String localName = this.getLocalName(element);
        PropertyDescriptor descriptor = this.getPropertyDescriptor(className, localName);
        if (descriptor != null) {
            return this.parseNestedPropertyViaIntrospection(metadata, className, element, descriptor);
        }
        return null;
    }

    protected void coerceNamespaceAwarePropertyValues(BeanDefinitionHolder definitionHolder, Element element) {
        AbstractBeanDefinition bd;
        BeanInfo beanInfo;
        BeanDefinition definition = definitionHolder.getBeanDefinition();
        if (definition instanceof AbstractBeanDefinition && this.isQnameIsOnClassPath() && (beanInfo = this.getBeanInfo((bd = (AbstractBeanDefinition)definition).getBeanClassName())) != null) {
            PropertyDescriptor[] descriptors = beanInfo.getPropertyDescriptors();
            for (int i = 0; i < descriptors.length; ++i) {
                QNameReflectionHelper.coerceNamespaceAwarePropertyValues(bd, element, descriptors, i);
            }
        }
    }

    protected boolean isQnameIsOnClassPath() {
        if (!this.initQNameOnClassPath) {
            this.qnameIsOnClassPath = PropertyEditorHelper.loadClass("javax.xml.namespace.QName") != null;
            this.initQNameOnClassPath = true;
        }
        return this.qnameIsOnClassPath;
    }

    protected BeanInfo getBeanInfo(String className) throws BeanDefinitionStoreException {
        if (className == null) {
            return null;
        }
        BeanInfo info = null;
        Class type = null;
        try {
            type = this.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new BeanDefinitionStoreException("Failed to load type: " + className + ". Reason: " + e, (Throwable)e);
        }
        try {
            info = Introspector.getBeanInfo(type);
        }
        catch (IntrospectionException e) {
            throw new BeanDefinitionStoreException("Failed to introspect type: " + className + ". Reason: " + e, (Throwable)e);
        }
        return info;
    }

    protected PropertyDescriptor getPropertyDescriptor(String className, String localName) {
        BeanInfo beanInfo = this.getBeanInfo(className);
        if (beanInfo != null) {
            PropertyDescriptor[] descriptors = beanInfo.getPropertyDescriptors();
            for (int i = 0; i < descriptors.length; ++i) {
                PropertyDescriptor descriptor = descriptors[i];
                String name = descriptor.getName();
                if (!name.equals(localName)) continue;
                return descriptor;
            }
        }
        return null;
    }

    protected Object parseNestedPropertyViaIntrospection(MappingMetaData metadata, String className, Element element, PropertyDescriptor descriptor) {
        String name = descriptor.getName();
        if (this.isCollection(descriptor.getPropertyType())) {
            return this.parseListElement(element, name);
        }
        return this.parseChildExtensionBean(element);
    }

    protected boolean isCollection(Class type) {
        return type.isArray() || (class$java$util$Collection == null ? (class$java$util$Collection = XBeanXmlBeanDefinitionParser.class$("java.util.Collection")) : class$java$util$Collection).isAssignableFrom(type);
    }

    protected Object parseChildExtensionBean(Element element) {
        NodeList nl = element.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            if (!(node instanceof Element)) continue;
            Element childElement = (Element)node;
            String uri = childElement.getNamespaceURI();
            String localName = childElement.getLocalName();
            if (uri == null || uri.equals(SPRING_SCHEMA)) {
                if (!"bean".equals(localName)) continue;
                return this.parseBeanDefinitionElement(childElement, true);
            }
            BeanDefinitionHolder value = this.parseBeanFromExtensionElement(childElement);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    protected MappingMetaData findNamespaceProperties(String namespaceURI, String localName) {
        if (namespaceURI != null && namespaceURI.startsWith(JAVA_PACKAGE_PREFIX)) {
            String packageName = namespaceURI.substring(JAVA_PACKAGE_PREFIX.length());
            return new MappingMetaData(packageName);
        }
        String uri = NamespaceHelper.createDiscoveryPathName(namespaceURI, localName);
        InputStream in = this.loadResource(uri);
        if (in == null && namespaceURI != null && namespaceURI.length() > 0) {
            uri = NamespaceHelper.createDiscoveryPathName(namespaceURI);
            in = this.loadResource(uri);
        }
        if (in != null) {
            try {
                Properties properties = new Properties();
                properties.load(in);
                return new MappingMetaData(properties);
            }
            catch (IOException e) {
                log.warn((Object)("Failed to load resource from uri: " + uri), (Throwable)e);
            }
        }
        return null;
    }

    protected InputStream loadResource(String uri) {
        InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(uri);
        if (in == null && (in = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(uri)) == null) {
            this.logger.debug((Object)("Could not find resource: " + uri));
        }
        return in;
    }

    protected Class loadClass(String name) throws ClassNotFoundException {
        ClassLoader contextClassLoader;
        ClassLoader beanClassLoader = this.getBeanDefinitionReader().getBeanClassLoader();
        if (beanClassLoader != null) {
            try {
                return beanClassLoader.loadClass(name);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        if ((contextClassLoader = Thread.currentThread().getContextClassLoader()) != null) {
            try {
                return contextClassLoader.loadClass(name);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        return ((Object)((Object)this)).getClass().getClassLoader().loadClass(name);
    }

    protected boolean isEmpty(String uri) {
        return uri == null || uri.length() == 0;
    }

    protected void declareLifecycleMethods(BeanDefinitionHolder definitionHolder, MappingMetaData metaData, Element element) {
        BeanDefinition definition = definitionHolder.getBeanDefinition();
        if (definition instanceof AbstractBeanDefinition) {
            AbstractBeanDefinition beanDefinition = (AbstractBeanDefinition)definition;
            if (beanDefinition.getInitMethodName() == null) {
                beanDefinition.setInitMethodName(metaData.getInitMethodName(this.getLocalName(element)));
            }
            if (beanDefinition.getDestroyMethodName() == null) {
                beanDefinition.setDestroyMethodName(metaData.getDestroyMethodName(this.getLocalName(element)));
            }
            if (beanDefinition.getFactoryMethodName() == null) {
                beanDefinition.setFactoryMethodName(metaData.getFactoryMethodName(this.getLocalName(element)));
            }
        }
    }

    protected int parseBeanDefinitions(Element root) throws BeanDefinitionStoreException {
        int beanDefinitionCount = 0;
        if (this.isEmpty(root.getNamespaceURI()) || root.getLocalName().equals("beans")) {
            NodeList nl = root.getChildNodes();
            for (int i = 0; i < nl.getLength(); ++i) {
                BeanDefinitionHolder bdHolder;
                Node node = nl.item(i);
                if (!(node instanceof Element)) continue;
                Element ele = (Element)node;
                if ("import".equals(node.getNodeName())) {
                    this.importBeanDefinitionResource(ele);
                    continue;
                }
                if ("alias".equals(node.getNodeName())) {
                    String name = ele.getAttribute("name");
                    String alias = ele.getAttribute("alias");
                    this.getBeanDefinitionReader().getBeanFactory().registerAlias(name, alias);
                    continue;
                }
                if ("bean".equals(node.getNodeName())) {
                    ++beanDefinitionCount;
                    bdHolder = this.parseBeanDefinitionElement(ele, false);
                    BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)bdHolder, (BeanDefinitionRegistry)this.getBeanDefinitionReader().getBeanFactory());
                    continue;
                }
                bdHolder = this.parseBeanFromExtensionElement(ele);
                if (bdHolder != null) {
                    ++beanDefinitionCount;
                    BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)bdHolder, (BeanDefinitionRegistry)this.getBeanDefinitionReader().getBeanFactory());
                    continue;
                }
                log.debug((Object)("Ignoring unknown element namespace: " + ele.getNamespaceURI() + " localName: " + ele.getLocalName()));
            }
        } else {
            BeanDefinitionHolder bdHolder = this.parseBeanFromExtensionElement(root);
            if (bdHolder != null) {
                ++beanDefinitionCount;
                BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)bdHolder, (BeanDefinitionRegistry)this.getBeanDefinitionReader().getBeanFactory());
            } else {
                log.debug((Object)("Ignoring unknown element namespace: " + root.getNamespaceURI() + " localName: " + root.getLocalName()));
            }
        }
        return beanDefinitionCount;
    }

    protected BeanDefinitionHolder parseBeanDefinitionElement(Element ele, boolean isInnerBean) throws BeanDefinitionStoreException {
        BeanDefinitionHolder bdh = super.parseBeanDefinitionElement(ele, isInnerBean);
        this.coerceNamespaceAwarePropertyValues(bdh, ele);
        return bdh;
    }

    protected Object parsePropertySubElement(Element element, String beanName) throws BeanDefinitionStoreException {
        BeanDefinitionHolder answer;
        String uri = element.getNamespaceURI();
        String localName = this.getLocalName(element);
        if (!(this.isEmpty(uri) && this.reservedElementNames.contains(localName) || (answer = this.parseBeanFromExtensionElement(element)) == null)) {
            return answer;
        }
        return super.parsePropertySubElement(element, beanName);
    }

    protected String getElementText(Element element) {
        StringBuffer buffer = new StringBuffer();
        NodeList nodeList = element.getChildNodes();
        int size = nodeList.getLength();
        for (int i = 0; i < size; ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 3) continue;
            buffer.append(node.getNodeValue());
        }
        return buffer.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        PropertyEditorHelper.registerCustomEditors();
        log = LogFactory.getLog((Class)(class$org$xbean$spring$context$impl$XBeanXmlBeanDefinitionParser == null ? (class$org$xbean$spring$context$impl$XBeanXmlBeanDefinitionParser = XBeanXmlBeanDefinitionParser.class$("org.xbean.spring.context.impl.XBeanXmlBeanDefinitionParser")) : class$org$xbean$spring$context$impl$XBeanXmlBeanDefinitionParser));
        RESERVED_ELEMENT_NAMES = new String[]{"beans", "description", "import", "alias", "bean", "constructor-arg", "property", "lookup-method", "replaced-method", "arg-type", "ref", "idref", "value", "null", "list", "set", "map", "entry", "key", "props", "prop"};
        RESERVED_BEAN_ATTRIBUTE_NAMES = new String[]{"id", "name", "class", "parent", "depends-on", "factory-method", "factory-bean", "dependency-check", "autowire", "init-method", "destroy-method", "abstract", "singleton", "lazy-init"};
    }
}

