/*
 * Decompiled with CFR 0.152.
 */
package vip.justlive.oxygen.ioc;

import java.lang.reflect.Constructor;
import java.lang.reflect.Parameter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vip.justlive.oxygen.core.Plugin;
import vip.justlive.oxygen.core.config.ConfigFactory;
import vip.justlive.oxygen.core.exception.Exceptions;
import vip.justlive.oxygen.core.scan.ClassScannerPlugin;
import vip.justlive.oxygen.core.util.ClassUtils;
import vip.justlive.oxygen.core.util.ServiceLoaderUtils;
import vip.justlive.oxygen.ioc.annotation.Bean;
import vip.justlive.oxygen.ioc.annotation.Inject;
import vip.justlive.oxygen.ioc.annotation.Named;
import vip.justlive.oxygen.ioc.store.BeanProxy;
import vip.justlive.oxygen.ioc.store.BeanStore;
import vip.justlive.oxygen.ioc.store.DefaultBeanProxy;
import vip.justlive.oxygen.ioc.store.DefaultBeanStore;

public class IocPlugin
implements Plugin {
    private static final Logger log = LoggerFactory.getLogger(IocPlugin.class);
    private static final BeanStore BEAN_STORE = new DefaultBeanStore();
    private static final BeanProxy BEAN_PROXY;

    public static BeanStore beanStore() {
        return BEAN_STORE;
    }

    public static BeanProxy beanProxy() {
        return BEAN_PROXY;
    }

    public int order() {
        return -2147483638;
    }

    public void start() {
        this.ioc();
    }

    public void stop() {
        BEAN_STORE.clean();
    }

    private void ioc() {
        Set beanClasses = ClassScannerPlugin.getTypesAnnotatedWith(Bean.class);
        HashMap iocMap = new HashMap(8);
        for (Class clazz : beanClasses) {
            Bean bean;
            if (clazz.isInterface() || (bean = (Bean)ClassUtils.getAnnotation((Class)clazz, Bean.class)) == null) continue;
            String beanName = bean.value();
            if (beanName.length() == 0) {
                beanName = clazz.getName();
            }
            this.tryInstance(clazz, beanName, bean.order(), iocMap);
        }
        int count = iocMap.size();
        while (count > 0) {
            this.reIoc(iocMap);
            if (count == iocMap.size()) {
                if (log.isDebugEnabled()) {
                    log.debug("ioc\u5931\u8d25 \u51fa\u73b0\u5faa\u73af\u4f9d\u8d56\u6216\u7f3a\u5931Bean fail-ioc-map {}", iocMap);
                }
                throw Exceptions.fail((String)"\u53d1\u751f\u5faa\u73af\u4f9d\u8d56\u6216\u8005\u7f3a\u5931Bean ");
            }
            count = iocMap.size();
        }
    }

    private static boolean tryInstance(Class<?> clazz, String beanName, int order) {
        Constructor<?> constructor = IocPlugin.getConstructor(clazz);
        if (constructor != null) {
            Object bean = IocPlugin.dependencyInstance(clazz, constructor);
            if (bean == null) {
                return false;
            }
            ConfigFactory.load((Object)bean);
            BEAN_STORE.addBean(beanName, bean, order);
            return true;
        }
        Object bean = BEAN_PROXY.proxy(clazz, new Object[0]);
        ConfigFactory.load((Object)bean);
        BEAN_STORE.addBean(beanName, bean, order);
        return true;
    }

    private void tryInstance(Class<?> clazz, String beanName, int order, Map<Class<?>, ClassInfo> iocMap) {
        if (!IocPlugin.tryInstance(clazz, beanName, order)) {
            iocMap.put(clazz, new ClassInfo(beanName, IocPlugin.getConstructor(clazz), order));
        }
    }

    private static Constructor<?> getConstructor(Class<?> clazz) {
        Constructor[] constructors = clazz.getConstructors();
        Constructor constructor = constructors.length == 1 ? constructors[0] : ClassUtils.getConstructorAnnotatedWith((Constructor[])constructors, Inject.class);
        return constructor;
    }

    private static Object dependencyInstance(Class<?> clazz, Constructor<?> constructor) {
        Parameter[] params = constructor.getParameters();
        Object[] args = new Object[params.length];
        for (int i = 0; i < params.length; ++i) {
            args[i] = params[i].isAnnotationPresent(Named.class) ? BEAN_STORE.getBean(params[i].getAnnotation(Named.class).value()) : BEAN_STORE.getBean(params[i].getType());
            if (args[i] != null) continue;
            return null;
        }
        return BEAN_PROXY.proxy(clazz, args);
    }

    private void reIoc(Map<Class<?>, ClassInfo> iocMap) {
        Iterator<Map.Entry<Class<?>, ClassInfo>> it = iocMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Class<?>, ClassInfo> entry = it.next();
            ClassInfo classInfo = entry.getValue();
            Object bean = IocPlugin.dependencyInstance(entry.getKey(), classInfo.constructor);
            if (bean == null) continue;
            ConfigFactory.load((Object)bean);
            BEAN_STORE.addBean(classInfo.name, bean, classInfo.order);
            it.remove();
        }
    }

    static {
        List list = ServiceLoaderUtils.loadServices(BeanProxy.class);
        if (list.isEmpty()) {
            BEAN_PROXY = new DefaultBeanProxy();
        } else {
            Collections.sort(list);
            BEAN_PROXY = (BeanProxy)list.get(0);
        }
    }

    private static class ClassInfo {
        final String name;
        final Constructor<?> constructor;
        final int order;

        ClassInfo(String name, Constructor<?> constructor, int order) {
            this.name = name;
            this.constructor = constructor;
            this.order = order;
        }

        public String toString() {
            return String.format("[name=%s, %s]", this.name, this.constructor);
        }
    }
}

