/*
 * Decompiled with CFR 0.152.
 */
package us.codecraft.webmagic.processor;

import java.util.List;
import us.codecraft.webmagic.Page;
import us.codecraft.webmagic.Site;
import us.codecraft.webmagic.processor.PageProcessor;

public class SimplePageProcessor
implements PageProcessor {
    private String urlPattern;
    private Site site = Site.me();

    public SimplePageProcessor(String urlPattern) {
        this.urlPattern = "(" + urlPattern.replace(".", "\\.").replace("*", "[^\"'#]*") + ")";
    }

    @Override
    public void process(Page page) {
        List<String> requests = page.getHtml().links().regex(this.urlPattern).all();
        page.addTargetRequests(requests);
        page.putField("title", page.getHtml().xpath("//title"));
        page.putField("html", page.getHtml().toString());
        page.putField("content", page.getHtml().smartContent());
    }

    @Override
    public Site getSite() {
        return this.site;
    }
}

