/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.io.lzma;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.junit.Assert;
import org.junit.Test;
import uk.org.retep.util.io.lzma.Decoder;
import uk.org.retep.util.io.lzma.Encoder;
import uk.org.retep.util.monitor.ProgressListener;
import uk.org.retep.util.monitor.ProgressListenerAdaptor;

public class LZMATest {
    private static final int NUM_BENCHMARK_PASSES = 10;
    private static final int DICTIONARY_SIZE = 0x200000;
    private static int[] Table = new int[256];
    static final int kAdditionalSize = 0x200000;
    static final int kCompressedAdditionalSize = 1024;
    static final int kSubBits = 8;

    @Test
    public void testBenchmark() throws IOException {
        LZMATest.lzmaBenchmark(10, 0x200000);
    }

    static int getLogSize(int size) {
        for (int i = 8; i < 32; ++i) {
            for (int j = 0; j < 256; ++j) {
                if (size > (1 << i) + (j << i - 8)) continue;
                return (i << 8) + j;
            }
        }
        return 8192;
    }

    static long myMultDiv64(long value, long elapsedTime) {
        long freq = 1000L;
        long elTime = elapsedTime;
        while (freq > 1000000L) {
            freq >>>= 1;
            elTime >>>= 1;
        }
        if (elTime == 0L) {
            elTime = 1L;
        }
        return value * freq / elTime;
    }

    static long getCompressRating(int dictionarySize, long elapsedTime, long size) {
        long t = LZMATest.getLogSize(dictionarySize) - 4608;
        long numCommandsForOne = 1060L + (t * t * 10L >> 16);
        long numCommands = size * numCommandsForOne;
        return LZMATest.myMultDiv64(numCommands, elapsedTime);
    }

    static long getDecompressRating(long elapsedTime, long outSize, long inSize) {
        long numCommands = inSize * 220L + outSize * 20L;
        return LZMATest.myMultDiv64(numCommands, elapsedTime);
    }

    static long getTotalRating(int dictionarySize, long elapsedTimeEn, long sizeEn, long elapsedTimeDe, long inSizeDe, long outSizeDe) {
        return (LZMATest.getCompressRating(dictionarySize, elapsedTimeEn, sizeEn) + LZMATest.getDecompressRating(elapsedTimeDe, inSizeDe, outSizeDe)) / 2L;
    }

    static void printValue(long v) {
        String s = "";
        s = s + v;
        int i = 0;
        while (i + s.length() < 6) {
            System.out.print(" ");
            ++i;
        }
        System.out.print(s);
    }

    static void printRating(long rating) {
        LZMATest.printValue(rating / 1000000L);
        System.out.print(" MIPS");
    }

    static void printResults(int dictionarySize, long elapsedTime, long size, boolean decompressMode, long secondSize) {
        long speed = LZMATest.myMultDiv64(size, elapsedTime);
        LZMATest.printValue(speed / 1024L);
        System.out.print(" KB/s  ");
        long rating = decompressMode ? LZMATest.getDecompressRating(elapsedTime, size, secondSize) : LZMATest.getCompressRating(dictionarySize, elapsedTime, size);
        LZMATest.printRating(rating);
    }

    public static int lzmaBenchmark(int numIterations, int dictionarySize) throws IOException {
        if (numIterations <= 0) {
            return 0;
        }
        if (dictionarySize < 262144) {
            Assert.fail((String)"Error: dictionary size for benchmark must be >= 18 (256 KB)");
        }
        System.out.println("\n       Compressing                Decompressing\n");
        Encoder encoder = new Encoder();
        Decoder decoder = new Decoder();
        if (!encoder.setDictionarySize(dictionarySize)) {
            Assert.fail((String)"Incorrect dictionary size");
        }
        int kBufferSize = dictionarySize + 0x200000;
        int kCompressedBufferSize = kBufferSize / 2 + 1024;
        ByteArrayOutputStream propStream = new ByteArrayOutputStream();
        encoder.writeCoderProperties((OutputStream)propStream);
        byte[] propArray = propStream.toByteArray();
        decoder.setDecoderProperties(propArray);
        BenchRandomGenerator rg = new BenchRandomGenerator();
        rg.set(kBufferSize);
        rg.generate();
        CRC crc = new CRC();
        crc.Init();
        crc.Update(rg.Buffer, 0, rg.BufferSize);
        ProgressInfo progressInfo = new ProgressInfo();
        progressInfo.ApprovedStart = dictionarySize;
        long totalBenchSize = 0L;
        long totalEncodeTime = 0L;
        long totalDecodeTime = 0L;
        long totalCompressedSize = 0L;
        MyInputStream inStream = new MyInputStream(rg.Buffer, rg.BufferSize);
        byte[] compressedBuffer = new byte[kCompressedBufferSize];
        MyOutputStream compressedStream = new MyOutputStream(compressedBuffer);
        CrcOutStream crcOutStream = new CrcOutStream();
        MyInputStream inputCompressedStream = null;
        int compressedSize = 0;
        for (int i = 0; i < numIterations; ++i) {
            progressInfo.Init();
            inStream.reset();
            compressedStream.reset();
            encoder.code((InputStream)inStream, (OutputStream)compressedStream, -1L, -1L, (ProgressListener)progressInfo);
            long encodeTime = System.currentTimeMillis() - progressInfo.Time;
            if (i == 0) {
                compressedSize = compressedStream.size();
                inputCompressedStream = new MyInputStream(compressedBuffer, compressedSize);
            } else if (compressedSize != compressedStream.size()) {
                Assert.fail((String)"Encoding error");
            }
            if (progressInfo.InSize == 0L) {
                Assert.fail((String)"Internal ERROR 1282");
            }
            long decodeTime = 0L;
            for (int j = 0; j < 2; ++j) {
                inputCompressedStream.reset();
                crcOutStream.init();
                long outSize = kBufferSize;
                long startTime = System.currentTimeMillis();
                if (!decoder.code((InputStream)inputCompressedStream, (OutputStream)crcOutStream, outSize)) {
                    Assert.fail((String)"Decoding Error");
                }
                decodeTime = System.currentTimeMillis() - startTime;
                if (crcOutStream.getDigest() == crc.GetDigest()) continue;
                Assert.fail((String)"CRC Error");
            }
            long benchSize = (long)kBufferSize - progressInfo.InSize;
            LZMATest.printResults(dictionarySize, encodeTime, benchSize, false, 0L);
            System.out.print("     ");
            LZMATest.printResults(dictionarySize, decodeTime, kBufferSize, true, compressedSize);
            System.out.println();
            totalBenchSize += benchSize;
            totalEncodeTime += encodeTime;
            totalDecodeTime += decodeTime;
            totalCompressedSize += (long)compressedSize;
        }
        System.out.println("---------------------------------------------------");
        LZMATest.printResults(dictionarySize, totalEncodeTime, totalBenchSize, false, 0L);
        System.out.print("     ");
        LZMATest.printResults(dictionarySize, totalDecodeTime, (long)kBufferSize * (long)numIterations, true, totalCompressedSize);
        System.out.println("    Average");
        return 0;
    }

    static {
        for (int i = 0; i < 256; ++i) {
            int r = i;
            for (int j = 0; j < 8; ++j) {
                if ((r & 1) != 0) {
                    r = r >>> 1 ^ 0xEDB88320;
                    continue;
                }
                r >>>= 1;
            }
            LZMATest.Table[i] = r;
        }
    }

    static class ProgressInfo
    extends ProgressListenerAdaptor {
        public long ApprovedStart;
        public long InSize;
        public long Time;

        ProgressInfo() {
        }

        public void Init() {
            this.InSize = 0L;
        }

        public void showProgress(long inSize, long outSize) {
            if (inSize >= this.ApprovedStart && this.InSize == 0L) {
                this.Time = System.currentTimeMillis();
                this.InSize = inSize;
            }
        }
    }

    static class MyInputStream
    extends InputStream {
        byte[] _buffer;
        int _size;
        int _pos;

        public MyInputStream(byte[] buffer, int size) {
            this._buffer = buffer;
            this._size = size;
        }

        @Override
        public void reset() {
            this._pos = 0;
        }

        @Override
        public int read() {
            if (this._pos >= this._size) {
                return -1;
            }
            return this._buffer[this._pos++] & 0xFF;
        }
    }

    static class MyOutputStream
    extends OutputStream {
        byte[] _buffer;
        int _size;
        int _pos;

        public MyOutputStream(byte[] buffer) {
            this._buffer = buffer;
            this._size = this._buffer.length;
        }

        public void reset() {
            this._pos = 0;
        }

        @Override
        public void write(int b) throws IOException {
            if (this._pos >= this._size) {
                throw new IOException("Error");
            }
            this._buffer[this._pos++] = (byte)b;
        }

        public int size() {
            return this._pos;
        }
    }

    static class CrcOutStream
    extends OutputStream {
        public CRC CRC = new CRC();

        CrcOutStream() {
        }

        public void init() {
            this.CRC.Init();
        }

        public int getDigest() {
            return this.CRC.GetDigest();
        }

        @Override
        public void write(byte[] b) {
            this.CRC.Update(b);
        }

        @Override
        public void write(byte[] b, int off, int len) {
            this.CRC.Update(b, off, len);
        }

        @Override
        public void write(int b) {
            this.CRC.UpdateByte(b);
        }
    }

    private static class BenchRandomGenerator {
        BitRandomGenerator RG = new BitRandomGenerator();
        int Pos;
        int Rep0;
        public int BufferSize;
        public byte[] Buffer = null;

        public void set(int bufferSize) {
            this.Buffer = new byte[bufferSize];
            this.Pos = 0;
            this.BufferSize = bufferSize;
        }

        int getRandomBit() {
            return this.RG.getRandom(1);
        }

        int getLogRandomBits(int numBits) {
            int len = this.RG.getRandom(numBits);
            return this.RG.getRandom(len);
        }

        int getOffset() {
            if (this.getRandomBit() == 0) {
                return this.getLogRandomBits(4);
            }
            return this.getLogRandomBits(4) << 10 | this.RG.getRandom(10);
        }

        int getLen1() {
            return this.RG.getRandom(1 + this.RG.getRandom(2));
        }

        int getLen2() {
            return this.RG.getRandom(2 + this.RG.getRandom(2));
        }

        public void generate() {
            this.RG.init();
            this.Rep0 = 1;
            while (this.Pos < this.BufferSize) {
                int len;
                if (this.getRandomBit() == 0 || this.Pos < 1) {
                    this.Buffer[this.Pos++] = (byte)this.RG.getRandom(8);
                    continue;
                }
                if (this.RG.getRandom(3) == 0) {
                    len = 1 + this.getLen1();
                } else {
                    do {
                        this.Rep0 = this.getOffset();
                    } while (this.Rep0 >= this.Pos);
                    ++this.Rep0;
                    len = 2 + this.getLen2();
                }
                int i = 0;
                while (i < len && this.Pos < this.BufferSize) {
                    this.Buffer[this.Pos] = this.Buffer[this.Pos - this.Rep0];
                    ++i;
                    ++this.Pos;
                }
            }
        }
    }

    private static class BitRandomGenerator {
        RandomGenerator RG = new RandomGenerator();
        int Value;
        int NumBits;

        private BitRandomGenerator() {
        }

        public void init() {
            this.Value = 0;
            this.NumBits = 0;
        }

        public int getRandom(int numBits) {
            if (this.NumBits > numBits) {
                int result = this.Value & (1 << numBits) - 1;
                this.Value >>>= numBits;
                this.NumBits -= numBits;
                return result;
            }
            int result = this.Value << (numBits -= this.NumBits);
            this.Value = this.RG.getRandom();
            this.Value >>>= numBits;
            this.NumBits = 32 - numBits;
            return result |= this.Value & (1 << numBits) - 1;
        }
    }

    private static class RandomGenerator {
        int A1;
        int A2;

        public RandomGenerator() {
            this.init();
        }

        public void init() {
            this.A1 = 362436069;
            this.A2 = 521288629;
        }

        public int getRandom() {
            this.A1 = 36969 * (this.A1 & 0xFFFF) + (this.A1 >>> 16);
            this.A2 = 18000 * (this.A2 & 0xFFFF) + (this.A2 >>> 16);
            return this.A1 << 16 ^ this.A2;
        }
    }

    private static class CRC {
        int _value = -1;

        private CRC() {
        }

        public void Init() {
            this._value = -1;
        }

        public void Update(byte[] data, int offset, int size) {
            for (int i = 0; i < size; ++i) {
                this._value = Table[(this._value ^ data[offset + i]) & 0xFF] ^ this._value >>> 8;
            }
        }

        public void Update(byte[] data) {
            int size = data.length;
            for (int i = 0; i < size; ++i) {
                this._value = Table[(this._value ^ data[i]) & 0xFF] ^ this._value >>> 8;
            }
        }

        public void UpdateByte(int b) {
            this._value = Table[(this._value ^ b) & 0xFF] ^ this._value >>> 8;
        }

        public int GetDigest() {
            return ~this._value;
        }
    }
}

