/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.io.bzip2;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;
import uk.org.retep.util.io.FileUtils;
import uk.org.retep.util.io.bzip2.BZip2InputStream;
import uk.org.retep.util.io.bzip2.BZip2OutputStream;
import uk.org.retep.util.monitor.BandwidthProgressListener;

public class BZip2BandwidthTest {
    private static final int ITTERATIONS = 10;

    private byte[] generateData() {
        Random r = new Random();
        byte[] b = new byte[0x200000];
        r.nextBytes(b);
        return b;
    }

    @Test
    public void testBandwidth() throws IOException {
        BandwidthProgressListener listener = new BandwidthProgressListener();
        System.out.println("\n            Compressing                       Decompressing\n\n");
        long totalCdur = 0L;
        long totalClen = 0L;
        long totalDdur = 0L;
        long totalDlen = 0L;
        for (int i = 0; i < 10; ++i) {
            listener.reset();
            byte[] src = this.generateData();
            long writeStart = System.currentTimeMillis();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            BZip2OutputStream bos = new BZip2OutputStream((OutputStream)baos);
            bos.write(src);
            bos.flush();
            bos.close();
            long writeEnd = System.currentTimeMillis();
            byte[] comp = baos.toByteArray();
            long readStart = System.currentTimeMillis();
            ByteArrayInputStream bais = new ByteArrayInputStream(comp);
            BZip2InputStream bis = new BZip2InputStream((InputStream)bais);
            byte[] dst = FileUtils.readBytes((InputStream)bis);
            long readEnd = System.currentTimeMillis();
            long writeDur = writeEnd - writeStart;
            long readDur = readEnd - readStart;
            this.writeOut(writeDur, src.length);
            this.writeOut(readDur, comp.length);
            System.out.println();
            totalCdur += writeDur;
            totalClen += (long)src.length;
            totalDdur += readDur;
            totalDlen += (long)comp.length;
            Assert.assertEquals((String)"Decompressed size missmatch", (long)src.length, (long)dst.length);
            for (int j = 0; j < src.length; ++j) {
                Assert.assertEquals((String)("arys missmatch index " + j), (long)src[j], (long)dst[j]);
            }
        }
        System.out.println("--------------------------------------------------------------------");
        this.writeOut(totalCdur / 10L, totalClen / 10L);
        this.writeOut(totalDdur / 10L, totalDlen / 10L);
        System.out.println();
    }

    private void writeOut(long dur, long len) {
        System.out.printf(" %6.2f s %6d KB/s %8.1f KB ", (double)dur / 1000.0, BandwidthProgressListener.getKBs((long)len, (long)dur), (double)len / 1024.0);
    }
}

