/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Random;
import java.util.zip.DeflaterOutputStream;
import org.junit.Test;
import uk.org.retep.util.io.bzip2.BZip2OutputStream;
import uk.org.retep.util.monitor.BandwidthProgressListener;

public class CompressionTest {
    private static final int ITTERATIONS = 10;
    private static final String KBS = " %8.1f KB ";
    private static final String COMPSIZE = " Source Size ";
    private static final String COMPSEP = "------------";

    private byte[] generateData() {
        Random r = new Random();
        byte[] b = new byte[0x200000];
        r.nextBytes(b);
        for (int i = 0; i < b.length; ++i) {
            int n = i;
            b[n] = (byte)(b[n] & 0x7F);
            if (b[i] >= 32) continue;
            int n2 = i;
            b[n2] = (byte)(b[n2] + 32);
        }
        return b;
    }

    @Test
    public void testBandwidth() throws IOException {
        int i;
        String separator = "---------------------------------------------------------------------------------------------------------------------";
        System.out.println("\n            |------------ GZip ----------------|----------- BZip2 ----------------|------------ LZMA ----------------|\n Source Size    Time    Bandwidth     Output       Time    Bandwidth     Output       Time    Bandwidth     Output    \n---------------------------------------------------------------------------------------------------------------------");
        long[][] results = new long[2][];
        for (int i2 = 0; i2 < results.length; ++i2) {
            results[i2] = new long[4];
        }
        long totalsize = 0L;
        for (i = 0; i < 10; ++i) {
            byte[] src = this.generateData();
            totalsize += (long)src.length;
            this.gzip(src, results[0]);
            this.bzip2(src, results[1]);
            System.out.printf(KBS, (double)src.length / 1024.0);
            for (int j = 0; j < results.length; ++j) {
                System.out.printf(" %6.2f s %6d KB/s %8.1f KB ", (double)results[j][0] / 1000.0, BandwidthProgressListener.getKBs((long)src.length, (long)results[j][0]), (double)results[j][1] / 1000.0);
            }
            System.out.println();
        }
        System.out.println("---------------------------------------------------------------------------------------------------------------------");
        System.out.printf(KBS, (double)totalsize / 1024.0);
        for (i = 0; i < results.length; ++i) {
            System.out.printf(" %6.2f s %6d KB/s %8.1f KB ", (double)results[i][2] / 1000.0, BandwidthProgressListener.getKBs((long)totalsize, (long)results[i][3]), (double)results[i][3] / 1000.0);
        }
        System.out.println();
        System.out.println("---------------------------------------------------------------------------------------------------------------------");
        System.out.println();
    }

    private void runTest(byte[] src, long[] results, ByteArrayOutputStream baos, OutputStream os) throws IOException {
        long start = System.currentTimeMillis();
        os.write(src);
        os.flush();
        os.close();
        results[0] = System.currentTimeMillis() - start;
        results[1] = baos.size();
        results[2] = results[2] + results[0];
        results[3] = results[3] + results[1];
    }

    private void gzip(byte[] src, long[] results) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DeflaterOutputStream os = new DeflaterOutputStream(baos);
        this.runTest(src, results, baos, os);
    }

    private void bzip2(byte[] src, long[] results) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BZip2OutputStream os = new BZip2OutputStream((OutputStream)baos);
        this.runTest(src, results, baos, (OutputStream)os);
    }

    private void lzma(byte[] src, long[] results) throws IOException {
    }
}

