/*
 * Decompiled with CFR 0.152.
 */
package tk.mybatis.mapper.entity;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import tk.mybatis.mapper.MapperException;
import tk.mybatis.mapper.code.IdentityDialect;
import tk.mybatis.mapper.code.Style;
import tk.mybatis.mapper.mapperhelper.resolve.EntityResolve;
import tk.mybatis.mapper.util.SimpleTypeUtil;
import tk.mybatis.mapper.util.StringUtil;

public class Config {
    public static final String PREFIX = "mapper";
    private List<Class> mappers = new ArrayList<Class>();
    private String IDENTITY;
    private boolean BEFORE;
    private String seqFormat;
    private String catalog;
    private String schema;
    private boolean checkExampleEntityClass;
    private boolean useSimpleType = true;
    private boolean enumAsSimpleType;
    private boolean enableMethodAnnotation;
    private boolean notEmpty;
    private Style style;
    private String wrapKeyword = "";
    private Class<? extends EntityResolve> resolveClass;
    private boolean safeDelete;
    private boolean safeUpdate;
    private boolean useJavaType;

    public String getCatalog() {
        return this.catalog;
    }

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    public String getIDENTITY() {
        if (StringUtil.isNotEmpty(this.IDENTITY)) {
            return this.IDENTITY;
        }
        return IdentityDialect.MYSQL.getIdentityRetrievalStatement();
    }

    public void setIDENTITY(String IDENTITY) {
        IdentityDialect identityDialect = IdentityDialect.getDatabaseDialect(IDENTITY);
        this.IDENTITY = identityDialect != null ? identityDialect.getIdentityRetrievalStatement() : IDENTITY;
    }

    public String getPrefix() {
        if (StringUtil.isNotEmpty(this.catalog)) {
            return this.catalog;
        }
        if (StringUtil.isNotEmpty(this.schema)) {
            return this.schema;
        }
        return "";
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public String getSeqFormat() {
        if (StringUtil.isNotEmpty(this.seqFormat)) {
            return this.seqFormat;
        }
        return "{0}.nextval";
    }

    public void setSeqFormat(String seqFormat) {
        this.seqFormat = seqFormat;
    }

    public Style getStyle() {
        return this.style == null ? Style.camelhump : this.style;
    }

    public void setStyle(Style style) {
        this.style = style;
    }

    public String getWrapKeyword() {
        return this.wrapKeyword;
    }

    public void setWrapKeyword(String wrapKeyword) {
        this.wrapKeyword = wrapKeyword;
    }

    public boolean isBEFORE() {
        return this.BEFORE;
    }

    public void setBEFORE(boolean BEFORE) {
        this.BEFORE = BEFORE;
    }

    public boolean isCheckExampleEntityClass() {
        return this.checkExampleEntityClass;
    }

    public void setCheckExampleEntityClass(boolean checkExampleEntityClass) {
        this.checkExampleEntityClass = checkExampleEntityClass;
    }

    public boolean isEnableMethodAnnotation() {
        return this.enableMethodAnnotation;
    }

    public void setEnableMethodAnnotation(boolean enableMethodAnnotation) {
        this.enableMethodAnnotation = enableMethodAnnotation;
    }

    public boolean isEnumAsSimpleType() {
        return this.enumAsSimpleType;
    }

    public void setEnumAsSimpleType(boolean enumAsSimpleType) {
        this.enumAsSimpleType = enumAsSimpleType;
    }

    public boolean isNotEmpty() {
        return this.notEmpty;
    }

    public void setNotEmpty(boolean notEmpty) {
        this.notEmpty = notEmpty;
    }

    public boolean isUseSimpleType() {
        return this.useSimpleType;
    }

    public void setUseSimpleType(boolean useSimpleType) {
        this.useSimpleType = useSimpleType;
    }

    public void setOrder(String order) {
        this.BEFORE = "BEFORE".equalsIgnoreCase(order);
    }

    public String getIdentity() {
        return this.getIDENTITY();
    }

    public void setIdentity(String identity) {
        this.setIDENTITY(identity);
    }

    public List<Class> getMappers() {
        return this.mappers;
    }

    public void setMappers(List<Class> mappers) {
        this.mappers = mappers;
    }

    public boolean isBefore() {
        return this.isBEFORE();
    }

    public void setBefore(boolean before) {
        this.setBEFORE(before);
    }

    public Class<? extends EntityResolve> getResolveClass() {
        return this.resolveClass;
    }

    public void setResolveClass(Class<? extends EntityResolve> resolveClass) {
        this.resolveClass = resolveClass;
    }

    public boolean isSafeDelete() {
        return this.safeDelete;
    }

    public void setSafeDelete(boolean safeDelete) {
        this.safeDelete = safeDelete;
    }

    public boolean isSafeUpdate() {
        return this.safeUpdate;
    }

    public void setSafeUpdate(boolean safeUpdate) {
        this.safeUpdate = safeUpdate;
    }

    public boolean isUseJavaType() {
        return this.useJavaType;
    }

    public void setUseJavaType(boolean useJavaType) {
        this.useJavaType = useJavaType;
    }

    public void setProperties(Properties properties) {
        String styleStr;
        String ORDER2;
        String schema;
        String catalog;
        String seqFormat;
        if (properties == null) {
            this.style = Style.camelhump;
            return;
        }
        String IDENTITY = properties.getProperty("IDENTITY");
        if (StringUtil.isNotEmpty(IDENTITY)) {
            this.setIDENTITY(IDENTITY);
        }
        if (StringUtil.isNotEmpty(seqFormat = properties.getProperty("seqFormat"))) {
            this.setSeqFormat(seqFormat);
        }
        if (StringUtil.isNotEmpty(catalog = properties.getProperty("catalog"))) {
            this.setCatalog(catalog);
        }
        if (StringUtil.isNotEmpty(schema = properties.getProperty("schema"))) {
            this.setSchema(schema);
        }
        if (StringUtil.isNotEmpty(ORDER2 = properties.getProperty("ORDER"))) {
            this.setOrder(ORDER2);
        }
        if (StringUtil.isNotEmpty(ORDER2 = properties.getProperty("order"))) {
            this.setOrder(ORDER2);
        }
        if (StringUtil.isNotEmpty(ORDER2 = properties.getProperty("before"))) {
            this.setBefore(Boolean.valueOf(ORDER2));
        }
        this.notEmpty = Boolean.valueOf(properties.getProperty("notEmpty"));
        this.enableMethodAnnotation = Boolean.valueOf(properties.getProperty("enableMethodAnnotation"));
        this.checkExampleEntityClass = Boolean.valueOf(properties.getProperty("checkExampleEntityClass"));
        String useSimpleTypeStr = properties.getProperty("useSimpleType");
        if (StringUtil.isNotEmpty(useSimpleTypeStr)) {
            this.useSimpleType = Boolean.valueOf(useSimpleTypeStr);
        }
        this.enumAsSimpleType = Boolean.valueOf(properties.getProperty("enumAsSimpleType"));
        String simpleTypes = properties.getProperty("simpleTypes");
        if (StringUtil.isNotEmpty(simpleTypes)) {
            SimpleTypeUtil.registerSimpleType(simpleTypes);
        }
        if (Boolean.valueOf(properties.getProperty("usePrimitiveType")).booleanValue()) {
            SimpleTypeUtil.registerPrimitiveTypes();
        }
        if (StringUtil.isNotEmpty(styleStr = properties.getProperty("style"))) {
            try {
                this.style = Style.valueOf(styleStr);
            }
            catch (IllegalArgumentException e) {
                throw new MapperException(styleStr + "\u4e0d\u662f\u5408\u6cd5\u7684Style\u503c!");
            }
        } else {
            this.style = Style.camelhump;
        }
        String wrapKeyword = properties.getProperty("wrapKeyword");
        if (StringUtil.isNotEmpty(wrapKeyword)) {
            this.wrapKeyword = wrapKeyword;
        }
        this.safeDelete = Boolean.valueOf(properties.getProperty("safeDelete"));
        this.safeUpdate = Boolean.valueOf(properties.getProperty("safeUpdate"));
        this.useJavaType = Boolean.valueOf(properties.getProperty("useJavaType"));
    }
}

