/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.worker.persistence;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.commons.io.FileUtils;
import org.h2.Driver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.powerjob.common.utils.CommonUtils;
import tech.powerjob.worker.common.constants.StoreStrategy;

public class ConnectionFactory {
    private static final Logger log = LoggerFactory.getLogger(ConnectionFactory.class);
    private volatile DataSource dataSource;
    private final String H2_PATH = System.getProperty("user.home") + "/powerjob/worker/h2/" + CommonUtils.genUUID() + "/";
    private final String DISK_JDBC_URL = String.format("jdbc:h2:file:%spowerjob_worker_db;DB_CLOSE_DELAY=-1;DATABASE_TO_UPPER=false", this.H2_PATH);
    private final String MEMORY_JDBC_URL = String.format("jdbc:h2:mem:%spowerjob_worker_db;DB_CLOSE_DELAY=-1;DATABASE_TO_UPPER=false", this.H2_PATH);

    public Connection getConnection() throws SQLException {
        return this.dataSource.getConnection();
    }

    public synchronized void initDatasource(StoreStrategy strategy) {
        strategy = strategy == null ? StoreStrategy.DISK : strategy;
        HikariConfig config = new HikariConfig();
        config.setDriverClassName(Driver.class.getName());
        config.setJdbcUrl(strategy == StoreStrategy.DISK ? this.DISK_JDBC_URL : this.MEMORY_JDBC_URL);
        config.setAutoCommit(true);
        config.setMinimumIdle(2);
        config.setMaximumPoolSize(32);
        this.dataSource = new HikariDataSource(config);
        log.info("[PowerDatasource] init h2 datasource successfully, use url: {}", (Object)config.getJdbcUrl());
        try {
            FileUtils.forceDeleteOnExit((File)new File(this.H2_PATH));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

